/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.logging.Logging;
import com.ca.mat.rowmodels.XMLFileRowModel;
import com.ca.mat.views.IMATView;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class RemoteXMLFilesView
extends ViewPart
implements IDoubleClickListener,
IMATView {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private IMATTableViewer viewer;
    public static final String ID = "com.ca.mat.views.localxmlfilesview";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.localview";
    private static final String ANALYZE = "com.ca.mat.commands.analyzelocal";
    public static final String VIEWER_MEMENTO_TYPE = "localXMLFiles.viewer";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.viewer = MATTableViewerFactory.createNew(parent, 66306);
        this.viewer.addColumn("Profile", 5, null, 1);
        this.viewer.addColumn("DSN", 6, null, 1);
        this.viewer.addDoubleClickListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.refreshModel();
    }

    public void refreshModel() {
        final MATTableModel model = new MATTableModel();
        Path path = new Path(System.getProperty("com.ca.mat.server.xmlrepositorydir"));
        File f = path.toFile();
        this.populateModel(f, model, true);
        this.viewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RemoteXMLFilesView.this.viewer.setCATableModel(model);
            }
        });
    }

    private void populateModel(File dir, MATTableModel model, boolean top) {
        if (dir.exists() && dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.toString() != null && !file.toString().equals("") && (file.getName().endsWith(".xml") || file.isDirectory())) {
                    if (file.isDirectory()) {
                        this.populateModel(file, model, false);
                    } else {
                        model.addRow(new XMLFileRowModel(model, file.toString(), top ? null : dir.getName()));
                    }
                }
                ++n2;
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void doubleClick(DoubleClickEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            service.executeCommand(ANALYZE, null);
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Autonavigation failed", e);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public IMATTableViewer getViewer() {
        return this.viewer;
    }
}

