/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels.tuntables;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.utils.HexUtil;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class StatementRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String LISTID = "listId";
    Logger log = Logger.getLogger(this.getClass().getName());
    private String listId = "";
    private String offset = "";
    private Integer statement = null;
    private String sourceLine = "";

    public StatementRowModel() {
        super(null);
    }

    public StatementRowModel(MATTableModel model) {
        super(model);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        StatementRowModel result = new StatementRowModel(model);
        String value = attr.getValue("LISTID");
        if (value != null) {
            result.listId = value.trim();
        }
        if ((value = attr.getValue("OFFMAP")) != null) {
            result.offset = value.trim();
        }
        if ((value = attr.getValue("LINENR")) != null) {
            result.statement = Integer.valueOf(value);
        }
        if ((value = attr.getValue("VERB")) != null) {
            result.sourceLine = value.trim();
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.listId, this.offset, this.statement, this.sourceLine};
    }

    public Integer getStatement() {
        return this.statement;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    public String getOffset() {
        return this.offset;
    }

    public String getOffsetHex() {
        if (this.offset == null) {
            return null;
        }
        return HexUtil.toHex(Integer.valueOf(this.offset), 3);
    }

    public Object getId() {
        return this.listId;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (LISTID.equals(fieldName)) {
            return this.listId != null && this.listId.equals(value);
        }
        throw new IllegalArgumentException("field name unknown or null: " + fieldName);
    }
}

