/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class CodeView4GLRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = CodeViewRowModel.class.getName();
    public static final String LANGUAGE = "xlang";
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private String xlang = "";
    private String xlibrid = "";
    private String xsystid = "";
    private String xroutine = "";
    private String xpgmver = "";
    private String xsrcvr = "";
    private Double tcpu = null;
    private Double twait = null;
    private Double dtot = null;
    private String xfunc = "";
    private String locationName;

    public CodeView4GLRowModel() {
        this(null, "");
    }

    public CodeView4GLRowModel(MATTableModel dataset, String locationName) {
        super(dataset);
        this.locationName = locationName;
    }

    @Override
    protected Object[] getArray() {
        if (this.xlang != null && this.xlang.equals("IDEAL")) {
            return new Object[]{this.xlang, this.xsystid, this.xroutine, this.xpgmver, this.xsrcvr, this.tcpu, this.twait, this.dtot, this.xfunc};
        }
        return new Object[]{this.xlang, this.xlibrid, this.xroutine, this.tcpu, this.twait, this.dtot, this.xfunc};
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel dataset, String datasetName) {
        CodeView4GLRowModel result = new CodeView4GLRowModel(dataset, datasetName);
        String value = null;
        value = attr.getValue("XLANG");
        if (value != null) {
            result.xlang = value.trim();
        }
        if ((value = attr.getValue("XLIBRID")) != null) {
            result.xlibrid = value.trim();
        }
        if ((value = attr.getValue("XSYSTID")) != null) {
            result.xsystid = value.trim();
        }
        if ((value = attr.getValue("XROUTINE")) != null) {
            result.xroutine = value.trim();
        }
        if ((value = attr.getValue("XPGMVER")) != null) {
            result.xpgmver = value.trim();
        }
        if ((value = attr.getValue("XSRCVR")) != null) {
            result.xsrcvr = value.trim();
        }
        if ((value = attr.getValue("TCPU")) != null) {
            result.tcpu = Double.valueOf(value);
        }
        if ((value = attr.getValue("TWAIT")) != null) {
            result.twait = Double.valueOf(value);
        }
        if ((value = attr.getValue("DTOT")) != null) {
            result.dtot = Double.valueOf(value);
        }
        if ((value = attr.getValue("XFUNC")) != null) {
            result.xfunc = value.trim();
        }
        return result;
    }

    public String getLanguage() {
        return this.xlang;
    }

    public String getLibrary() {
        return this.xlibrid;
    }

    public String getRoutine() {
        return this.xroutine;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (LANGUAGE.equals(fieldName)) {
            return this.xlang != null && this.xlang.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public Double getTotal() {
        return this.dtot;
    }

    public String getSystem() {
        return this.xsystid;
    }

    public String getObjectVersion() {
        return this.xpgmver;
    }

    public String getSourceVersion() {
        return this.xsrcvr;
    }
}

