/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.DB2ExplainRulesList;
import com.ca.mat.managers.ListingManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallStackInfoRowModel;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.DB2ViewRowModel;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.DelayViewRowModel;
import com.ca.mat.rowmodels.DelayedResourceRowModel;
import com.ca.mat.rowmodels.ExplainInformationStmtRowModel;
import com.ca.mat.rowmodels.ExplainStmtRowModel;
import com.ca.mat.rowmodels.HistogramRowModel;
import com.ca.mat.rowmodels.IDMSViewRowModel;
import com.ca.mat.rowmodels.IMSStatementRowModel;
import com.ca.mat.rowmodels.JVMInfoRowModel;
import com.ca.mat.rowmodels.LinkSuggestionsRowModel;
import com.ca.mat.rowmodels.ListingVerbsRowModel;
import com.ca.mat.rowmodels.LongNameTableRowModel;
import com.ca.mat.rowmodels.ModuleCsectInfoRowModel;
import com.ca.mat.rowmodels.TimeViewRowModel;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.rowmodels.USSProcess2InitMap;
import com.ca.mat.rowmodels.USSViewFunctionsRowModel;
import com.ca.mat.rowmodels.USSViewRowModel;
import com.ca.mat.rowmodels.WASTranDelayRowModel;
import com.ca.mat.rowmodels.tuntables.Tun4GLSRowModel;
import com.ca.mat.rowmodels.tuntables.TuncsectRowModel;
import com.ca.mat.rowmodels.tuntables.TundelayRowModel;
import com.ca.mat.rowmodels.tuntables.TundescRowModel;
import com.ca.mat.rowmodels.tuntables.TunexplRowModel;
import com.ca.mat.rowmodels.tuntables.TunmodlRowModel;
import com.ca.mat.rowmodels.tuntables.TunpsedoRowModel;
import com.ca.mat.utils.HexUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class AnalysisUtils {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public static MATTableModel resizeHistogram(MATTableModel histogram, int newLength) {
        int offset = 0;
        long position = 0L;
        long maxPosition = 0L;
        String csect = "";
        HashMap<Long, HistogramRowModel> resultRows = new HashMap<Long, HistogramRowModel>();
        MATTableRow[] mATTableRowArray = histogram.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            HistogramRowModel histRow = (HistogramRowModel)row;
            csect = histRow.getCSECT();
            offset = Integer.parseInt(histRow.getOffset(), 16);
            position = offset / newLength;
            if (histRow.getDelay() > 0.0) {
                if (resultRows.get(position) == null) {
                    HistogramRowModel newRow = new HistogramRowModel(true);
                    newRow.setCSECT(csect);
                    newRow.setOffset(Long.toString(position * (long)newLength, 16).toUpperCase());
                    newRow.setLength(newLength);
                    newRow.setStatement(histRow.getStatement());
                    resultRows.put(position, newRow);
                }
                ((HistogramRowModel)resultRows.get(position)).addRow(histRow);
            }
            if (position > maxPosition) {
                maxPosition = position;
            }
            ++n2;
        }
        MATTableModel result = new MATTableModel();
        int emptyInterval = 0;
        long i = 0L;
        while (i <= maxPosition) {
            if (resultRows.get(i) == null) {
                emptyInterval += newLength;
            } else {
                if (emptyInterval > 0) {
                    long offsetInt = i * (long)newLength - (long)emptyInterval;
                    HistogramRowModel emptyRow = new HistogramRowModel(true);
                    emptyRow.setLength(emptyInterval);
                    emptyRow.setOffset(Long.toString(offsetInt, 16).toUpperCase());
                    emptyRow.setCSECT(csect);
                    result.addRow(emptyRow);
                    emptyInterval = 0;
                }
                result.addRow((MATTableRow)resultRows.get(i));
            }
            ++i;
        }
        return result;
    }

    public static MATTableModel calculateHistogramStatement(MATTableModel timeView, String module, String csect, String dsn, int analysisType, Display display) {
        if (timeView == null) {
            return null;
        }
        MATTableModel result = new MATTableModel(dsn);
        HashMap<Integer, HistogramRowModel> resultRows = new HashMap<Integer, HistogramRowModel>();
        HashMap<String, ListingVerbsRowModel> statements = new HashMap<String, ListingVerbsRowModel>();
        MATTableModel csectInfo = Singletons.getAnalysisManager(display).getModel(dsn, "Module-Csect Info", 1);
        MATTableModel statementTable = AnalysisUtils.getStatementTable(dsn, csect, true, Singletons.getListingManager(display), csectInfo);
        int rowCount = Singletons.getAnalysisManager(display).getSampleCount(dsn, analysisType);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeViewRowModel timeRow;
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel && csect.equals((timeRow = (TimeViewRowModel)row).getCsect()) && module.equals(timeRow.getModule())) {
                HistogramRowModel histogramRow;
                ListingVerbsRowModel statementRow;
                String offset = timeRow.getOffset();
                if (statements.containsKey(offset)) {
                    statementRow = (ListingVerbsRowModel)statements.get(offset);
                } else {
                    statementRow = AnalysisUtils.getStatement(dsn, module, csect, offset, statementTable);
                    if (statementRow == null) {
                        return null;
                    }
                    statements.put(offset, statementRow);
                }
                if (!resultRows.containsKey(statementRow.getLine())) {
                    histogramRow = AnalysisUtils.createHistogramRow(result, module, csect, offset, statementRow.getLine(), statementRow.getVerb());
                    resultRows.put(statementRow.getLine(), histogramRow);
                } else {
                    histogramRow = (HistogramRowModel)resultRows.get(statementRow.getLine());
                }
                if (timeRow.getStatus().equals("A")) {
                    histogramRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount);
                } else if (timeRow.getStatus().equals("W")) {
                    histogramRow.addPercent(0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount);
                } else {
                    histogramRow.addPercent(0.0, 0.0, 0.0);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static boolean csectHasStatements(String dsn, String csect) {
        return Singletons.getListingManager().hasListing(csect);
    }

    private static MATTableModel getStatementTable(String dsn, String csect, boolean showWarning, ListingManager lManager, MATTableModel csectInfo) {
        String compileTime = AnalysisUtils.getCsectCompileTime(dsn, csect, csectInfo);
        int size = AnalysisUtils.getCsectSize(dsn, csect, csectInfo);
        MATTableModel statementTable = lManager.getVerbs(csect);
        if (statementTable != null && showWarning) {
            int listingSize;
            String listingTime = lManager.getListingCompileDate(csect);
            if (!listingTime.equals(compileTime)) {
                MessageDialog.openInformation(null, (String)"Dates do not match", (String)("Dates do not match - The date the monitored program was compiled, " + compileTime + ", and the date of compilation of the registered listing, " + listingTime + ", do not match. This may cause misleading or inaccurate information to be displayed."));
                showWarning = false;
            }
            try {
                listingSize = Integer.valueOf(lManager.getListingSize(csect), 16);
            }
            catch (NumberFormatException numberFormatException) {
                listingSize = 0;
            }
            if (listingSize % 8 != 0) {
                listingSize = (listingSize / 8 + 1) * 8;
            }
            if (size % 8 != 0) {
                size = (size / 8 + 1) * 8;
            }
            if (listingSize != size) {
                MessageDialog.openInformation(null, (String)"Sizes do not match", (String)("Sizes do not match - The program size, " + Integer.toString(size, 16) + ", and the listing size, " + Integer.toString(listingSize, 16) + ", do not  match.  This may cause misleading or inaccurate information to be displayed."));
            }
        }
        return statementTable;
    }

    public static ListingVerbsRowModel getStatement(String dsn, String module, String csect, String offset, MATTableModel statementTable) {
        if (statementTable != null) {
            long argOffsetLong;
            try {
                argOffsetLong = Long.valueOf(offset, 16);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            long minOffset = Long.MAX_VALUE;
            ListingVerbsRowModel minStatement = null;
            int i = 0;
            while (i < statementTable.getRows().length) {
                MATTableRow row = statementTable.getRows()[i];
                if (row instanceof ListingVerbsRowModel) {
                    ListingVerbsRowModel statementRow = (ListingVerbsRowModel)row;
                    long rowOffsetLong = Long.valueOf(statementRow.getOffset());
                    if (rowOffsetLong <= argOffsetLong) {
                        while (i < statementTable.getRows().length - 1) {
                            ListingVerbsRowModel nextRow = (ListingVerbsRowModel)statementTable.getRows()[++i];
                            if (statementRow.getOffset().equals(nextRow.getOffset())) continue;
                            return (ListingVerbsRowModel)statementTable.getRows()[i - 1];
                        }
                    }
                    if (minOffset > rowOffsetLong) {
                        minOffset = rowOffsetLong;
                        minStatement = statementRow;
                    }
                }
                ++i;
            }
            if (argOffsetLong < minOffset) {
                return minStatement;
            }
        }
        return null;
    }

    public static ListingVerbsRowModel getStatementIdeal(String dsn, Integer offset, MATTableModel statementTable) {
        if (statementTable != null) {
            int closestOffset = 0;
            ListingVerbsRowModel result = null;
            MATTableRow[] mATTableRowArray = statementTable.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListingVerbsRowModel statementRow;
                int rowOffset;
                MATTableRow row = mATTableRowArray[n2];
                if (row instanceof ListingVerbsRowModel && (rowOffset = Integer.valueOf((statementRow = (ListingVerbsRowModel)row).getOffset()).intValue()) < offset && rowOffset > closestOffset) {
                    closestOffset = rowOffset;
                    result = statementRow;
                }
                ++n2;
            }
            return result;
        }
        return null;
    }

    public static String getCsectCompileTime(String dsn, String csect, MATTableModel csectInfo) {
        if (csectInfo != null) {
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("cscsect", new Object[]{csect});
            csectInfo = csectInfo.filterBy(arguments);
            if (!csectInfo.isEmpty()) {
                ModuleCsectInfoRowModel info = (ModuleCsectInfoRowModel)csectInfo.getRows()[0];
                return info.getCompileDate();
            }
        }
        return null;
    }

    public static int getCsectSize(String dsn, String csect, MATTableModel csectInfo) {
        if (csectInfo != null) {
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("cscsect", new Object[]{csect});
            csectInfo = csectInfo.filterBy(arguments);
            if (!csectInfo.isEmpty()) {
                ModuleCsectInfoRowModel info = (ModuleCsectInfoRowModel)csectInfo.getRows()[0];
                try {
                    return Integer.valueOf(info.getCSECTLength(), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public static MATTableModel calculateHistogram4GL(MATTableModel tun4gl, String dsn, String routine, int analysisType, String language, Display display) {
        if (tun4gl == null) {
            return null;
        }
        int sampleCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableModel csectInfo = Singletons.getAnalysisManager().getModel(dsn, "Module-Csect Info", 1);
        MATTableModel result = new MATTableModel(dsn);
        MATTableModel statementTable = language.equals("IDEAL") ? Singletons.getListingManager().getVerbsIdeal(dsn, routine) : AnalysisUtils.getStatementTable(dsn, routine, false, Singletons.getListingManager(), csectInfo);
        HashMap<Integer, HistogramRowModel> resultRows = new HashMap<Integer, HistogramRowModel>();
        MATTableRow[] mATTableRowArray = tun4gl.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof Tun4GLSRowModel) {
                Tun4GLSRowModel tun4glRow = (Tun4GLSRowModel)row;
                Integer statement = tun4glRow.getStatement();
                String sourceLine = tun4glRow.getSourceLine();
                HistogramRowModel histogramRow = null;
                ListingVerbsRowModel statementRow = null;
                if (language.equals("IDEAL") && (statementRow = AnalysisUtils.getStatementIdeal(dsn, statement, statementTable)) != null) {
                    statement = statementRow.getLine();
                }
                if (!resultRows.containsKey(statement)) {
                    histogramRow = AnalysisUtils.createHistogramRow(result, tun4glRow.getRoutine(), "", null, statement, sourceLine);
                    if (language.equals("IDEAL")) {
                        if (statementRow == null) {
                            histogramRow.setSourceLine("Offset is outside listing range");
                        } else {
                            histogramRow.setSourceLine(statementRow.getVerb());
                        }
                    }
                    resultRows.put(statement, histogramRow);
                } else {
                    histogramRow = (HistogramRowModel)resultRows.get(statement);
                }
                double cpuPct = tun4glRow.getCPU() * 100.0 / (double)sampleCount;
                double waitPct = tun4glRow.getWait() * 100.0 / (double)sampleCount;
                if (analysisType == 1) {
                    histogramRow.addPercent(cpuPct, waitPct, cpuPct + waitPct);
                }
                if (analysisType == 0) {
                    histogramRow.addPercent(cpuPct, waitPct, cpuPct + waitPct);
                }
                if (analysisType == 2) {
                    histogramRow.addPercent(cpuPct, 0.0, cpuPct);
                }
                if (analysisType == 3) {
                    histogramRow.addPercent(0.0, waitPct, waitPct);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static MATTableModel normalizeHistogram(MATTableModel original, Double totalDelay) {
        HistogramRowModel histRow;
        MATTableRow row;
        MATTableModel result = new MATTableModel();
        MATTableRow[] mATTableRowArray = original.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            row = mATTableRowArray[n2];
            histRow = (HistogramRowModel)row;
            result.addRow(histRow.clone());
            ++n2;
        }
        mATTableRowArray = result.getRows();
        n = mATTableRowArray.length;
        n2 = 0;
        while (n2 < n) {
            row = mATTableRowArray[n2];
            histRow = (HistogramRowModel)row;
            histRow.normalize(totalDelay);
            ++n2;
        }
        return result;
    }

    public static MATTableModel changeCodeViewMode(MATTableModel csectModel, String mode, String dsn) {
        if (CodeViewRowModel.TYPE_CSECT.equals(mode)) {
            return csectModel;
        }
        if (CodeViewRowModel.TYPE_MODULE.equals(mode) || CodeViewRowModel.TYPE_PSEUDO.equals(mode)) {
            HashMap<String, CodeViewRowModel> resultRows = new HashMap<String, CodeViewRowModel>();
            MATTableRow[] mATTableRowArray = csectModel.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                CodeViewRowModel codeRow = (CodeViewRowModel)row;
                String key = "";
                if (CodeViewRowModel.TYPE_MODULE.equals(mode)) {
                    key = codeRow.getModule();
                }
                if (CodeViewRowModel.TYPE_PSEUDO.equals(mode)) {
                    key = codeRow.getPseudoGroup();
                }
                if (resultRows.get(key) == null) {
                    CodeViewRowModel clone = codeRow.clone();
                    clone.setType(mode);
                    resultRows.put(key, clone);
                } else {
                    ((CodeViewRowModel)resultRows.get(key)).addRow(codeRow);
                }
                if (codeRow.hasCallerId()) {
                    ((CodeViewRowModel)resultRows.get(key)).setHasCallerId(true);
                }
                if (codeRow.hasExtendedCallerId()) {
                    ((CodeViewRowModel)resultRows.get(key)).setHasExtendedCallerId(true);
                }
                ++n2;
            }
            MATTableModel result = new MATTableModel(dsn);
            for (Map.Entry entry : resultRows.entrySet()) {
                result.addRow((MATTableRow)entry.getValue());
            }
            return result;
        }
        throw new IllegalArgumentException(String.format("Invalid CodeView mode : %s", mode));
    }

    public static MATTableModel aggregateDBD(MATTableModel model, String dsn) {
        HashMap<String, IMSStatementRowModel> resultRows = new HashMap<String, IMSStatementRowModel>();
        MATTableRow[] mATTableRowArray = model.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            IMSStatementRowModel statementRow = (IMSStatementRowModel)row;
            String key = statementRow.getDBD();
            if (resultRows.get(key) == null) {
                IMSStatementRowModel clone = statementRow.clone();
                clone.setType(1);
                resultRows.put(key, clone);
            } else {
                ((IMSStatementRowModel)resultRows.get(key)).addRow(statementRow);
            }
            ++n2;
        }
        MATTableModel result = new MATTableModel(dsn);
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static MATTableModel aggregateJVM(MATTableModel jvm, String groupingKey, String dataMode, String displayMode, String dsn) {
        HashMap<String, JVMInfoRowModel> resultRows = new HashMap<String, JVMInfoRowModel>();
        MATTableRow[] mATTableRowArray = jvm.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            JVMInfoRowModel jvmRow = (JVMInfoRowModel)row;
            String key = "";
            jvmRow.setDataMode(dataMode);
            if (groupingKey.equals("group_by_process")) {
                key = jvmRow.getProcessId();
            } else if (groupingKey.equals("group_by_method")) {
                key = jvmRow.getMethodId();
            } else if (groupingKey.equals("group_by_thread")) {
                key = jvmRow.getThread();
            } else if (groupingKey.equals("group_by_line")) {
                key = jvmRow.getLine();
            } else {
                throw new IllegalArgumentException(String.format("Unsupported grouping key for JVM (key=%s)", groupingKey));
            }
            if (resultRows.get(key) == null) {
                JVMInfoRowModel clone = jvmRow.clone();
                if (dataMode != null) {
                    clone.setDataMode(dataMode);
                }
                if (displayMode != null) {
                    clone.setDisplayMode(displayMode);
                }
                resultRows.put(key, clone);
            } else {
                ((JVMInfoRowModel)resultRows.get(key)).addRow(jvmRow);
            }
            ++n2;
        }
        MATTableModel result = new MATTableModel(dsn);
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static MATTableModel aggregateWAS(MATTableModel was, String groupingKey, String dataMode, String displayMode, String dsn) {
        HashMap<String, WASTranDelayRowModel> resultRows = new HashMap<String, WASTranDelayRowModel>();
        MATTableRow[] mATTableRowArray = was.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            WASTranDelayRowModel wasRow = (WASTranDelayRowModel)row;
            String key = "";
            wasRow.setDataMode(dataMode);
            if (groupingKey.equals("group_by_class_method_line")) {
                key = String.valueOf(wasRow.getClassName()) + "," + wasRow.getMethodName() + "," + wasRow.getLine();
            } else if (groupingKey.equals("group_by_delay")) {
                key = wasRow.getDelay();
            } else if (groupingKey.equals("group_by_tran")) {
                key = wasRow.getTran();
            } else {
                throw new IllegalArgumentException(String.format("Unsupported grouping key for WAS (key=%s)", groupingKey));
            }
            if (resultRows.get(key) == null) {
                WASTranDelayRowModel clone = wasRow.clone();
                if (dataMode != null) {
                    clone.setDataMode(dataMode);
                }
                if (displayMode != null) {
                    clone.setDisplayMode(displayMode);
                }
                resultRows.put(key, clone);
            } else {
                ((WASTranDelayRowModel)resultRows.get(key)).addRow(wasRow);
            }
            ++n2;
        }
        MATTableModel result = new MATTableModel(dsn);
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static MATTableModel aggregateUSS(MATTableModel uss, String groupingKey, String displayMode, String dsn) {
        HashMap<String, USSViewFunctionsRowModel> resultRows = new HashMap<String, USSViewFunctionsRowModel>();
        MATTableRow[] mATTableRowArray = uss.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            USSViewFunctionsRowModel ussRow = (USSViewFunctionsRowModel)row;
            String key = "";
            if (groupingKey.equals("group_by_thread")) {
                key = ussRow.getThreadId();
            } else if (groupingKey.equals("group_by_function")) {
                key = ussRow.getFunction();
            } else {
                throw new IllegalArgumentException(String.format("Unsupported grouping key for USS (key=%s)", groupingKey));
            }
            if (resultRows.get(key) == null) {
                USSViewFunctionsRowModel clone = ussRow.clone();
                if (displayMode != null) {
                    clone.setDisplayMode(displayMode);
                }
                resultRows.put(key, clone);
            } else {
                ((USSViewFunctionsRowModel)resultRows.get(key)).addRow(ussRow);
            }
            ++n2;
        }
        MATTableModel result = new MATTableModel(dsn);
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static MATTableModel changeIDMSModel(MATTableModel moduleModel, String mode, String dsn) {
        if (moduleModel == null) {
            return null;
        }
        if (IDMSViewRowModel.TYPE_MODULE.equals(mode)) {
            return moduleModel;
        }
        if (IDMSViewRowModel.TYPE_TASK.equals(mode)) {
            HashMap<String, IDMSViewRowModel> resultRows = new HashMap<String, IDMSViewRowModel>();
            MATTableRow[] mATTableRowArray = moduleModel.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                IDMSViewRowModel codeRow = (IDMSViewRowModel)row;
                String key = "";
                if (IDMSViewRowModel.TYPE_TASK.equals(mode)) {
                    key = codeRow.getTaskcode();
                }
                if (resultRows.get(key) == null) {
                    IDMSViewRowModel clone = codeRow.clone();
                    clone.setType(mode);
                    resultRows.put(key, clone);
                } else {
                    ((IDMSViewRowModel)resultRows.get(key)).addRow(codeRow);
                }
                ++n2;
            }
            MATTableModel result = new MATTableModel(dsn);
            for (Map.Entry entry : resultRows.entrySet()) {
                result.addRow((MATTableRow)entry.getValue());
            }
            return result;
        }
        throw new IllegalArgumentException(String.format("Invalid IDMS mode : %s", mode));
    }

    public static MATTableModel callerIdSwap(MATTableModel timeView, String[] modules, String[] csects, String dsn, boolean swapEmptyCaller) {
        if (timeView == null) {
            return null;
        }
        Pattern[] modulePatterns = new Pattern[modules.length];
        int i = 0;
        while (i < modules.length) {
            if (modules[i] != null && !modules[i].isEmpty()) {
                try {
                    modulePatterns[i] = Pattern.compile(AnalysisUtils.composeRegex(modules[i]));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    modulePatterns[i] = null;
                }
            }
            ++i;
        }
        Pattern[] csectPatterns = new Pattern[csects.length];
        int i2 = 0;
        while (i2 < csects.length) {
            if (csects[i2] != null && !csects[i2].isEmpty()) {
                try {
                    csectPatterns[i2] = Pattern.compile(AnalysisUtils.composeRegex(csects[i2]));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    csectPatterns[i2] = null;
                }
            }
            ++i2;
        }
        MATTableModel result = new MATTableModel(dsn);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel) {
                TimeViewRowModel timeRow = (TimeViewRowModel)row;
                TimeViewRowModel newRow = timeRow.clone();
                Pattern[] patternArray = modulePatterns;
                int n3 = modulePatterns.length;
                int n4 = 0;
                while (n4 < n3) {
                    Pattern modPattern = patternArray[n4];
                    if (modPattern != null && modPattern.matcher(newRow.getModule()).matches()) {
                        newRow.callerIdSwap(swapEmptyCaller);
                        break;
                    }
                    ++n4;
                }
                patternArray = csectPatterns;
                n3 = csectPatterns.length;
                n4 = 0;
                while (n4 < n3) {
                    Pattern csectPattern = patternArray[n4];
                    if (csectPattern != null && csectPattern.matcher(newRow.getCsect()).matches()) {
                        newRow.callerIdSwap(swapEmptyCaller);
                        break;
                    }
                    ++n4;
                }
                result.addRow(newRow);
            }
            ++n2;
        }
        return result;
    }

    private static String composeRegex(String expression) {
        StringBuilder regex = new StringBuilder(expression.length() + 20);
        regex.append(expression);
        Object[][] objectArrayArray = new Object[][]{{"\\", "\\\\"}, {".", "\\."}, {"[", "\\["}, {"^", "\\^"}, {"|", "\\|"}, {"+", "\\+"}, {"$", "\\$"}, {"*", ".*"}, {"%", "[0-9]"}, {"?", "."}};
        int n = objectArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] item = objectArrayArray[n2];
            int ix = 0;
            while ((ix = regex.indexOf((String)item[0], ix)) != -1) {
                regex.replace(ix++, ix++, (String)item[1]);
            }
            ++n2;
        }
        expression = "^" + regex.toString() + "$";
        return expression;
    }

    public static MATTableModel calculateCodeView(MATTableModel timeView, String dsn, int analysisType) {
        if (timeView == null) {
            return null;
        }
        MATTableModel pseudoTable = Singletons.getAnalysisManager().getStaticModel("TUNPSEDO");
        MATTableModel descTable = Singletons.getAnalysisManager().getStaticModel("TUNDESC");
        MATTableModel moduleTable = Singletons.getAnalysisManager().getModel(dsn, "TUNMODL", 1);
        MATTableModel longnameTable = Singletons.getAnalysisManager().getModel(dsn, "Long Name Table", analysisType);
        MATTableModel result = new MATTableModel(dsn);
        HashMap<String, Map<String, CodeViewRowModel>> resultRows = new HashMap<String, Map<String, CodeViewRowModel>>();
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel) {
                CodeViewRowModel codeRow;
                Map<String, CodeViewRowModel> moduleMap;
                TimeViewRowModel timeRow = (TimeViewRowModel)row;
                String module = timeRow.getModule();
                String csect = timeRow.getCsect();
                if (!resultRows.containsKey(module)) {
                    moduleMap = new HashMap();
                    resultRows.put(module, moduleMap);
                } else {
                    moduleMap = (Map)resultRows.get(module);
                }
                if (!moduleMap.containsKey(csect)) {
                    codeRow = AnalysisUtils.createCodeViewRow(result, module, csect, descTable, pseudoTable, moduleTable, longnameTable);
                    moduleMap.put(csect, codeRow);
                } else {
                    codeRow = (CodeViewRowModel)moduleMap.get(csect);
                }
                if (timeRow.getStatus().equals("A")) {
                    if (timeRow.getIOStat().equals("I")) {
                        codeRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount);
                    } else {
                        codeRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount, 0.0);
                    }
                } else if (timeRow.getStatus().equals("W")) {
                    codeRow.addPercent(0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount, 0.0);
                } else if (timeRow.getStatus().equals("I")) {
                    codeRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount);
                }
                if (timeRow.getCallerModule() != null && !timeRow.getCallerModule().isEmpty()) {
                    codeRow.setHasCallerId(true);
                }
                if (timeRow.getCallerApplicationModule() != null && !timeRow.getCallerApplicationModule().isEmpty()) {
                    codeRow.setHasExtendedCallerId(true);
                }
                if (timeRow.getCallerCurrentModule() != null && !timeRow.getCallerCurrentModule().isEmpty()) {
                    codeRow.setHasExtendedCallerId(true);
                }
                if (timeRow.getCallerViaModule() != null && !timeRow.getCallerViaModule().isEmpty()) {
                    codeRow.setHasExtendedCallerId(true);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                result.addRow((MATTableRow)entry2.getValue());
            }
        }
        return result;
    }

    private static CodeViewRowModel createCodeViewRow(MATTableModel model, String module, String csect, MATTableModel descTable, MATTableModel pseudoTable, MATTableModel moduleTable, MATTableModel longnameTable) {
        String[] descriptions = AnalysisUtils.getDescriptions(module, csect, descTable, pseudoTable, longnameTable);
        String pseudo = descriptions[0];
        String pseudoDesc = descriptions[1];
        String moduleDesc = descriptions[2];
        String csectDesc = descriptions[3];
        String loc = "";
        if (moduleTable != null) {
            MATTableRow[] mATTableRowArray = moduleTable.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                TunmodlRowModel moduleRow;
                MATTableRow r = mATTableRowArray[n2];
                if (r instanceof TunmodlRowModel && (moduleRow = (TunmodlRowModel)r).getModuleName().equals(module)) {
                    loc = Integer.valueOf(moduleRow.getAddress(), 16) > 0xFFFFFF ? "A" : "B";
                }
                ++n2;
            }
        }
        return new CodeViewRowModel(model, "calculated", module, moduleDesc, csect, csectDesc, pseudo, pseudoDesc, loc, "", "");
    }

    public static MATTableModel calculateCallerId(MATTableModel timeView, String dsn, int analysisType, Display display) {
        if (timeView == null) {
            return null;
        }
        ListingManager lManager = Singletons.getListingManager();
        MATTableModel descTable = Singletons.getAnalysisManager().getStaticModel("TUNDESC");
        MATTableModel pseudoTable = Singletons.getAnalysisManager().getStaticModel("TUNPSEDO");
        MATTableModel longnameTable = Singletons.getAnalysisManager().getModel(dsn, "Long Name Table", analysisType);
        MATTableModel csectInfo = Singletons.getAnalysisManager().getModel(dsn, "Module-Csect Info", analysisType);
        MATTableModel result = new MATTableModel(dsn);
        HashMap resultRows = new HashMap();
        HashMap<Integer, CallerIdRowModel> statementMap = new HashMap<Integer, CallerIdRowModel>();
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel) {
                CallerIdRowModel callerRow;
                Map<String, CallerIdRowModel> csectMap;
                Map moduleMap;
                TimeViewRowModel timeRow = (TimeViewRowModel)row;
                String module = timeRow.getCallerModule();
                String csect = timeRow.getCallerCsect();
                String offset = timeRow.getCallerOffset();
                if (!resultRows.containsKey(module)) {
                    moduleMap = new HashMap();
                    resultRows.put(module, moduleMap);
                } else {
                    moduleMap = (Map)resultRows.get(module);
                }
                if (!moduleMap.containsKey(csect)) {
                    csectMap = new HashMap();
                    moduleMap.put(csect, csectMap);
                } else {
                    csectMap = (Map)moduleMap.get(csect);
                }
                if (!csectMap.containsKey(offset)) {
                    MATTableModel statementTable = AnalysisUtils.getStatementTable(dsn, csect, false, lManager, csectInfo);
                    ListingVerbsRowModel statementRow = AnalysisUtils.getStatement(dsn, module, csect, offset, statementTable);
                    if (statementRow != null && statementMap.get(statementRow.getLine()) != null) {
                        callerRow = (CallerIdRowModel)statementMap.get(statementRow.getLine());
                        try {
                            Integer intOffset = Integer.valueOf(offset, 16);
                            Integer intRowOffset = Integer.valueOf(callerRow.getOutOffset(), 16);
                            if (intOffset < intRowOffset) {
                                callerRow.setOutOffset(HexUtil.toHex(intOffset, 4));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        callerRow = AnalysisUtils.createCallerIdRow(result, module, csect, offset, descTable, pseudoTable, longnameTable);
                        if (statementRow != null) {
                            callerRow.setStatement(statementRow.getLine());
                            statementMap.put(statementRow.getLine(), callerRow);
                        }
                        csectMap.put(offset, callerRow);
                    }
                } else {
                    callerRow = (CallerIdRowModel)csectMap.get(offset);
                }
                callerRow.addTotal(100.0 / (double)rowCount);
                if (timeRow.getStatus().equals("A")) {
                    callerRow.addActive(100.0 / (double)rowCount);
                } else {
                    callerRow.addWait(100.0 / (double)rowCount);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry innermostEntry : ((Map)entry2.getValue()).entrySet()) {
                    if (((CallerIdRowModel)innermostEntry.getValue()).getOutModule().length() <= 0) continue;
                    result.addRow((MATTableRow)innermostEntry.getValue());
                }
            }
        }
        return result;
    }

    public static MATTableModel addCallStackToCallerId(MATTableModel view, MATTableModel csView, String tranName) {
        if (view == null || csView == null) {
            return null;
        }
        MATTableRow[] mATTableRowArray = csView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (((CallStackInfoRowModel)row).getPgitran().equalsIgnoreCase(tranName)) {
                CallerIdRowModel callerIdRow = new CallerIdRowModel();
                callerIdRow.setCount(((CallStackInfoRowModel)row).getPgiccnt());
                callerIdRow.setOutcalid(((CallStackInfoRowModel)row).getPgipgm());
                callerIdRow.setOutcoff("00000000");
                view.addRow(callerIdRow);
            }
            ++n2;
        }
        return view;
    }

    public static MATTableModel calculateCallStack(MATTableModel timeView, String dsn, int analysisType, Display display, String tran) {
        if (timeView == null) {
            return null;
        }
        MATTableModel result = new MATTableModel(dsn);
        int sqn = 1;
        timeView.sortByColumn(1, true);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof CallStackInfoRowModel && ((CallStackInfoRowModel)row).getPgitran().equals(tran)) {
                ((CallStackInfoRowModel)row).setPgisqn(sqn);
                ((CallStackInfoRowModel)row).refreshRow();
                result.addRow(row);
                ++sqn;
            }
            ++n2;
        }
        return result;
    }

    public static MATTableModel initializeElapsed(MATTableModel view, MATTableModel tranView) {
        if (view == null || tranView == null) {
            return null;
        }
        MATTableModel result = view;
        view.sortByColumn(1, true);
        MATTableRow csRow = view.getRows()[0];
        MATTableRow[] mATTableRowArray = tranView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TranViewRowModel && csRow instanceof CallStackInfoRowModel && ((TranViewRowModel)row).getTransactionName().equalsIgnoreCase(((CallStackInfoRowModel)csRow).getPgitran())) {
                ((CallStackInfoRowModel)csRow).setPgieavg(((TranViewRowModel)row).getRespsec());
                ((CallStackInfoRowModel)csRow).setPgielap(((TranViewRowModel)row).getRespsec() * (double)((CallStackInfoRowModel)csRow).getPgiccnt());
            }
            ++n2;
        }
        ((CallStackInfoRowModel)csRow).refreshRow();
        return result;
    }

    public static MATTableModel calculateCallStack(MATTableModel timeView, String dsn, int analysisType, String moduleName) {
        if (timeView == null) {
            return null;
        }
        MATTableModel result = new MATTableModel(dsn);
        CallStackInfoRowModel currentRow = null;
        timeView.sortByColumn(1, true);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof CallStackInfoRowModel && ((CallStackInfoRowModel)row).getPgipgm().equalsIgnoreCase(moduleName)) {
                currentRow = (CallStackInfoRowModel)row;
                break;
            }
            ++n2;
        }
        int sqn = 1;
        MATTableRow[] mATTableRowArray2 = timeView.getRows();
        int n3 = mATTableRowArray2.length;
        n = 0;
        while (n < n3) {
            MATTableRow row = mATTableRowArray2[n];
            if (row instanceof CallStackInfoRowModel && ((CallStackInfoRowModel)row).getPgitran().equalsIgnoreCase(currentRow.getPgitran())) {
                ((CallStackInfoRowModel)row).setPgisqn(sqn);
                ((CallStackInfoRowModel)row).refreshRow();
                ++sqn;
            }
            ++n;
        }
        mATTableRowArray2 = timeView.getRows();
        n3 = mATTableRowArray2.length;
        n = 0;
        while (n < n3) {
            MATTableRow row = mATTableRowArray2[n];
            if (row instanceof CallStackInfoRowModel && ((CallStackInfoRowModel)row).getPgitran().equalsIgnoreCase(currentRow.getPgitran()) && ((CallStackInfoRowModel)row).getPgisqn() > currentRow.getPgisqn()) {
                result.addRow(row);
            }
            ++n;
        }
        return result;
    }

    private static CallerIdRowModel createCallerIdRow(MATTableModel model, String module, String csect, String offset, MATTableModel descTable, MATTableModel pseudoTable, MATTableModel longnameTable) {
        String[] descriptions = AnalysisUtils.getDescriptions(module, csect, descTable, pseudoTable, longnameTable);
        String csectDesc = descriptions[3];
        return new CallerIdRowModel(model, "calculated", module, csect, offset, "", csectDesc);
    }

    public static MATTableModel calculateHistogramBase(MATTableModel timeView, String dsn, int analysisType) {
        if (timeView == null) {
            return null;
        }
        MATTableModel result = new MATTableModel(dsn);
        HashMap resultRows = new HashMap();
        HashMap<String, Boolean> hasStatements = new HashMap<String, Boolean>();
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel) {
                HistogramRowModel histogramRow;
                Map<String, HistogramRowModel> csectMap;
                Map moduleMap;
                TimeViewRowModel timeRow = (TimeViewRowModel)row;
                String module = timeRow.getModule();
                String csect = timeRow.getCsect();
                String offset = timeRow.getOffset();
                if (!resultRows.containsKey(module)) {
                    moduleMap = new HashMap();
                    resultRows.put(module, moduleMap);
                } else {
                    moduleMap = (Map)resultRows.get(module);
                }
                if (!moduleMap.containsKey(csect)) {
                    csectMap = new HashMap();
                    moduleMap.put(csect, csectMap);
                } else {
                    csectMap = (Map)moduleMap.get(csect);
                }
                if (!hasStatements.containsKey(csect)) {
                    hasStatements.put(csect, AnalysisUtils.csectHasStatements(dsn, csect));
                }
                if (!csectMap.containsKey(offset)) {
                    histogramRow = AnalysisUtils.createHistogramRow(result, module, csect, offset, null, null);
                    csectMap.put(offset, histogramRow);
                } else {
                    histogramRow = (HistogramRowModel)csectMap.get(offset);
                }
                if (timeRow.getStatus().equals("A")) {
                    histogramRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount);
                } else if (timeRow.getStatus().equals("W")) {
                    histogramRow.addPercent(0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount);
                } else {
                    histogramRow.addPercent(0.0, 0.0, 0.0);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry innermostEntry : ((Map)entry2.getValue()).entrySet()) {
                    result.addRow((MATTableRow)innermostEntry.getValue());
                }
            }
        }
        return result;
    }

    private static HistogramRowModel createHistogramRow(MATTableModel model, String module, String csect, String offset, Integer statement, String sourceLine) {
        HistogramRowModel result = new HistogramRowModel(model, "calculated", module, csect, offset, 1L);
        if (statement != null) {
            result.setStatement(statement);
            result.setSourceLine(sourceLine);
        }
        return result;
    }

    public static String getCsectEndOffset(String csect) {
        return "FFFF";
    }

    public static MATTableModel calculateDelayView(MATTableModel timeView, String dsn, int analysisType) {
        if (timeView == null) {
            return null;
        }
        MATTableModel delayTable = Singletons.getAnalysisManager().getStaticModel("TUNDELAY");
        MATTableModel result = new MATTableModel(dsn);
        HashMap<Integer, Map<Integer, DelayViewRowModel>> resultRows = new HashMap<Integer, Map<Integer, DelayViewRowModel>>();
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel) {
                DelayViewRowModel delayRow;
                Map<Integer, DelayViewRowModel> type1Map;
                TimeViewRowModel timeRow = (TimeViewRowModel)row;
                Integer type1 = timeRow.getDelayType1();
                Integer type2 = timeRow.getDelayType2();
                if (!resultRows.containsKey(type1)) {
                    type1Map = new HashMap();
                    resultRows.put(type1, type1Map);
                } else {
                    type1Map = (Map)resultRows.get(type1);
                }
                if (!type1Map.containsKey(type2)) {
                    delayRow = AnalysisUtils.createDelayViewRow(result, type1, type2, dsn, delayTable);
                    type1Map.put(type2, delayRow);
                } else {
                    delayRow = (DelayViewRowModel)type1Map.get(type2);
                }
                if (timeRow.getStatus().equals("A")) {
                    delayRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount);
                } else if (timeRow.getStatus().equals("W") || timeRow.getStatus().equals("I")) {
                    delayRow.addPercent(0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                result.addRow((MATTableRow)entry2.getValue());
            }
        }
        return result;
    }

    private static DelayViewRowModel createDelayViewRow(MATTableModel model, Integer type1, Integer type2, String dsn, MATTableModel delayTable) {
        boolean exists = false;
        String majcat = "";
        String mincat = "";
        MATTableRow[] mATTableRowArray = delayTable.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow r = mATTableRowArray[n2];
            if (r instanceof TundelayRowModel) {
                TundelayRowModel delayRow = (TundelayRowModel)r;
                if (delayRow.getType1().equals(type1)) {
                    if (delayRow.getType2().equals(0)) {
                        majcat = delayRow.getDescription();
                    }
                    if (delayRow.getType2().equals(type2)) {
                        exists = true;
                        mincat = delayRow.getDescription();
                        break;
                    }
                }
                if (!exists) {
                    mincat = majcat;
                }
            }
            ++n2;
        }
        DelayViewRowModel result = new DelayViewRowModel(model, majcat, mincat, type1, type2);
        result.setAutonav(AnalysisUtils.getNextExec(result, dsn));
        return result;
    }

    public static MATTableModel calculateDelayLocations(MATTableModel timeView, String dsn, int analysisType, Display display) {
        if (timeView == null) {
            return null;
        }
        timeView.sortByColumn(4, true);
        timeView.sortByColumn(3, true);
        timeView.sortByColumn(2, true);
        AnalysisManager aManager = Singletons.getAnalysisManager(display);
        ListingManager lManager = Singletons.getListingManager(display);
        MATTableModel descTable = aManager.getStaticModel("TUNDESC");
        MATTableModel pseudoTable = aManager.getStaticModel("TUNPSEDO");
        MATTableModel longnameTable = aManager.getModel(dsn, "Long Name Table", analysisType);
        MATTableModel csectInfo = aManager.getModel(dsn, "Module-Csect Info", 1);
        MATTableModel result = new MATTableModel(dsn);
        HashMap resultRows = new HashMap();
        int rowCount = aManager.getSampleCount(dsn, analysisType);
        String module = "";
        String csect = "";
        String rowOffset = "";
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow matTableRow = mATTableRowArray[n2];
            if (matTableRow instanceof TimeViewRowModel) {
                Map<String, DelayLocationRowModel> csectMap;
                Map moduleMap;
                TimeViewRowModel timeRow = (TimeViewRowModel)matTableRow;
                module = timeRow.getModule();
                csect = timeRow.getCsect();
                rowOffset = timeRow.getOffset();
                if (!resultRows.containsKey(module)) {
                    moduleMap = new HashMap();
                    resultRows.put(module, moduleMap);
                } else {
                    moduleMap = (Map)resultRows.get(module);
                }
                if (!moduleMap.containsKey(csect)) {
                    csectMap = new HashMap();
                    moduleMap.put(csect, csectMap);
                } else {
                    csectMap = (Map)moduleMap.get(csect);
                }
                DelayLocationRowModel csectRow = null;
                if (!csectMap.containsKey(rowOffset)) {
                    csectRow = AnalysisUtils.createDelayLocationRow(result, module, csect, rowOffset, descTable, pseudoTable, longnameTable);
                    csectRow.setOffset(rowOffset);
                    csectMap.put(rowOffset, csectRow);
                    result.addRow(csectRow);
                } else {
                    csectRow = (DelayLocationRowModel)csectMap.get(rowOffset);
                }
                csectRow.addTotal(100.0 / (double)rowCount);
                if (timeRow.getStatus().equals("A")) {
                    csectRow.addActive(100.0 / (double)rowCount);
                } else {
                    csectRow.addWait(100.0 / (double)rowCount);
                }
                if (timeRow.getCallerModule() != null && !timeRow.getCallerModule().isEmpty()) {
                    csectRow.setHasCallerId(true);
                }
                if (timeRow.getCallerApplicationModule() != null && !timeRow.getCallerApplicationModule().isEmpty()) {
                    csectRow.setHasExtendedCallerId(true);
                }
                if (timeRow.getCallerCurrentModule() != null && !timeRow.getCallerCurrentModule().isEmpty()) {
                    csectRow.setHasExtendedCallerId(true);
                }
                if (timeRow.getCallerViaModule() != null && !timeRow.getCallerViaModule().isEmpty()) {
                    csectRow.setHasExtendedCallerId(true);
                }
                if (timeRow.getDelayedResource() != null && !timeRow.getDelayedResource().isEmpty()) {
                    csectRow.setHasDetail(true);
                }
            }
            ++n2;
        }
        HashMap<String, MATTableModel> stmtTablesMap = new HashMap<String, MATTableModel>();
        HashMap<String, ListingVerbsRowModel> stmtsMap = new HashMap<String, ListingVerbsRowModel>();
        HashMap<Integer, DelayLocationRowModel> stmtToRowMap = new HashMap<Integer, DelayLocationRowModel>();
        MATTableRow[] mATTableRowArray2 = result.getRows();
        int n3 = mATTableRowArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            MATTableModel statementTable;
            MATTableRow row = mATTableRowArray2[n4];
            DelayLocationRowModel resultRow = (DelayLocationRowModel)row;
            csect = resultRow.getCsect();
            module = resultRow.getModule();
            rowOffset = resultRow.getOffset();
            String tableKey = String.valueOf(module) + ':' + csect;
            if (stmtTablesMap.containsKey(tableKey)) {
                statementTable = (MATTableModel)stmtTablesMap.get(tableKey);
            } else {
                statementTable = AnalysisUtils.getStatementTable(dsn, csect, false, lManager, csectInfo);
                stmtTablesMap.put(tableKey, statementTable);
            }
            if (statementTable != null) {
                ListingVerbsRowModel stmtRow;
                String stmtKey = String.valueOf(tableKey) + ':' + rowOffset;
                if (stmtsMap.containsKey(stmtKey)) {
                    stmtRow = (ListingVerbsRowModel)stmtsMap.get(stmtKey);
                } else {
                    stmtRow = AnalysisUtils.getStatement(dsn, module, csect, rowOffset, statementTable);
                    stmtsMap.put(stmtKey, stmtRow);
                }
                if (stmtRow != null) {
                    if (stmtToRowMap.containsKey(stmtRow.getLine())) {
                        DelayLocationRowModel rowInMap = (DelayLocationRowModel)stmtToRowMap.get(stmtRow.getLine());
                        rowInMap.addRow(resultRow);
                        resultRow.setActive(0.0);
                        resultRow.setWait(0.0);
                        resultRow.setTotal(0.0);
                    } else {
                        rowOffset = stmtRow.getOffset();
                        rowOffset = HexUtil.toHex(Long.valueOf(rowOffset), 4);
                        resultRow.setOffset(rowOffset);
                        resultRow.setStatement(stmtRow.getLine());
                        stmtToRowMap.put(stmtRow.getLine(), resultRow);
                    }
                }
            }
            ++n4;
        }
        result = AnalysisUtils.removeZeroValueRows(result, 10);
        return result;
    }

    private static DelayLocationRowModel createDelayLocationRow(MATTableModel model, String module, String csect, String offset, MATTableModel descTable, MATTableModel pseudoTable, MATTableModel longnameTable) {
        String[] descriptions = AnalysisUtils.getDescriptions(module, csect, descTable, pseudoTable, longnameTable);
        String csectDesc = descriptions[3];
        return new DelayLocationRowModel(model, module, csect, csectDesc, offset);
    }

    public static MATTableModel calculateDelayedResource(Integer observationNumber, MATTableModel timeView, String dsn, int analysisType) {
        if (timeView == null) {
            return null;
        }
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableModel result = new MATTableModel(dsn);
        HashMap<String, DelayedResourceRowModel> resultRows = new HashMap<String, DelayedResourceRowModel>();
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeViewRowModel timeRow;
            int obsNo;
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel && observationNumber.equals(obsNo = (timeRow = (TimeViewRowModel)row).getObsNumber().intValue())) {
                DelayedResourceRowModel delayedRow;
                if (!resultRows.containsKey(timeRow.getDelayedResource())) {
                    delayedRow = new DelayedResourceRowModel(result, timeRow.getDelayedResource(), timeRow.getDelayedComponent());
                    resultRows.put(timeRow.getDelayedResource(), delayedRow);
                } else {
                    delayedRow = (DelayedResourceRowModel)resultRows.get(timeRow.getDelayedResource());
                }
                delayedRow.addPercent(100.0 / (double)rowCount);
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    public static MATTableModel calculateLinkSuggestions(MATTableModel timeView, String module, String dsn, int analysisType) {
        LinkSuggestionsRowModel linkRow;
        String csect;
        MATTableRow row;
        if (timeView == null) {
            return null;
        }
        MATTableModel csectTable = Singletons.getAnalysisManager().getModel(dsn, "TUNCSECT", 1);
        MATTableModel result = new MATTableModel(dsn);
        HashMap<String, LinkSuggestionsRowModel> resultRows = new HashMap<String, LinkSuggestionsRowModel>();
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableRow[] mATTableRowArray = csectTable.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            row = mATTableRowArray[n2];
            TuncsectRowModel csectRow = (TuncsectRowModel)row;
            if (csectRow.getModule().equals(module) && !resultRows.containsKey(csect = csectRow.getCsect())) {
                linkRow = AnalysisUtils.createLinkSuggestionRow(result, module, csect);
                resultRows.put(csect, linkRow);
            }
            ++n2;
        }
        mATTableRowArray = timeView.getRows();
        n = mATTableRowArray.length;
        n2 = 0;
        while (n2 < n) {
            TimeViewRowModel timeRow;
            row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel && (timeRow = (TimeViewRowModel)row).getModule().equals(module) && (linkRow = (LinkSuggestionsRowModel)resultRows.get(csect = timeRow.getCsect())) != null) {
                linkRow.addPercent(100.0 / (double)rowCount);
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        MATTableRow[] rowArray = result.getRows();
        Arrays.sort(rowArray, new Comparator<MATTableRow>(){

            @Override
            public int compare(MATTableRow row1, MATTableRow row2) {
                LinkSuggestionsRowModel link1 = (LinkSuggestionsRowModel)row1;
                LinkSuggestionsRowModel link2 = (LinkSuggestionsRowModel)row2;
                if (link1.getPercent().equals(link2.getPercent())) {
                    return link1.getCsect().compareTo(link2.getCsect());
                }
                return link2.getPercent().compareTo(link1.getPercent());
            }
        });
        Integer offsetInt = 0;
        MATTableRow[] mATTableRowArray2 = rowArray;
        int n3 = rowArray.length;
        int n4 = 0;
        while (n4 < n3) {
            MATTableRow row2 = mATTableRowArray2[n4];
            linkRow = (LinkSuggestionsRowModel)row2;
            MATTableRow[] mATTableRowArray3 = csectTable.getRows();
            int n5 = mATTableRowArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                MATTableRow row22 = mATTableRowArray3[n6];
                TuncsectRowModel csectRow = (TuncsectRowModel)row22;
                if (csectRow.getModule().equals(linkRow.getModule()) && csectRow.getCsect().equals(linkRow.getCsect())) {
                    String length = csectRow.getLength();
                    Integer lengthInt = Integer.valueOf(length, 16);
                    linkRow.setLength(HexUtil.toHex(lengthInt, 4));
                    linkRow.setOffset(HexUtil.toHex(offsetInt, 4));
                    offsetInt = offsetInt + lengthInt;
                    break;
                }
                ++n6;
            }
            ++n4;
        }
        return result;
    }

    private static LinkSuggestionsRowModel createLinkSuggestionRow(MATTableModel model, String module, String csect) {
        return new LinkSuggestionsRowModel(model, module, csect);
    }

    public static MATTableModel calculateUSSView(MATTableModel timeView, String dsn, int analysisType) {
        return AnalysisUtils.calculateUSSViewExperimental(timeView, dsn, analysisType, null);
    }

    public static MATTableModel calculateUSSViewExperimental(MATTableModel timeView, String dsn, int analysisType, Integer delayType2) {
        if (timeView == null) {
            return null;
        }
        int delaytype1 = 22;
        int rowCount = Singletons.getAnalysisManager().getSampleCount(dsn, analysisType);
        MATTableModel processId2initCommand = Singletons.getAnalysisManager().getModel(dsn, "USSView", analysisType);
        MATTableModel result = new MATTableModel(dsn);
        HashMap<String, USSViewRowModel> resultRows = new HashMap<String, USSViewRowModel>();
        MATTableRow[] mATTableRowArray = timeView.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeViewRowModel timeRow;
            MATTableRow row = mATTableRowArray[n2];
            if (row instanceof TimeViewRowModel && (timeRow = (TimeViewRowModel)row).getDelayType1().equals(delaytype1) && (delayType2 == null || timeRow.getDelayType2().equals(delayType2))) {
                USSViewRowModel ussRow;
                String processId;
                try {
                    processId = Integer.valueOf(timeRow.getMajNM(), 16).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    processId = "";
                }
                String initCmd = "";
                if (processId2initCommand != null) {
                    MATTableRow[] mATTableRowArray2 = processId2initCommand.getRows();
                    int n3 = mATTableRowArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        USSProcess2InitMap mappingRow;
                        MATTableRow mapping = mATTableRowArray2[n4];
                        if (mapping instanceof USSProcess2InitMap && (mappingRow = (USSProcess2InitMap)mapping).getProcessId().equals(processId)) {
                            initCmd = mappingRow.getInitCmd();
                            break;
                        }
                        ++n4;
                    }
                }
                if (!resultRows.containsKey(processId)) {
                    ussRow = AnalysisUtils.createUSSViewRow(result, processId, initCmd);
                    resultRows.put(processId, ussRow);
                } else {
                    ussRow = (USSViewRowModel)resultRows.get(processId);
                }
                if (timeRow.getStatus().equals("A")) {
                    ussRow.addPercent(100.0 / (double)rowCount, 0.0, 100.0 / (double)rowCount);
                } else if (timeRow.getStatus().equals("W") || timeRow.getStatus().equals("I")) {
                    ussRow.addPercent(0.0, 100.0 / (double)rowCount, 100.0 / (double)rowCount);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : resultRows.entrySet()) {
            result.addRow((MATTableRow)entry.getValue());
        }
        return result;
    }

    private static USSViewRowModel createUSSViewRow(MATTableModel model, String processid, String initcmd) {
        return new USSViewRowModel(model, processid, initcmd, 0.0, 0.0, 0.0);
    }

    public static String getNextExec(DelayViewRowModel entryRow, String dsn) {
        String majcat = entryRow.getMajorCat();
        String mincat = entryRow.getMinorCat();
        if (majcat == null || mincat == null) {
            return null;
        }
        MATTableModel nextExecTable = Singletons.getAnalysisManager().getModel(dsn, "DelayView", 1);
        if (nextExecTable == null) {
            return null;
        }
        MATTableRow[] mATTableRowArray = nextExecTable.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            DelayViewRowModel delayRow = (DelayViewRowModel)row;
            if (majcat.equals("Unix System Services")) {
                if (delayRow.getMinorCat().length() >= 11 && mincat.substring(0, 11).equals(delayRow.getMinorCat().substring(0, 11))) {
                    if (entryRow.equals(delayRow)) {
                        return null;
                    }
                    return delayRow.getAutonav();
                }
            } else if (majcat.equals(delayRow.getMajorCat()) && mincat.equals(delayRow.getMinorCat())) {
                if (entryRow.equals(delayRow)) {
                    return null;
                }
                return delayRow.getAutonav();
            }
            ++n2;
        }
        return null;
    }

    public static String[] getDescriptions(String module, String csect, MATTableModel descTable, MATTableModel pseudoTable, MATTableModel longnameTable) {
        int i;
        TundescRowModel descRow;
        String cs;
        MATTableRow r;
        int n;
        int n2;
        MATTableRow[] mATTableRowArray;
        String csectDesc = "";
        String moduleDesc = "";
        String pseudoDesc = "";
        String pseudo = "";
        if (module.contains("-")) {
            mATTableRowArray = longnameTable.getRows();
            n2 = mATTableRowArray.length;
            n = 0;
            while (n < n2) {
                LongNameTableRowModel longnameRow;
                r = mATTableRowArray[n];
                if (r instanceof LongNameTableRowModel && (longnameRow = (LongNameTableRowModel)r).getShrtName().equals(module) && longnameRow.getLongType().equals("USS") && longnameRow.getSubtype().equals("MODULE")) {
                    moduleDesc = longnameRow.getLongName();
                    csectDesc = longnameRow.getLongName();
                    break;
                }
                ++n;
            }
        } else {
            mATTableRowArray = descTable.getRows();
            n2 = mATTableRowArray.length;
            n = 0;
            while (n < n2) {
                r = mATTableRowArray[n];
                if (r instanceof TundescRowModel && (cs = (descRow = (TundescRowModel)r).getCsect()).length() > 0) {
                    i = cs.indexOf(".");
                    if (i > 0) {
                        if (module.startsWith(cs = cs.substring(0, i))) {
                            moduleDesc = ((TundescRowModel)r).getDescription();
                        }
                    } else if (module.equals(cs)) {
                        moduleDesc = ((TundescRowModel)r).getDescription();
                    }
                }
                ++n;
            }
        }
        mATTableRowArray = descTable.getRows();
        n2 = mATTableRowArray.length;
        n = 0;
        while (n < n2) {
            r = mATTableRowArray[n];
            if (r instanceof TundescRowModel && (cs = (descRow = (TundescRowModel)r).getCsect()).length() > 0) {
                i = cs.indexOf(".");
                if (i > 0) {
                    if (csect.startsWith(cs = cs.substring(0, i))) {
                        csectDesc = ((TundescRowModel)r).getDescription();
                    }
                } else if (csect.equals(cs)) {
                    csectDesc = ((TundescRowModel)r).getDescription();
                }
            }
            ++n;
        }
        if (csectDesc.isEmpty()) {
            csectDesc = moduleDesc;
        }
        if (module.startsWith(".")) {
            pseudo = module;
            pseudoDesc = moduleDesc;
        } else {
            TunpsedoRowModel pseudoRow = null;
            MATTableRow[] mATTableRowArray2 = pseudoTable.getRows();
            int n3 = mATTableRowArray2.length;
            n2 = 0;
            while (n2 < n3) {
                MATTableRow r2 = mATTableRowArray2[n2];
                if (r2 instanceof TunpsedoRowModel && module.startsWith(((TunpsedoRowModel)r2).getModule())) {
                    pseudoRow = (TunpsedoRowModel)r2;
                }
                ++n2;
            }
            pseudo = pseudoRow == null ? ".APPL" : pseudoRow.getPseudo();
            String string = pseudoDesc = pseudoRow == null ? "Application address space" : pseudoRow.getPseudoDescription();
            if (pseudoRow == null) {
                moduleDesc = "Application address space";
            }
        }
        return new String[]{pseudo, pseudoDesc, moduleDesc, csectDesc};
    }

    public static MATTableModel createComparison(MATTableModel model1, MATTableModel model2) {
        return null;
    }

    public static String[] getSQLsFromWasTran(MATTableModel was) {
        Vector<String> vector = new Vector<String>();
        MATTableRow[] mATTableRowArray = was.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            WASTranDelayRowModel wasRow = (WASTranDelayRowModel)row;
            String key = "";
            key = wasRow.getSqlshort();
            if (!vector.contains(key)) {
                vector.add(key);
            }
            ++n2;
        }
        String[] result = new String[vector.size()];
        vector.toArray(result);
        return result;
    }

    public static MATTableModel createExplainSQL(MATTableModel explModel, String dsn) {
        TunexplRowModel explRow;
        Comparator<MATTableRow> comparator = new Comparator<MATTableRow>(){

            @Override
            public int compare(MATTableRow row1, MATTableRow row2) {
                if (row1 instanceof TunexplRowModel && row2 instanceof TunexplRowModel) {
                    String planNo1 = ((TunexplRowModel)row1).getPlanNo();
                    String planNo2 = ((TunexplRowModel)row2).getPlanNo();
                    return planNo1.compareTo(planNo2);
                }
                return 0;
            }
        };
        MATTableRow[] explArray = explModel.getRows();
        Arrays.sort(explArray, comparator);
        MATTableModel result = new MATTableModel();
        if (!explModel.isEmpty() && (explRow = (TunexplRowModel)explArray[0]) != null) {
            result.addRow(new ExplainStmtRowModel(result, "PLAN_TABLE Column  ", "QMF Heading  ", "Explain Data (PLAN_TABLE row 1 of " + explModel.getRows().length + ")", "Description"));
            result.addRow(new ExplainStmtRowModel(result, "___________________", "_____________", "________________________________________________", "___________"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "MATUNER", "EXPDBRM", explRow.getDbrm(), "DBRM Id"));
            result.addRow(new ExplainStmtRowModel(result, "MATUNER", "EXPSTM#", explRow.getStmtNum_Formatted(), "Statement Number    "));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "QUERYNO", "QUERY_NO", explRow.getQueryNum_Formatted(), "Differentiate between EXPLAIN statements"));
            result.addRow(new ExplainStmtRowModel(result, "QBLOCKNO", "QRY_BLK", explRow.getQueryBlockNum_Formatted(), "Sub-select ID within a given SQL statement"));
            result.addRow(new ExplainStmtRowModel(result, "QBLOCK_TYPE", "EXPQTYPE", explRow.getQueryBlockType_Formatted(), "Indicates SQL operation for query block"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "GROUP_MEMBER", "EXPGPMEM", explRow.getGroupMember_Formatted(), "Membername of the DB2 that executed EXPLAIN"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "APPLNAME", "PLANNAME", explRow.getApplName_Formatted(), "PLAN/PACKAGE identified on the BIND request"));
            result.addRow(new ExplainStmtRowModel(result, "VERSION", "VERSION", explRow.getVersion_Formatted(), "PACKAGE version identification"));
            result.addRow(new ExplainStmtRowModel(result, "PROGNAME", "PROGRAM", explRow.getProgram_Formatted(), "Program issuing the SQL statement"));
            result.addRow(new ExplainStmtRowModel(result, "COLLID", "COL_LID", explRow.getCollId_Formatted(), "PACKAGE collection identification"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "WHEN_OPTIMIZE", "EXPWOPT", explRow.getExpwopt_Formatted(), "Specifies when the ACCESS PATH was determined"));
            result.addRow(new ExplainStmtRowModel(result, "LAST_BIND_TIME", "EXPBNTIM", explRow.getLastBindTime_Formatted(), "Time PACKAGE was last bound to this DB2"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "PLANNO", "QBLKSTEP", explRow.getPlanNo(), "Plan step which 'QBLOCKNO' is processed"));
            result.addRow(new ExplainStmtRowModel(result, "METHOD", "METH", explRow.getMethod_Formatted(), "Access Method used for a given STEP"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "TNAME", "TABLNAME", explRow.getTabName_Formatted(), "NAME of table being accessed  "));
            result.addRow(new ExplainStmtRowModel(result, "TABNO", "   ", explRow.getTabNum_Formatted(), "Table reference within SQL (IBM use only) "));
            result.addRow(new ExplainStmtRowModel(result, "CREATOR", "CREATOR", explRow.getCreator_Formatted(), "CREATOR of table identified by 'TNAME' "));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "ACCESSTYPE", "TYPE", explRow.getAccessType_Formatted(), "Table access method"));
            result.addRow(new ExplainStmtRowModel(result, "ACCESSCREATOR", "   ", explRow.getAccessCreator_Formatted(), "Index creator"));
            result.addRow(new ExplainStmtRowModel(result, "ACCESSNAME", "INDEX", explRow.getAccessName_Formatted(), "Index name"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "MATCHCOLS", "MCOL", explRow.getMatchCols(), "Index columns used in an INDEX SCAN"));
            result.addRow(new ExplainStmtRowModel(result, "INDEXONLY", "I", explRow.getIndexOnly_Formatted(), "Index alone was sufficient for request"));
            result.addRow(new ExplainStmtRowModel(result, "MIXOPSEQ", "MULT_IDX", explRow.getMultipleIndex_Formatted(), "Sequence of multiple index operation"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "SORTN_UNIQ", "S_N_U", explRow.getSortNewUnique_Formatted(), "Sort NEW table to remove duplicates"));
            result.addRow(new ExplainStmtRowModel(result, "SORTN_JOIN", "S_N_J", explRow.getSortNewJoin_Formatted(), "Sort NEW table to perform MERGE/SCAN/JOIN"));
            result.addRow(new ExplainStmtRowModel(result, "SORTN_ORDERBY", "S_N_O", explRow.getSortNewOrderBy_Formatted(), "Sort NEW table to order by ROWS"));
            result.addRow(new ExplainStmtRowModel(result, "SORTN_GROUPBY", "S_N_O", explRow.getSortNewGroupBy_Formatted(), "Sort NEW table to order by ROWS"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "SORTC_UNIQ", "S_C_U", explRow.getSortCompUnique_Formatted(), "Sort COMPOSITE table to remove duplicates"));
            result.addRow(new ExplainStmtRowModel(result, "SORTC_JOIN", "S_C_J", explRow.getSortCompJoin_Formatted(), "Sort COMPOSITE table to perform MERGE/SCAN/JOIN"));
            result.addRow(new ExplainStmtRowModel(result, "SORTC_ORDERBY", "S_C_O", explRow.getSortCompOrderBy_Formatted(), "Sort COMPOSITE table to order by ROWS"));
            result.addRow(new ExplainStmtRowModel(result, "SORTC_GROUPBY", "S_C_O", explRow.getSortCompGroupBy_Formatted(), "Sort COMPOSITE table to order by ROWS"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "TSLOCKMODE", "LCK_MOD", explRow.getLockMode_Formatted(), "Lock level applied to NEW table"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "PREFETCH", "P_F", explRow.getPrefetch_Formatted(), "Type of PREFETCH which will be used"));
            result.addRow(new ExplainStmtRowModel(result, "COLUMN_FN_EVAL", "COLFNEVL", explRow.getFnEval_Formatted(), "When this column function will be evaluated"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "ACCESS_DEGREE", "EXPACDGR", explRow.getAccessDegree_Formatted(), "Number of parallel tasks utilized by the query"));
            result.addRow(new ExplainStmtRowModel(result, "ACCESS_PGROUP_ID", "EXPACPGP", explRow.getAccessGroup_Formatted(), "Parallel group ID accessing the NEW table"));
            result.addRow(new ExplainStmtRowModel(result, "JOIN_DEGREE", "EXPJODGR", explRow.getJoinDegree_Formatted(), "Parallel tasks used in JOINING the composite tbl"));
            result.addRow(new ExplainStmtRowModel(result, "JOIN_PGROUP_ID", "EXPJOPGP", explRow.getJoinGroup_Formatted(), "Parallel Group ID JOINING the composite table"));
            result.addRow(new ExplainStmtRowModel(result, "SORTC_PGROUP_ID", "EXPSTCPG", explRow.getSortCGroup_Formatted(), "Parallel Group ID for the Composite table sort"));
            result.addRow(new ExplainStmtRowModel(result, "SORTN_PGROUP_ID", "EXPSTNPG", explRow.getSortNGroup_Formatted(), "Parallel Group ID for the New table sort"));
            result.addRow(new ExplainStmtRowModel(result, "PARALLELISM_MODE", "EXPPMODE", explRow.getParaMode_Formatted(), "Type of parallelism used at BIND time"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "JOIN_TYPE", "EXPJTYPE", explRow.getJoinType_Formatted(), "Indicates type of JOIN implemented"));
            result.addRow(new ExplainStmtRowModel(result, "MERGE_JOIN_COLS", "EXPMRGJC", explRow.getMergeJoinCols_Formatted(), "No of columns joined during a MERGE/SCAN/JOIN"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "CORRELATION_NAME", "EXPCORNM", explRow.getCorrelationName_Formatted(), "Correlation Name Specified for this Table"));
            result.addRow(new ExplainStmtRowModel(result, "PAGE_RANGE", "EXPPRNGE", explRow.getPageRange_Formatted(), "Table qualifiies for page range tablespace scans"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "OPTHINT", "EXPOPTHN", explRow.getOptimHint_Formatted(), "Optimization hint used by DB2"));
            result.addRow(new ExplainStmtRowModel(result, "HINT_USED", "EXPHINTU", explRow.getOphintUsed_Formatted(), " Indicates whether 'OPTHINT' was used"));
            result.addRow(new ExplainStmtRowModel(result, "PRIMARY_ACCESS", "EXPPRMAC", explRow.getPrimaryAccess_Formatted(), "Indicates whether DIRECT ROW ACCESS attempted"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "TIMESTAMP", "TIMSTAMP", explRow.getTimestamp_Formatted(), "Timestamp of when EXPLAIN row was created"));
            result.addRow(new ExplainStmtRowModel(result));
            result.addRow(new ExplainStmtRowModel(result, "REMARKS", "   ", explRow.getRemarks_Formatted(), "Optional text to comment on explain results"));
        }
        int i = 2;
        while (i <= explModel.getRows().length) {
            int j = 0;
            TunexplRowModel explRow2 = (TunexplRowModel)explArray[i - 1];
            if (explRow2 != null) {
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("Explain Data (PLAN_TABLE row " + i + " of " + explModel.getRows().length + ")");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("_______________________________________________");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getDbrm());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getStmtNum_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getQueryNum_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getQueryBlockNum_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getQueryBlockType_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getGroupMember_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getApplName_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getVersion_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getProgram_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getCollId_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getExpwopt_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getLastBindTime_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getPlanNo());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getMethod_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getTabName_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getTabNum_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getCreator_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getAccessType_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getAccessCreator_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getAccessName_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getMatchCols());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getIndexOnly_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getMultipleIndex_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortNewUnique_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortNewJoin_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortNewOrderBy_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortNewGroupBy_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortCompUnique_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortCompJoin_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortCompOrderBy_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortCompGroupBy_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getLockMode_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getPrefetch_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getFnEval_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getAccessDegree_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getAccessGroup_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getJoinDegree_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getJoinGroup_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortCGroup_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getSortNGroup_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getParaMode_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getJoinType_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getMergeJoinCols_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getCorrelationName_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getPageRange_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getOptimHint_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getOphintUsed_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getPrimaryAccess_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getTimestamp_Formatted());
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue("");
                ((ExplainStmtRowModel)result.getRows()[j++]).addValue(explRow2.getRemarks_Formatted());
            }
            ++i;
        }
        return result;
    }

    public static MATTableModel createExplainInformation(MATTableModel model, String dsn) {
        Comparator<MATTableRow> comparator = new Comparator<MATTableRow>(){

            @Override
            public int compare(MATTableRow row1, MATTableRow row2) {
                if (row1 instanceof TunexplRowModel && row2 instanceof TunexplRowModel) {
                    String planNo1 = ((TunexplRowModel)row1).getPlanNo();
                    String planNo2 = ((TunexplRowModel)row2).getPlanNo();
                    return planNo1.compareTo(planNo2);
                }
                return 0;
            }
        };
        MATTableRow[] explArray = model.getRows();
        Arrays.sort(explArray, comparator);
        MATTableModel result = new MATTableModel();
        result.addRow(new ExplainStmtRowModel(result, "Rule ID", "Rule Text", "Rule Text Description", "CA MAT Tip"));
        result.addRow(new ExplainStmtRowModel(result, "________", "____________________________________________________________________________________________________", "____________________________________________________________________________________________________", "____________________________________________________________________________________________________"));
        int i = 0;
        while (i < explArray.length) {
            TunexplRowModel explRow = (TunexplRowModel)explArray[i];
            TunexplRowModel prevExplRow = (TunexplRowModel)(i == 0 ? null : explArray[i - 1]);
            DB2ExplainRulesList rules = DB2ExplainRulesList.getInstance();
            int j = 0;
            while (j < rules.getRuleCount()) {
                if (rules.checkRule(j, explRow)) {
                    for (ExplainInformationStmtRowModel row : rules.getRow(j, explRow, prevExplRow, result)) {
                        result.addRow(row);
                    }
                    result.addRow(new ExplainInformationStmtRowModel(result));
                }
                ++j;
            }
            ++i;
        }
        result.addRow(new ExplainStmtRowModel(result, "________", "____________________________________________________________________________________________________", "____________________________________________________________________________________________________", "____________________________________________________________________________________________________"));
        return result;
    }

    public static String createDB2DeclareKey(DB2ViewRowModel row) {
        int len = row.getDbrmKey().length();
        if (len > 16) {
            return String.valueOf(row.getDbrmKey().substring(0, len - 16)) + row.getDeclareStmt8Num() + row.getCrc8Num();
        }
        return row.getDbrmKey();
    }

    public static String getDelayDescription(int ttype1, int ttype2) {
        switch (ttype1) {
            case 0: {
                return "The program (or one of its subroutines) is in control of a CPU.";
            }
            case 1: {
                return "The program has voluntarily relinquished control of a CPU.";
            }
            case 2: {
                return "A component of the application is terminating abnormally or gathering diagnostic information";
            }
            case 3: {
                return "The program is waiting for data to be returned.";
            }
            case 4: {
                return "The program is delayed because another program has exclusive use of a required resource, such as a file or a program.";
            }
            case 5: {
                return "The program is using operating system functions, such as storage administration or system security.";
            }
            case 6: {
                return "The program is delayed by a file management operation such as locating or opening a file.";
            }
        }
        return "";
    }

    public static MATTableModel removeZeroValueRows(MATTableModel model, int valueColumn) {
        MATTableModel result = new MATTableModel();
        MATTableRow[] mATTableRowArray = model.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            Object value = row.getObject(valueColumn);
            Double numeric = null;
            if (value instanceof Double) {
                numeric = (Double)value;
            } else {
                try {
                    numeric = Double.valueOf(value.toString());
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (numeric != null && numeric >= 0.005) {
                result.addRow(row);
            }
            ++n2;
        }
        return result;
    }
}

