/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.ModViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.ModViewPage;
import com.ca.mat.views.subpages.LinkSuggestionsSubpage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ModViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (obj instanceof ModViewRowModel) {
            ModViewRowModel rowModel = (ModViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.modview.suggest") && page instanceof ModViewPage) {
                String module = rowModel.getModule();
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = AnalysisUtils.calculateLinkSuggestions(model, module, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(LinkSuggestionsSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.linksuggestions", model);
                String partName = String.format("Link Suggestions for %s", module);
                detachedView.setPresentationName(partName);
                return null;
            }
        }
        return null;
    }
}

