/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IMSStatementRowModel;
import com.ca.mat.rowmodels.IMSViewRowModel;
import com.ca.mat.rowmodels.SSARowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.IMSPage;
import com.ca.mat.views.pages.LinkPage;
import com.ca.mat.views.subpages.CallerIdSubpage;
import com.ca.mat.views.subpages.IMSDBDDetailSubpage;
import com.ca.mat.views.subpages.IMSStatementSubpage;
import com.ca.mat.views.subpages.SSASubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class IMSViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MATTableRow rowModel;
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        if (page instanceof IMSPage) {
            if (commandId.equals("com.ca.mat.commands.analysis.imsview.imsstatementdetailsall")) {
                String section = "IMS Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                detachedView.setPresentationName("IMS Statements");
                return null;
            }
            if (obj != null && obj instanceof IMSViewRowModel) {
                rowModel = (IMSViewRowModel)obj;
                if (commandId.equals("com.ca.mat.commands.analysis.imsview.imsstatementdetailsline")) {
                    String section = "IMS Statements";
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    if (model != null) {
                        model = model.filterBy("tranid", ((IMSViewRowModel)rowModel).getTransactionId());
                    }
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                    detachedView.setPresentationName(String.format("IMS Statements: Transaction %s", ((IMSViewRowModel)rowModel).getTransactionId()));
                    return null;
                }
                if (commandId.equals("com.ca.mat.commands.analysis.imsview.codedetails")) {
                    HashMap<String, Object[]> codeViewArgs = new HashMap<String, Object[]>();
                    ArrayList<String[]> codeViewTitles = new ArrayList<String[]>();
                    codeViewArgs.put("Transaction", new Object[]{((IMSViewRowModel)rowModel).getTransactionId()});
                    codeViewTitles.add(new String[]{"Transaction", ((IMSViewRowModel)rowModel).getTransactionId()});
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                    model = model.filterBy(codeViewArgs);
                    model = AnalysisUtils.calculateCodeView(model, dsn, type);
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CodeViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.codedetail", model);
                    String partName = "Code Details:";
                    for (String[] entry : codeViewTitles) {
                        partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                    }
                    detachedView.setPresentationName(partName);
                    AnalysisPage newPage = detachedView.getCurrentPage();
                    if (newPage != null && newPage instanceof CodeViewPage) {
                        CodeViewPage codeViewPage = (CodeViewPage)newPage;
                        codeViewPage.setFilterExpressions(codeViewArgs);
                        codeViewPage.setTitleExpressions(codeViewTitles);
                    }
                    if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                        ((AnalysisPageCalculated)newPage).refreshHeader();
                    }
                    return null;
                }
                if (commandId.equals("com.ca.mat.commands.analysis.imsview.callerid")) {
                    HashMap<String, Object[]> callerIdArgs = new HashMap<String, Object[]>();
                    ArrayList<String[]> callerIdTitles = new ArrayList<String[]>();
                    callerIdArgs.put("Transaction", new Object[]{((IMSViewRowModel)rowModel).getTransactionId()});
                    callerIdTitles.add(new String[]{"Transaction", ((IMSViewRowModel)rowModel).getTransactionId()});
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                    model = model.filterBy(callerIdArgs);
                    model = AnalysisUtils.calculateCallerId(model, dsn, type, Display.getCurrent());
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CallerIdSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.callerid", model);
                    String partName = "CallerId:";
                    for (String[] entry : callerIdTitles) {
                        partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                    }
                    detachedView.setPresentationName(partName);
                    AnalysisPage newPage = detachedView.getCurrentPage();
                    if (newPage != null && newPage instanceof CallerIdSubpage) {
                        CallerIdSubpage callerIdPage = (CallerIdSubpage)newPage;
                        callerIdPage.setFilterExpressions(callerIdArgs);
                        callerIdPage.setTitleExpressions(callerIdTitles);
                    }
                    if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                        ((AnalysisPageCalculated)newPage).refreshHeader();
                    }
                    return null;
                }
                if (commandId.equals("com.ca.mat.commands.analysis.imsview.delaydetails")) {
                    HashMap<String, Object[]> delayViewArgs = new HashMap<String, Object[]>();
                    ArrayList<String[]> delayViewTitles = new ArrayList<String[]>();
                    delayViewArgs.put("Transaction", new Object[]{((IMSViewRowModel)rowModel).getTransactionId()});
                    delayViewTitles.add(new String[]{"Transaction", ((IMSViewRowModel)rowModel).getTransactionId()});
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                    model = model.filterBy(delayViewArgs);
                    model = AnalysisUtils.calculateDelayView(model, dsn, type);
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DelayViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.delaydetail", model);
                    String partName = "Delay Detail:";
                    for (String[] entry : delayViewTitles) {
                        partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                    }
                    detachedView.setPresentationName(partName);
                    AnalysisPage newPage = detachedView.getCurrentPage();
                    if (newPage != null && newPage instanceof DelayViewPage) {
                        DelayViewPage delayPage = (DelayViewPage)newPage;
                        delayPage.setFilterExpressions(delayViewArgs);
                        delayPage.setTitleExpressions(delayViewTitles);
                    }
                    if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                        ((AnalysisPageCalculated)newPage).refreshHeader();
                    }
                    return null;
                }
                if (commandId.equals("com.ca.mat.commands.analysis.imsview.imsdbd")) {
                    String section = "IMS Statements";
                    MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                    if (model != null) {
                        model = AnalysisUtils.aggregateDBD(model, dsn);
                    }
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSDBDDetailSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                    detachedView.setPresentationName("IMS DBD Details");
                    return null;
                }
            }
        }
        if (page instanceof LinkPage) {
            String section;
            if (commandId.equals("com.ca.mat.commands.analysis.imsview.imsstatementdetailsall")) {
                section = "IMS Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                detachedView.setPresentationName("IMS Statements");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.imsview.imsdbd")) {
                section = "IMS Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    model = AnalysisUtils.aggregateDBD(model, dsn);
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSDBDDetailSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                detachedView.setPresentationName("IMS DBD Details");
                return null;
            }
        }
        if (page instanceof IMSDBDDetailSubpage && obj != null && obj instanceof IMSStatementRowModel) {
            rowModel = (IMSStatementRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.imsview.imsstatementdetailsline")) {
                String section = "IMS Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    model = model.filterBy("dbdname", ((IMSStatementRowModel)rowModel).getDBD());
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.imsstatement", model);
                detachedView.setPresentationName(String.format("IMS Statements for DBD %s", ((IMSStatementRowModel)rowModel).getDBD()));
                return null;
            }
        }
        if (page instanceof IMSStatementSubpage && obj != null && obj instanceof IMSStatementRowModel) {
            rowModel = (IMSStatementRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.imsview.ssa")) {
                String section = "SSA-Statements";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                    arguments.put(SSARowModel.PSB_NAME, new Object[]{((IMSStatementRowModel)rowModel).getPSB()});
                    arguments.put(SSARowModel.DBD_NAME, new Object[]{((IMSStatementRowModel)rowModel).getDBD()});
                    arguments.put(SSARowModel.CALLTYPE, new Object[]{((IMSStatementRowModel)rowModel).getCallType()});
                    model = model.filterBy(arguments);
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(SSASubpage.class, section, dsn, type, presentation, "com.ca.mat.help.ssa", model);
                String format = "Segment Search Arguments PSB %1$s DBD %2$s Segment %3$s (%4$s)";
                detachedView.setPresentationName(String.format(format, ((IMSStatementRowModel)rowModel).getPSB(), ((IMSStatementRowModel)rowModel).getDBD(), ((IMSStatementRowModel)rowModel).getSegment(), ((IMSStatementRowModel)rowModel).getCallType()));
                if (!model.hasColumn("SEGVALUE") && !model.hasColumn("SEGVALUX")) {
                    ((SSASubpage)detachedView.getActivePage()).hideValueColumns();
                }
                return null;
            }
        }
        return null;
    }
}

