/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.Activator;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.MonitorHistoryServerCallback;
import com.ca.mat.connect.MonitorProfileServerCallback;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.MonitorHistoryView;
import com.ca.mat.xml.XMLRequest;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        Display display = HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay();
        AnalysisManager analManager = Singletons.getAnalysisManager(display);
        if (commandId.equals("com.ca.mat.commands.refreshlocalfiles")) {
            analManager.refreshLocalXMLViews();
        } else if (commandId.equals("com.ca.mat.commands.refreshservers")) {
            this.refreshServers(display);
        }
        return null;
    }

    public void refreshServers(Display display) {
        try {
            ServerCallback callback = new MonitorProfileServerCallback();
            int type = 8;
            int scale = 2;
            MonitorManager monitorManager = Singletons.getMonitorManager(display);
            ServerProxy serverProxy = Singletons.getServerProxy(display);
            if (serverProxy != null) {
                MATServer server;
                serverProxy.refreshServerStatus();
                if (monitorManager != null && monitorManager.hasListeners() && (server = serverProxy.getConnectedServer()) != null && server.getStatus() != 4 && server.getStatus() != 1) {
                    IViewReference[] refs;
                    server.setStatusText(4, "Refreshing..");
                    serverProxy.list(type, scale, callback, true);
                    IViewReference[] iViewReferenceArray = refs = Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MonitorHistoryView view;
                        IViewReference ref = iViewReferenceArray[n2];
                        if (ref.getId().startsWith("com.ca.mat.views.monitorhistoryview") && (view = (MonitorHistoryView)ref.getView(false)) != null) {
                            type = 2;
                            callback = new MonitorHistoryServerCallback(view.getProfile(), false);
                            serverProxy.listHistory(view.getProfile(), scale, callback, true);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (SWTException e) {
            if ("Device is disposed".equals(e.getMessage())) {
                return;
            }
            throw e;
        }
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager().unregisterTempFile(reply.getAttachedFile());
        }
    }
}

