/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.rowmodels.LogRowModel;
import com.ca.mat.rowmodels.LogViewRowModel;
import com.ca.mat.utils.TextUtil;
import com.ca.mat.views.LogView;
import com.ca.mat.views.pages.IPageTextViewer;
import com.ca.mat.views.pages.PageTextViewerFactory;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;

public class MATLogDetailDialog
extends TrayDialog
implements ISelectionChangedListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    protected static final String baseclass = MATLogDetailDialog.class.getName();
    static Map<Display, MATLogDetailDialog> dialogs = new WeakHashMap<Display, MATLogDetailDialog>();
    SashForm sashForm;
    String pluginId;
    boolean isOpen = false;
    private Button backButton;
    private Button nextButton;
    private Label severityImageLabel;
    private Label dateLabel;
    private Label severityLabel;
    private Text msgText;
    private IPageTextViewer detailsText;
    private LogView logView;

    protected MATLogDetailDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3312);
        IViewPart part = Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.ca.mat.views.logview");
        if (part != null && part instanceof LogView) {
            this.logView = (LogView)part;
            this.logView.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createSashForm(container);
        this.createMainSection((Composite)this.getSashForm());
        this.createDetailsSection((Composite)this.getSashForm());
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format("Log Item Detail", new Object[0]));
    }

    private void createSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.sashForm.setLayout((Layout)layout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setSashWidth(10);
    }

    private SashForm getSashForm() {
        return this.sashForm;
    }

    private void createToolbarButtonBar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        ((GridData)comp.getLayoutData()).verticalAlignment = 1024;
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.backButton = this.createButton(container, 14, "", false);
        GridData gd = new GridData(768);
        this.backButton.setLayoutData((Object)gd);
        this.backButton.setToolTipText("Previous");
        this.backButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.prev"));
        this.backButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MATLogDetailDialog.this.doPrev();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nextButton = this.createButton(container, 15, "", false);
        gd = new GridData();
        this.nextButton.setLayoutData((Object)gd);
        this.nextButton.setToolTipText("Next");
        this.nextButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.next"));
        this.nextButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MATLogDetailDialog.this.doNext();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        layout.numColumns = 1;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    private void createMainSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.heightHint = 200;
        container.setLayoutData((Object)data);
        this.createTextSection(container);
        this.createToolbarButtonBar(container);
    }

    private void createTextSection(Composite parent) {
        Composite textContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textContainer.setLayout((Layout)layout);
        textContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(textContainer, 0);
        label.setText("Date");
        this.dateLabel = new Label(textContainer, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.dateLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Severity");
        this.severityImageLabel = new Label(textContainer, 0);
        this.severityLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        this.severityLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Message");
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.msgText = new Text(textContainer, 2626);
        this.msgText.setEditable(false);
        gd = new GridData(1810);
        gd.horizontalSpan = 2;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = TextUtil.calculateWidth((Control)this.msgText, 35);
        this.msgText.setLayoutData((Object)gd);
    }

    private void createDetailsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Details");
        gd = new GridData();
        gd.verticalAlignment = 1024;
        label.setLayoutData((Object)gd);
        this.detailsText = PageTextViewerFactory.createNew(container, 2818);
        this.detailsText.getControl().setFont(JFaceResources.getTextFont());
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.minimumWidth = TextUtil.calculateWidth((Control)this.msgText, 35);
        gd.minimumHeight = TextUtil.calculateWidth((Control)this.msgText, 10);
        this.detailsText.getControl().setLayoutData((Object)gd);
        this.detailsText.setEditable(false);
    }

    public int open() {
        int a;
        int b;
        this.isOpen = true;
        int height = this.getSashForm().getClientArea().height;
        if (height < 250) {
            a = b = height / 2;
        } else {
            a = 100;
            b = height - a;
        }
        int[] sashWeights = new int[]{a, b};
        this.getSashForm().setWeights(sashWeights);
        return super.open();
    }

    public boolean close() {
        this.logView.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.isOpen = !super.close();
        return !this.isOpen;
    }

    protected void showLogRecord(LogViewRowModel logRow) {
        String level = logRow.getLevel();
        this.severityLabel.setText(logRow.getLevel());
        if (level.equals(Level.SEVERE.getName())) {
            this.severityImageLabel.setImage(Activator.getDefault().getImageRegistry().get("com.ca.mat.plugin.statusError"));
        } else if (level.equals(Level.WARNING.getName())) {
            this.severityImageLabel.setImage(Activator.getDefault().getImageRegistry().get("com.ca.mat.plugin.statusWarning"));
        } else if (level.equals(Level.INFO.getName())) {
            this.severityImageLabel.setImage(Activator.getDefault().getImageRegistry().get("com.ca.mat.plugin.statusInfo"));
        } else {
            this.severityImageLabel.setImage(Activator.getDefault().getImageRegistry().get("com.ca.mat.plugin.statusOk"));
        }
        this.dateLabel.setText(logRow.getDateTimeStr());
        this.msgText.setText(logRow.getMessage());
        MATTableModel model = new MATTableModel();
        if (logRow.getDetails() != null) {
            for (String line : logRow.getDetails()) {
                model.addRow(new LogRowModel(model, line));
            }
        }
        this.detailsText.setModel(model, false);
    }

    private void doPrev() {
        if (this.logView != null) {
            this.showLogRecord(this.logView.getPrevious());
        }
    }

    private void doNext() {
        if (this.logView != null) {
            this.showLogRecord(this.logView.getNext());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection sel;
        if (event.getSelection() instanceof StructuredSelection && (sel = (StructuredSelection)event.getSelection()).getFirstElement() != null && sel.getFirstElement() instanceof LogViewRowModel) {
            this.showLogRecord((LogViewRowModel)sel.getFirstElement());
        }
    }

    public static MATLogDetailDialog getInstance(Shell parent) {
        if (!dialogs.containsKey(parent.getDisplay()) || !MATLogDetailDialog.dialogs.get((Object)parent.getDisplay()).isOpen) {
            MATLogDetailDialog instance = new MATLogDetailDialog(parent);
            instance.create();
            dialogs.put(parent.getDisplay(), instance);
        }
        return dialogs.get(parent.getDisplay());
    }

    public static void open(Shell parent, LogViewRowModel logRow) {
        MATLogDetailDialog instance = MATLogDetailDialog.getInstance(parent);
        instance.showLogRecord(logRow);
        if (!instance.isOpen) {
            instance.open();
        }
    }
}

