/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.connect.MATServer;
import com.ca.mat.dialogs.TestingToolsDialog;
import com.ca.mat.managers.Singletons;
import com.ca.mat.utils.TextUtil;
import com.ca.mat.utils.VerifyDigit;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.AnalysisView;
import com.ca.mat.views.MonitorHistoryView;
import java.util.UUID;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class AddServerDialog
extends TestingToolsDialog {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private Composite composite;
    private String title;
    private static final String NAME = "Name";
    private static final String HOST = "Host";
    private static final String PORT = "Port";
    private static final String PROTOCOL = "Protocol";
    private Label nameLabel;
    private Label hostLabel;
    private Label portLabel;
    private Label protocolLabel;
    private Text nameField;
    private Text hostField;
    private Text portField;
    private Combo protocolField;
    private MATServer server;

    public AddServerDialog(Shell parent) {
        super(parent);
        this.CONTEXT_HELP_ID = "com.ca.mat.help.registerlistingdialog";
        this.title = "New Server Definition";
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        this.composite = new Composite(superComposite, 4);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(4, 0, true, false);
        this.composite.setLayoutData((Object)gData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.CONTEXT_HELP_ID);
        this.nameLabel = new Label(this.composite, 0);
        this.nameLabel.setText(NAME);
        gData = new GridData(32);
        this.nameLabel.setLayoutData((Object)gData);
        this.nameField = new Text(this.composite, 4);
        gData = new GridData(4, 0, true, false);
        gData.widthHint = gData.minimumWidth = TextUtil.calculateWidth((Control)this.nameField, 20);
        this.nameField.setLayoutData((Object)gData);
        this.nameField.setTextLimit(20);
        this.hostLabel = new Label(this.composite, 0);
        this.hostLabel.setText(HOST);
        gData = new GridData(32);
        this.hostLabel.setLayoutData((Object)gData);
        this.hostField = new Text(this.composite, 4);
        gData = new GridData(4, 0, true, false);
        gData.widthHint = gData.minimumWidth = TextUtil.calculateWidth((Control)this.hostField, 20);
        this.hostField.setLayoutData((Object)gData);
        this.portLabel = new Label(this.composite, 0);
        this.portLabel.setText(PORT);
        gData = new GridData(32);
        this.portLabel.setLayoutData((Object)gData);
        this.portField = new Text(this.composite, 4);
        this.portField.setTextLimit(5);
        this.portField.setToolTipText(String.format("Port must be number not greater than %d", 65535));
        this.portField.addVerifyListener((VerifyListener)new VerifyDigit(false));
        gData = new GridData(0, 0, false, false);
        gData.widthHint = gData.minimumWidth = TextUtil.calculateWidth((Control)this.portField, 5);
        this.portField.setLayoutData((Object)gData);
        this.protocolLabel = new Label(this.composite, 0);
        this.protocolLabel.setText(PROTOCOL);
        gData = new GridData(32);
        this.protocolLabel.setLayoutData((Object)gData);
        this.protocolField = new Combo(this.composite, 8);
        this.protocolField.add("HTTP");
        this.protocolField.add("HTTPS");
        this.protocolField.select(1);
        this.getShell().setDefaultButton(this.getButton(1));
        return this.composite;
    }

    public void setServer(MATServer server) {
        this.server = server;
        this.nameField.setText(server.getName());
        this.hostField.setText(server.getHostname());
        this.portField.setText(String.valueOf(server.getPort()));
        if (server.getProtocol().equalsIgnoreCase("HTTP")) {
            this.protocolField.select(0);
        } else {
            this.protocolField.select(1);
        }
        this.title = "Update Server Definition";
        this.getShell().setText(this.title);
    }

    protected void okPressed() {
        Shell shell = this.getShell();
        if (this.nameField.getText() == "") {
            MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please enter name");
            return;
        }
        if (this.hostField.getText() == "") {
            MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please enter host");
            return;
        }
        if (this.portField.getText() == "") {
            MessageDialog.openInformation((Shell)shell, (String)"Missing information", (String)"Please enter port");
            return;
        }
        try {
            int port = Integer.valueOf(this.portField.getText());
            if (port > 65500) {
                MessageDialog.openInformation((Shell)shell, (String)"Incorrect input", (String)"Port must be a number not greater than 65535");
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openInformation((Shell)shell, (String)"Incorrect input", (String)"Port must be a number not greater than 65535");
            return;
        }
        if (this.server == null) {
            this.server = new MATServer(this.nameField.getText(), this.hostField.getText(), this.portField.getText(), UUID.randomUUID().toString(), this.getContents().getDisplay());
            this.server.setProtocol(this.protocolField.getText());
            Singletons.getServerList(this.getContents().getDisplay()).addServer(this.server);
        } else {
            boolean refreshNeeded = false;
            if (!this.server.getHostname().equals(this.hostField.getText())) {
                refreshNeeded = true;
            }
            if (this.server.getPort() != Integer.valueOf(this.portField.getText()).intValue()) {
                refreshNeeded = true;
            }
            if (!this.server.getProtocol().equalsIgnoreCase(this.protocolField.getText())) {
                refreshNeeded = true;
            }
            if (refreshNeeded) {
                if (Singletons.getServerProxy(this.getContents().getDisplay()).isConnected(this.server)) {
                    String format;
                    String msg;
                    boolean confirm;
                    boolean anyViewsOpen;
                    boolean bl = anyViewsOpen = MonitorHistoryView.anyOpen() || AnalysisView.anyOpen() || AnalysisTabbedView.anyOpen();
                    if (anyViewsOpen && !(confirm = MessageDialog.openConfirm((Shell)shell, (String)"Related views will close", (String)(msg = String.format(format = "You have open views related to server %s. Disconnecting from the server will close these views. Do you want to proceed?", this.server.getName()))))) {
                        return;
                    }
                    this.server.setName(this.nameField.getText());
                    this.server.setHostname(this.hostField.getText());
                    this.server.setPort(Integer.valueOf(this.portField.getText()));
                    this.server.setProtocol(this.protocolField.getText());
                    Singletons.getServerProxy(this.getContents().getDisplay()).disconnect(this.server);
                } else {
                    this.server.setName(this.nameField.getText());
                    this.server.setHostname(this.hostField.getText());
                    this.server.setPort(Integer.valueOf(this.portField.getText()));
                    this.server.setProtocol(this.protocolField.getText());
                    this.server.setStatusText(11, "Unknown");
                    Singletons.getServerProxy(this.getContents().getDisplay()).refreshServerStatus(this.server);
                }
            } else {
                this.server.setName(this.nameField.getText());
            }
        }
        super.okPressed();
    }

    @Override
    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    @Override
    protected int getDialogBoundsStrategy() {
        return 0;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format("%s", this.title));
    }
}

