/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rcp;

import com.ca.mat.rcp.ApplicationActionBarAdvisor;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IEvaluationService;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    static String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String TITLE = "CA Mainframe Application Tuner";

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowStatusLine(true);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IPerspectiveDescriptor perspective = window.getActivePage().getPerspective();
        this.setTitle(perspective);
        window.addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationWorkbenchWindowAdvisor.this.setTitle(perspective);
                ApplicationWorkbenchWindowAdvisor.this.setCoolBarVisible();
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                ApplicationWorkbenchWindowAdvisor.this.setTitle(perspective);
            }
        });
    }

    private void setCoolBarVisible() {
        boolean isVisible;
        IEvaluationService eservice = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        IEvaluationContext appState = eservice.getCurrentState();
        Object coolbar = appState.getVariable("activeWorkbenchWindow.isCoolbarVisible");
        if (coolbar instanceof Boolean && !(isVisible = ((Boolean)coolbar).booleanValue())) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                service.executeCommand("org.eclipse.ui.ToggleCoolbarAction", null);
            }
            catch (Exception exception) {}
        }
    }

    private void setTitle(IPerspectiveDescriptor perspective) {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String title = String.format("%s", TITLE);
        configurer.setTitle(title);
    }

    public boolean preWindowShellClose() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException coreException) {}
        return true;
    }
}

