/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.MATException;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.IPageWithModes;
import com.ca.mat.views.pages.PageWithModesContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeViewPage
extends AnalysisPageCalculated
implements IPageWithModes {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = CodeViewPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private static final String ID_ROOT = "com.ca.mat.pages.codeview";
    public static final String ID_CSECT = "com.ca.mat.pages.codeview.csect";
    public static final String ID_MODULE = "com.ca.mat.pages.codeview.module";
    public static final String ID_PSEUDO = "com.ca.mat.pages.codeview.pseudo";
    public String CONTEXT_HELP_ID = "com.ca.mat.help.codeview";
    static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.codeview.histogram";
    public static final String TTASKID = "ttaskid";
    public static final String SECTION_NAME = "Code View";
    private String modeType = CodeViewRowModel.TYPE_CSECT;
    private String taskId = null;
    private String transactionId = null;
    private String taskName = null;
    private String stmtNum;
    private String dbrm;
    private String currentMode = CodeViewRowModel.TYPE_CSECT;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        if (this.modeType.equals(CodeViewRowModel.TYPE_CSECT)) {
            viewer.addColumn("Module", 5, "Module", 1, true, false);
            viewer.addColumn("Csect", 5, "Csect", 1, true, false);
            viewer.addColumn("Description", 7, "Description", 1, true, true);
            viewer.addColumn("L", 1, "L", 1, true, true);
            viewer.addColumn("C", 1, "C", 1, true, true);
            viewer.addColumn("X", 1, "X", 1, true, true);
            viewer.addColumn("Active %", 4, "Active %", 9, true, true);
            viewer.addColumn("Wait %", 4, "Wait %", 9, true, true);
            viewer.addColumn("Total %", 4, "Total %", 9, true, true);
            viewer.addColumn("Overlap %", 4, "Overlap %", 9, true, true);
            viewer.setDefaultSortColumn(8);
            viewer.setDefaultSortDirection(1024);
        } else if (this.modeType.equals(CodeViewRowModel.TYPE_MODULE)) {
            viewer.addColumn("Group", 5, null, 1, true, false);
            viewer.addColumn("Module", 5, null, 1, true, false);
            viewer.addColumn("Description", 7, null, 1, true, true);
            viewer.addColumn("L", 1, null, 1, false, true);
            viewer.addColumn("C", 1, null, 1, false, true);
            viewer.addColumn("X", 1, null, 1, false, true);
            viewer.addColumn("Active %", 4, null, 9, true, true);
            viewer.addColumn("Wait %", 4, null, 9, true, true);
            viewer.addColumn("Total %", 4, null, 9, true, true);
            viewer.addColumn("Overlap %", 4, null, 9, true, true);
            viewer.setDefaultSortColumn(5);
            viewer.setDefaultSortDirection(1024);
        } else if (this.modeType.equals(CodeViewRowModel.TYPE_PSEUDO)) {
            viewer.addColumn("Group", 5, null, 1, true, false);
            viewer.addColumn("Description", 7, null, 1, true, true);
            viewer.addColumn("Active %", 4, null, 9, true, true);
            viewer.addColumn("Wait %", 4, null, 9, true, true);
            viewer.addColumn("Total %", 4, null, 9, true, true);
            viewer.addColumn("Overlap %", 4, null, 9, true, true);
            viewer.setDefaultSortColumn(4);
            viewer.setDefaultSortDirection(1024);
        } else {
            throw new RuntimeException("mode for CodeView is not set");
        }
    }

    @Override
    public String getId() {
        if (CodeViewRowModel.TYPE_CSECT.equals(this.modeType)) {
            return ID_CSECT;
        }
        if (CodeViewRowModel.TYPE_MODULE.equals(this.modeType)) {
            return ID_MODULE;
        }
        if (CodeViewRowModel.TYPE_PSEUDO.equals(this.modeType)) {
            return ID_PSEUDO;
        }
        throw new MATException("Invalid CodeView mode: " + this.modeType);
    }

    @Override
    public String getContextHelpId() {
        return this.CONTEXT_HELP_ID;
    }

    @Override
    public void setContextHelpId(String contextHelpId) {
        this.CONTEXT_HELP_ID = contextHelpId;
    }

    @Override
    protected String getViewerMementoType() {
        String VIEWER_MEMENTO_TYPE = null;
        if (this.modeType.equals(CodeViewRowModel.TYPE_CSECT)) {
            VIEWER_MEMENTO_TYPE = "pages.codeview.csect.viewer";
        } else if (this.modeType.equals(CodeViewRowModel.TYPE_MODULE)) {
            VIEWER_MEMENTO_TYPE = "pages.codeview.module.viewer";
        } else if (this.modeType.equals(CodeViewRowModel.TYPE_PSEUDO)) {
            VIEWER_MEMENTO_TYPE = "pages.codeview.pseudo.viewer";
        }
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }

    public void setModeType(String modeType) {
        this.modeType = modeType;
    }

    public String getModeType() {
        return this.modeType;
    }

    @Override
    public String getAdditionalTitleText() {
        return "Mode: " + this.modeType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
        this.setFilterValue("Task Id", taskId);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        this.setFilterValue("Transaction", transactionId);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setDB2Id(String dbrm, String stmtNum) {
        this.dbrm = dbrm;
        this.stmtNum = stmtNum;
        this.setFilterValue("tdbrm", dbrm);
        this.setFilterValue("tdbrmnr", stmtNum);
    }

    public String getDBRM() {
        return this.dbrm;
    }

    public String getDBRMNR() {
        return this.stmtNum;
    }

    @Override
    public PageWithModesContainer changeMode(String newMode) {
        this.currentMode = newMode;
        Map<String, Object[]> activeInternalFilters = this.getFilterExpressions();
        HashMap<String, Object[]> newFilters = new HashMap<String, Object[]>();
        for (Map.Entry<String, Object[]> entry : activeInternalFilters.entrySet()) {
            newFilters.put(entry.getKey(), entry.getValue());
        }
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.getDSN(), "TimeView", this.type);
        model = model.filterBy(newFilters);
        model = AnalysisUtils.calculateCodeView(model, this.getDSN(), this.type);
        if (newMode != CodeViewRowModel.TYPE_CSECT) {
            model = AnalysisUtils.changeCodeViewMode(model, newMode, this.dsn);
        }
        CodeViewPage result = new CodeViewPage();
        result.setDSN(this.dsn);
        result.setType(this.type);
        result.setTaskId(this.getTaskId());
        result.setTransactionId(this.getTransactionId());
        result.setDB2Id(this.getDBRM(), this.getDBRMNR());
        result.setTaskId(this.getTaskId());
        result.setModeType(newMode);
        result.setFilterExpressions(newFilters);
        result.currentMode = newMode;
        result.setModel(model);
        return new PageWithModesContainer(result, model);
    }

    @Override
    public String getRootId() {
        return ID_ROOT;
    }

    @Override
    public String getCurrentMode() {
        return this.currentMode;
    }
}

