/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.rowmodels.ExplainInformationStmtRowModel;
import com.ca.mat.rowmodels.tuntables.TunexplRowModel;
import java.util.ArrayList;
import java.util.List;

public class DB2ExplainRulesList {
    private static DB2ExplainRulesList instance;

    private DB2ExplainRulesList() {
    }

    public static DB2ExplainRulesList getInstance() {
        if (instance == null) {
            instance = new DB2ExplainRulesList();
        }
        return instance;
    }

    public int getRuleCount() {
        return 77;
    }

    public boolean checkRule(int i, TunexplRowModel eRow) {
        switch (i) {
            case 0: {
                return true;
            }
            case 1: {
                return !eRow.getMethod().equals("3") && !eRow.getAccessName().trim().isEmpty();
            }
            case 2: {
                return !eRow.getMethod().equals("3") && !eRow.getAccessType().equals("M") && !eRow.getQueryBlockType().equals("INSERT") && eRow.getAccessName().trim().isEmpty();
            }
            case 3: {
                return eRow.getPlanNo().equals("1");
            }
            case 4: {
                return eRow.getMethod().equals("3");
            }
            case 5: {
                return eRow.getMethod().equals("1");
            }
            case 6: {
                return eRow.getMethod().equals("1");
            }
            case 7: {
                return eRow.getMethod().equals("2");
            }
            case 8: {
                return eRow.getMethod().equals("2");
            }
            case 9: {
                return eRow.getMethod().equals("4");
            }
            case 10: {
                return eRow.getMethod().equals("4");
            }
            case 11: {
                return eRow.getType().equals("R");
            }
            case 12: {
                return eRow.getType().equals("R");
            }
            case 13: {
                return eRow.getType().equals("I");
            }
            case 14: {
                return eRow.getType().equals("I1");
            }
            case 15: {
                return eRow.getType().equals("N");
            }
            case 16: {
                return eRow.getType().equals("M");
            }
            case 17: {
                return eRow.getType().equals("MX");
            }
            case 18: {
                return eRow.getType().equals("MI");
            }
            case 19: {
                return eRow.getType().equals("MU");
            }
            case 20: {
                return eRow.getSortCompUnique_Formatted().equals("YES") || eRow.getSortCompOrderBy_Formatted().equals("YES") || eRow.getSortCompGroupBy_Formatted().equals("YES");
            }
            case 21: {
                return eRow.getSortCompJoin_Formatted().equals("YES") && eRow.getMethod().equals("1");
            }
            case 22: {
                return eRow.getMatchCols().equals("0") && (eRow.getType().equals("I") || eRow.getType().equals("N") || eRow.getType().equals("MX"));
            }
            case 23: {
                return eRow.getMatchCols().equals("0") && (eRow.getType().equals("I") || eRow.getType().equals("N") || eRow.getType().equals("MX"));
            }
            case 24: {
                return !eRow.getSortCGroupID().equals("Y");
            }
            case 25: {
                return eRow.getIndexOnly_Formatted().equals("YES");
            }
            case 26: {
                return eRow.getIndexOnly_Formatted().equals("NO");
            }
            case 27: {
                return eRow.getSortNewUnique_Formatted().equals("YES");
            }
            case 28: {
                return eRow.getSortNewJoin_Formatted().equals("YES") && eRow.getMethod().equals("2");
            }
            case 29: {
                return eRow.getSortNewJoin_Formatted().equals("YES") && eRow.getMethod().equals("4");
            }
            case 30: {
                return eRow.getSortNewJoin_Formatted().equals("YES") && eRow.getMethod().equals("4");
            }
            case 31: {
                return eRow.getSortNewOrderBy_Formatted().equals("YES");
            }
            case 32: {
                return !eRow.getSortNGroupID().equals("Y");
            }
            case 33: {
                return eRow.getSortNewGroupBy_Formatted().equals("YES");
            }
            case 34: {
                return eRow.getSortNewUnique_Formatted().equals("YES");
            }
            case 35: {
                return eRow.getSortCompJoin_Formatted().equals("YES") && eRow.getMethod().equals("2");
            }
            case 36: {
                return eRow.getSortCompJoin_Formatted().equals("YES") && eRow.getMethod().equals("4");
            }
            case 37: {
                return eRow.getSortCompOrderBy_Formatted().equals("YES");
            }
            case 38: {
                return eRow.getPageRange_Formatted().trim().equals("Y");
            }
            case 39: {
                return eRow.getSortCompGroupBy_Formatted().equals("YES");
            }
            case 40: {
                return eRow.getJoinType_Formatted().equals("F: (Full Outer JOIN)");
            }
            case 41: {
                return eRow.getLockMode_Formatted().equals("IS: (Intent Share LOCK)");
            }
            case 42: {
                return eRow.getLockMode_Formatted().equals("U: (Update LOCK)");
            }
            case 43: {
                return eRow.getPrefetch_Formatted().equals("S: (Sequential PREFETCH can be used)");
            }
            case 44: {
                return eRow.getFnEval_Formatted().equals("R: (Evaluation Done at Data Retrieval Time)");
            }
            case 45: {
                return eRow.getFnEval_Formatted().equals("S: (Evaluation Done at Start Time)");
            }
            case 46: {
                return eRow.getFnEval_Formatted().equals("** N/A **: (Evaluation Time Unknown)");
            }
            case 47: {
                return eRow.getType().equals("M") && !eRow.getMultipleIndex_Formatted().equals("0");
            }
            case 48: {
                return !eRow.getAccessDegree().trim().equals("0");
            }
            case 49: {
                return eRow.getJoinType_Formatted().equals("S: (Star JOIN)");
            }
            case 50: {
                return !eRow.getJoinDegree_Formatted().equals("Y") && !eRow.getJoinDegree().trim().equals("0");
            }
            case 51: {
                return !eRow.getJoinGroup_Formatted().equals("Y") && !eRow.getJoinGroup().trim().equals("0");
            }
            case 52: {
                return eRow.getLockMode_Formatted().equals("S: (Share LOCK)");
            }
            case 53: {
                return eRow.getLockMode_Formatted().equals("IX: (Intent Exclusive LOCK)");
            }
            case 54: {
                return eRow.getLockMode_Formatted().equals("SIX: (Share with Intent Exclusive Lock)");
            }
            case 55: {
                return eRow.getLockMode_Formatted().equals("E: (Exclusive Lock)");
            }
            case 56: {
                return eRow.getLockMode_Formatted().equals("IX: (Intent Exclusive LOCK)") && eRow.getType().equals("R");
            }
            case 57: {
                return eRow.getLockMode_Formatted().equals("X: (Exclusive LOCK)") && eRow.getType().equals("R");
            }
            case 58: {
                return eRow.getLockMode_Formatted().trim().equals("N");
            }
            case 59: {
                return eRow.getLockMode_Formatted().equals("** N/A **");
            }
            case 60: {
                return eRow.getLockMode_Formatted().trim().equals("NS");
            }
            case 61: {
                return eRow.getLockMode_Formatted().trim().equals("NIS");
            }
            case 62: {
                return eRow.getLockMode_Formatted().trim().equals("NSS");
            }
            case 63: {
                return eRow.getLockMode_Formatted().trim().equals("SS");
            }
            case 64: {
                return false;
            }
            case 65: {
                return eRow.getPrefetch_Formatted().equals("L: (List PREFETCH can be used)");
            }
            case 66: {
                return eRow.getPrefetch_Formatted().equals("L: (List PREFETCH can be used)") && !eRow.getQueryBlockType().equals("UPDATE");
            }
            case 67: {
                return eRow.getPrefetch_Formatted().equals("** N/A **: (PREFETCH NOT used or use is unknown)");
            }
            case 68: {
                return eRow.getParaMode().equals("I");
            }
            case 69: {
                return eRow.getParaMode().equals("C");
            }
            case 70: {
                return eRow.getParaMode().equals("X");
            }
            case 71: {
                return false;
            }
            case 72: {
                return false;
            }
            case 73: {
                return false;
            }
            case 74: {
                return false;
            }
            case 75: {
                return !eRow.getOphintUsed_Formatted().equals("** N/A **") && !eRow.getOphintUsed_Formatted().equals("00");
            }
            case 76: {
                return false;
            }
        }
        return false;
    }

    public List<ExplainInformationStmtRowModel> getRow(int i, TunexplRowModel eRow, TunexplRowModel prevRow, MATTableModel model) {
        ArrayList<ExplainInformationStmtRowModel> result = new ArrayList<ExplainInformationStmtRowModel>();
        switch (i) {
            case 0: {
                String tableName = eRow.getFullTableName();
                if (tableName.trim().isEmpty() && prevRow != null) {
                    tableName = prevRow.getFullTableName();
                }
                result.add(new ExplainInformationStmtRowModel(model, "TE0000", "Step no. " + eRow.getPlanNo() + " is accessing " + tableName, "Information Message", "  "));
                return result;
            }
            case 1: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0001", "This table is being accessed with an index " + eRow.getFullIndexName(), "Information Message", "  "));
                return result;
            }
            case 2: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0002", "This table is not being accessed with an index", "Information Message", "  "));
                return result;
            }
            case 3: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0003", "This is the first table in the query", "Information Message", "  "));
                return result;
            }
            case 4: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0004", "This is a sort step. A sort is needed for this step to satisfy an ORDER BY,", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "GROUP BY, SELECT, DISTINCT, UNION or a quantified predicate.", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", " This step does not access a new table", "  ", "  "));
                return result;
            }
            case 5: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0005", "This table is being accessed using a Nested Loop Join. For every row in", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "the composite table, matching rows of a new table are found and joined.", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "Sequential detection and Index Lookaside will be used when possible", "  ", "  "));
                return result;
            }
            case 6: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0006", "Nested Loop: Few rows qualify for Join. Predicates on the composite", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table and small filter factors reduce the number of qualified composite", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table rows. A table with an efficient access path is the new table.", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "Non-join predicates favor the composite table", "  ", "  "));
                return result;
            }
            case 7: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0007", "This table is being accessed using a Merge Scan Join. The composite", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table and the new table are scanned in the order of the join columns", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "and are joined for matching rows", "  ", "  "));
                return result;
            }
            case 8: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0008", "MERGE SCAN: Both tables have groups of duplicates on the join column. The", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "composite table has an index on the join column, eliminating the sort. The", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table with fewer qualified rows/columns is the new table", "  ", "  "));
                return result;
            }
            case 9: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0009", "This table is being accessed using a Hybrid Join. The current", "A Hybrid Join entails a scan of the outer table, followed by a", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "composite table is scanned in the order of the join column of the", "RID retrieval from the index on the inner table, generally followed", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "new table. The new table is accessed using List Prefetch (with or", "by a sort of the intermediary table created by data from the outer table", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "without a RID sort). Multiple indexes may be used", "and the RIDs. The data from the inner table is then accessed by using List", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "Prefetch. The two answer sets are then concatenated to create the composite table", "  "));
                return result;
            }
            case 10: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0010", "Hybrid Joins should be avoided, if possible. Consider redesigning", "Information Message", "Consider refreshing the statistics or restructuring the query"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "the query or add OPTIMIZE FOR N ROWS. Statistics may need to be", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "refreshed or the query may need to be restructured", "  ", "  "));
                return result;
            }
            case 11: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0011", "The table will be accessed using a tablespace scan. Every page in", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "the tablespace will be scanned by DB2 to provide an answer", "  ", "  "));
                return result;
            }
            case 12: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0012", "Note: Unless this statement is retrieving most of the rows in this", "Performance can be improved when the optimizer uses an index", "Add columns from an existing index to the predicate or add an index"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table, consider adding an index on the most restrictive columns in ", "  ", "on the columns in the existing predicate"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "the predicate. Examine the columns in the indexes on this table and add ", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "them to the predicate if possible.", "  ", "  "));
                return result;
            }
            case 13: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0013", "The table will be accessed using an index. DB2 will access the", "DB2 can avoid reading data pages completely if all required data", "Avoid indexes on columns with low cardinality or skewed distribution."));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "index first to qualify the rows", "exists in the index", "Also avoid indexes on columns that are frequently updated because"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "  ", "it requires delete and insert processing"));
                return result;
            }
            case 14: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0014", "The table will be accessed using a One-Fetch index access.", "A One-Fetch index access is the most efficient access path which can be", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "chosen if you are only retrieving one row, you are using a MIN or MAX ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "function, and the leading columns of a composite index have equal predicates", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "A One-Fetch index access cannotbe used if there is more than one table, additional", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "column functions are specified, or if a GROUP BY clause is specified.", "  "));
                return result;
            }
            case 15: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0015", "The table will be accessed using an index scan. The matching predicate", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", " contains the IN keyword for one of the predicates", "  ", "  "));
                return result;
            }
            case 16: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0016", "The table will be accessed using multiple index scans (ACCESSTYPE=M)", "More than one index will be used to access a single table. An ACCESSTYPE", "A single index access may be more efficient. Review the indexes "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "against the new table", "of M reflects the start of the multiple index access path.", "for this application against the predicates"));
                return result;
            }
            case 17: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0017", "The table will be accessed using a multiple index scan (ACCESSTYPE=MX)", "More than one index will be used to access a single table. An ACCESSTYPE of", "A single index access may be more efficient. Review the indexes"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "on index access name " + eRow.getFullIndexName(), "MX reflects that indexes are to be scanned for later union or intersection", "for this application against the predicates"));
                return result;
            }
            case 18: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0018", "The table will be accessed by an intersection of multiple indexes", "More than one index will be used to access a single table. An ACCESSTYPE", "A single index access may be more efficient. Review the indexes"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "(ACCESSTYPE=MI). The access name is " + eRow.getFullIndexName(), "of MI reflects that an intersection (AND) is performed", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "  ", "for this application against the predicates"));
                return result;
            }
            case 19: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0019", "The table will be accessed by a union of multiple indexes (ACCESSTYPE=MU)", "More than one index will be used to access a single table. An ACCESSTYPE", "A single index access may be more efficient. Review the indexes for"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "The access name is " + eRow.getFullIndexName(), "of MU reflects that a union (OR) is performed", "this application against the predicates."));
                return result;
            }
            case 20: {
                if (eRow.getSortCompUnique_Formatted() == "YES") {
                    result.add(new ExplainInformationStmtRowModel(model, "TE0020", "The composite (resulting) table is sorted as specified for UNIQUE", "DB2 will perform only one sort based on the values present in the", "  "));
                    result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "sort composite columns", "  "));
                    return result;
                }
                if (eRow.getSortCompOrderBy_Formatted() == "YES") {
                    result.add(new ExplainInformationStmtRowModel(model, "TE0020", " The composite (resulting) table is sorted as specified for ORDER BY", " DB2 will perform only one sort based on the values present in the", "  "));
                    result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "sort composite columns", "  "));
                    return result;
                }
                if (eRow.getSortCompGroupBy_Formatted() == "YES") {
                    result.add(new ExplainInformationStmtRowModel(model, "TE0020", "The composite (resulting) table is sorted as specified for GROUP BY", "DB2 will perform only one sort based on the values present in the", "  "));
                    result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "sort composite columns", "  "));
                    return result;
                }
            }
            case 21: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0021", "A sort will be invoked on the composite table to satisfy a Nested", "For a Nested Loop Join, the composite table can be sorted before joining", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "Loop Join. This may result in additional overhead.", "the two tables. This will make the join more efficient", "  "));
                return result;
            }
            case 22: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0022", "The index will be accessed using a Nonmatching Index Scan. DB2 is", "All of the leaf pages and RIDs were read and no matching columns were", "Review the situations in which a Nonmatching Index Scan is acceptable"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "unable to exactly match the column or columns defined in the index.", "found. A Nonmatching Index Scan might be considered a good access path", " "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", " ", "if index screening is used, OPTIMIZE FOR n ROWS is used with an ", " "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", " ", "ORDER BY matching the index, or when a nonsegmented table space has", " "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", " ", "more than one table in it.", " "));
                return result;
            }
            case 23: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0023", "Note: If an index is composed of COL1, COL2 and COL3, and the", "The optimizer was not able to match on any columns in the index. A scan", "Add the missing columns to the predicate, or add the columns in"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "statement provides predicates for COL2 and COL3, add COL1 to the", "can be avoided by changing the index or the predicate", "the predicate to the index, or create a new index with the columns"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "predicate (if possible) or modify the index, or create a new index with", " ", "in the predicate"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "COL2 or COL3 as the first column.", " ", " "));
                return result;
            }
            case 24: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0024", "The parallel group ID to be used for the parallel sort of the composite", "The SORTC_PGROUP_ID identifies the parallel group in which the parallel", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table is " + eRow.getSortCGroup(), "sort of the composite table will take place.", "  "));
                return result;
            }
            case 25: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0025", "The index contains enough information to satisfy this portion of the query", "DB2 can avoid reading data pages completely if all required data exists in", "This is the recommended access path"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "without accessing the underlying table.", "the index.", "This is the recommended access path."));
                return result;
            }
            case 26: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0026", "The table data pages will be accessed to satisfy this portion of the query.", "The table data pages must be accessed for an UPDATE or DELETE statement,", "Review the columns in your query to see if any can be removed to enable an"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "This requires additional overhead.", "or if the selected columns are not in the index", "index only access path"));
                return result;
            }
            case 27: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0027", "A sort will be invoked to remove duplicate rows on the new table. This ", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "requires additional processing overhead", "  ", "  "));
                return result;
            }
            case 28: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0028", "A sort will be invoked on the new table to satisfy a Merge Scan Join. The", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "inner table is not clustered by the join columns. This may result ", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "in additional overhead", "  ", "  "));
                return result;
            }
            case 29: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0029", "A sort will be invoked on the new table to satisfy a Hybrid Join. The inner", "If the index is a clustering index, this query may benefit from a table space", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table index was not well clustered. This may result in additional overhead", "reorg. A well clustered inner table will not require a RID sort", "  "));
                return result;
            }
            case 30: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0030", "Note: If the index is a clustering index, this query may benefit from a table", "When an index is clustered, records are inserted as close as possible to the", "Consider a table space reorg"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "space reorg. A well-clustered inner table will not require a RID sort", "order defined by the index. This improves performance especially when many", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "records are involved. A reorg will help keep the index in clustered order and", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "improve performance", "  "));
                return result;
            }
            case 31: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0031", "A sort will be invoked to satisfy an ORDER BY on the new table. This requires", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "additional processing overhead", "  ", "  "));
                return result;
            }
            case 32: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0032", "The parallel group ID to be used for the parallel sort of the new table is " + eRow.getSortNGroup(), "The SORTN_PGROUP_ID identifies the parallel group in which the parallel sort of the", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "new table will take place", "  "));
                return result;
            }
            case 33: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0033", "A sort will be invoked to satisfy a GROUP BY on the new table. This requires", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "additional processing overhead", "  ", "  "));
                return result;
            }
            case 34: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0034", "A sort will be invoked to remove duplicate rows on the composite table. This", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "requires additional processing overhead", "  ", "  "));
                return result;
            }
            case 35: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0035", "A sort will be invoked on the composite table to satisfya Merge Scan Join. The outer", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table is not clustered by the join columns. This may result in additional overhead", "  ", "  "));
                return result;
            }
            case 36: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0036", "A sort will be invoked on the composite table to satisfy a Hybrid Join. The outer", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "table is not clustered by the join columns. This may result in additional overhead", "  ", "  "));
                return result;
            }
            case 37: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0037", "A sort will be invoked to satisfy an ORDER BY on the composite table.", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "This requires additional processing overhead", "  ", "  "));
                return result;
            }
            case 38: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0038", "Limited partition scanning will be performed", "The table qualifies for page range screening. The application plan scans only", "This is the recommended option"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "the partitions that are needed", "  "));
                return result;
            }
            case 39: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0039", "A sort will be invoked to satisfy a GROUP BY on the composite table. This requires", "Information Message", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "additional processing overhead", "  ", "  "));
                return result;
            }
            case 40: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0040", "A full outer join will be performed", "This signifies the type of join that will be performed. A full outer join includes", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "unmatched rows from both tables", "  "));
                return result;
            }
            case 41: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0041", "The LOCK mode for this access is Intent Share", "Information Message", "  "));
                return result;
            }
            case 42: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0042", "The LOCK mode for this access is Update", "The lock owner may only read the locked data. However, the owner can promote the ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "lock to an X (eXclusive) lock and then change the data. Processes which are concurrent", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "with the U (Update) lock can acquire S (Share) locks and read the data but no", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "concurrent process can acquire a U (Update) lock. The lock owner does not need page", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "locks. U (Update) locks reduce the chance of deadlocks when the lock owner is reading", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "data to determine whether to update it", "  "));
                return result;
            }
            case 43: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0043", "The data will be retrieved using Sequential Prefetch", "Sequential prefetch will allow I/Os to be done for data before the data is actually", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "requested by the program. This will allow the application to not have to wait for I/Os", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "to complete. Generally, it will be used for tablespace and Non-matching index scans", "  "));
                return result;
            }
            case 44: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0044", "Column function evaluation will occur when the data is retrieved", "This is the most efficient type of column function evaluation", "  "));
                return result;
            }
            case 45: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0045", "Column function evaluation will occur when the data is sorted", "This will have to occur in Stage 2 or RDS processing. It is not as efficient", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "as Stage 1 processing", "  "));
                return result;
            }
            case 46: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0046", "Column function evaluation is not used OR column function evaluation will be", "The column function evaluation value was blank in the PLAN_TABLE. This means that the", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "determined at execution time", "column function will be evaluated after data retrieval and after any sorts", "  "));
                return result;
            }
            case 47: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0047", "Multiple index operation", "Information Message", "  "));
                return result;
            }
            case 48: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0048", "The number of parallel tasks possible for this query is" + eRow.getAccessDegree(), "Information Message", "  "));
                return result;
            }
            case 49: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0049", "A star join will be performed", "A star join is a logical database design that is used in decision support applications.", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "It is composed of a fact table and various dimension tables", "  "));
                return result;
            }
            case 50: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0050", "The number of parallel tasks possible to join the composite table with the new table is " + eRow.getJoinDegree(), "Information Message", "  "));
                return result;
            }
            case 51: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0051", "The Group ID associated with the join parallel tasks is " + eRow.getJoinGroup(), "Information Message", "  "));
                return result;
            }
            case 52: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0052", "The LOCK mode for this access is Share. This allows concurrent read access", "Information Message", "  "));
                return result;
            }
            case 53: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0053", "The LOCK mode for this access is Intent eXclusive", "The lock owner can read data in the table or tablespace but cannot change it.", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "Concurrent processes can both read and update the data. The lock owner might", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "acquire a page lock on any data it reads", "  "));
                return result;
            }
            case 54: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0054", "The LOCK mode for this access is Share with Intent eXclusive", "The lock owner can read and change data in the table or tablespace. Concurrent ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "processes can read data in the table or tablespace but not update it. Only when the", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "lock owner changes data does it acquire page locks", "  "));
                return result;
            }
            case 55: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0055", "The LOCK mode for this access is eXclusive", "The lock owner can read or change data in the table or tablespace. No concurrent ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "process can access the data. The lock owner does not need page locks", "  "));
                return result;
            }
            case 56: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0056", "An Intent eXclusive lock will be acquired on a table accessed via a Table Space Scan.", "Information Message", "Consider using LOCK TABLE to minimize locks and Lock management overhead"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "Consider using LOCK TABLE to minimize locks and Lock management overhead. This can reduce", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "CPU usage and improve elapse time", "  ", "  "));
                return result;
            }
            case 57: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0057", "An eXclusive lock will be acquired on a table accessed via a Table Space scan. Consider", "Information Message", "Consider using LOCK TABLE to minimize locks and Lock management overhead"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "using LOCK TABLE to minimize locks and Lock management overhead. This can reduce CPU", "  ", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "usage and improve elapse time", "  ", "  "));
                return result;
            }
            case 58: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0058", "A Bind option of UR or SQL text containing WITH UR was found at bind time. DB2 will", "The actual execution time value can be determined by monitoring the objects SQL", "The possible runtime values are: "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "determine the Lock Mode at execution time", "execution by using MAT", "1) NS  - For UR isolation, no lock; For CS, RS, or RR, an S lock."));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "  ", "2) NIS - For UR isolation, no lock; For CS, RS, or RR, an IS lock."));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "  ", "3) NSS - For UR isolation, no lock; For CS or RS, an IS lock; For RR, an S lock."));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "  ", "4) SS  - For UR, CS or RS isolation, an IS lock. For RR, an S lock"));
                return result;
            }
            case 59: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0059", "No Lock is acquired", "The DB2 Optimizer returned a blank value for the column TSLOCKMODE in the PLAN_TABLE.", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "No Lock is acquired", "  "));
                return result;
            }
            case 60: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0060", "The LOCK mode cannot be determined at BIND time. The LOCK mode is No lock or Share", "If the statement is bound with an isolation level of UR (Uncommitted Read), No locks", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "will be taken. If the isolation level is CS (Cursor Stability), RS (Read Stability),", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "or RR (Repeateable Read), the lock mode at run time will be Share", "  "));
                return result;
            }
            case 61: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0061", "The LOCK mode cannot be determined at BIND time. The LOCK mode is No lock or", "If the statement is bound with an isolation level of UR (Uncommitted Read), No locks", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "Intent Share", "will be taken. If the isolation level is CS (Cursor Stability), RS (Read Stability),", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "or RR (Repeateable Read), the lock mode at run time will be Intent Share", "  "));
                return result;
            }
            case 62: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0062", "The LOCK mode cannot be determined at BIND time. The LOCK mode is No lock,", "If the statement is bound with an isolation level of UR (Uncommitted Read), No locks", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "Share, or intent Share", "will be taken. If the isolation level is CS (Cursor Stability) or RS (Read Stability),", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "the lock mode at run time will be Intent Share. For isolation level of RR", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "(Repeatable Read), the lock mode at run time will be Share", "  "));
                return result;
            }
            case 63: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0063", "The LOCK mode cannot be determined at BIND time. The LOCK mode is Share or", "If the statement is bound with an isolation level of UR (Uncommitted Read), CS", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "intent Share", "(Cursor Stability), or RS (Read Stability), the lock mode at run time will be", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "Intent Share.  If the isolation level is RR (Repeatable Read), the lock mode at run", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "time will be Share", "  "));
                return result;
            }
            case 64: {
                return null;
            }
            case 65: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0065", "List Prefetch will be used provided adequate RID pool space is available. DB2 will", "Consider using OPTIMIZE FOR N ROWS to disable List Prefetch if you access only a small number", "Investigate the query to determine the percentage of the table that will be accessed"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "disable Prefetch and revert to a tablespace scan at execution time if 25% of the table", "of rows. The optimizer will not use multiple indexes, list prefetch or sequential prefetch", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "is accessed", "if you specify the OPTIMIZE FOR 1 ROW clause", "  "));
                return result;
            }
            case 66: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0066", "Note: If not already using OPTIMIZE FOR N ROWS and the desired answer set is small,", "OPTIMIZE FOR N ROWS is a clause that will discourage the Optimizer from using List Prefetch", "Convert your SQL to use OPTIMIZE FOR N ROWS"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "consider using OPTIMIZE FOR N ROWS to avoid the cost of List Prefetch", "  ", "  "));
                return result;
            }
            case 67: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0067", "Data will be accessed without any prefetch, or prefetch is unknown", "When Prefetch is blank in the PLAN_TABLE, it means that Prefetch was not chosen as a method of", "It is always best to narrow the search with predicates to minimize the number of rows that"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "access during the BIND. This could be due to an inability to accurately estimate the number of", "must be returned to a program"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "pages to be accessed. At EXECUTION time though, either no prefetch will be used, or a prefetch", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "method called Sequential Detection might be used. If it is determined that the data access is", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "sequential, or nearly sequential, Sequential Detection could be used. However, if the underlying", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "tables in your SQL statement have referential integrity, or if an index was not explicitly", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "referenced, then Sequential Detection will not be used and data will be accessed without any prefetch", "  "));
                return result;
            }
            case 68: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0068", "Query I/O parallelism was used at BIND time", "Concurrent I/O requests for a single query are managed by Query I/O parallelism. Pages are", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "fetched into the buffer pool in parallel. This processing can improve the performance of", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "I/O-bound queries", "  "));
                return result;
            }
            case 69: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0069", "Query CP parallelism was used at BIND time", "Multi-tasking within a query is enabled via Query CP parallelism. A large query can be split", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "into many smaller queries which run at the same time on multiple processors which accesses the", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "data in parallel. This reduces the elapsed time for a query", "  "));
                return result;
            }
            case 70: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0070", "Sysplex query parallelism was used at BIND time", "With Sysplex query parallelism, large queries can e split across different DB2 members in", "  "));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "  ", "a data sharing group", "  "));
                return result;
            }
            case 71: {
                return null;
            }
            case 72: {
                return null;
            }
            case 73: {
                return null;
            }
            case 74: {
                return null;
            }
            case 75: {
                result.add(new ExplainInformationStmtRowModel(model, "TE0075", "DB2 used a Hint to determine the access path for this query. The identifier used", "A value was found in the OPTHINT field of the PLAN_TABLE and the Optimizer chose to use this Hint", "If you are having performance problems, review the Hint to see if an improvement could be made"));
                result.add(new ExplainInformationStmtRowModel(model, "  ", "was " + eRow.getOphintUsed_Formatted(), "in determining the access path", "  "));
                return result;
            }
            case 76: {
                return null;
            }
        }
        return null;
    }
}

