/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.logging;

import com.ca.mat.Activator;
import com.ca.mat.MATIgnoreStackTraceException;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.logging.EclipseFormatter;
import com.ca.mat.logging.EclipseHandler;
import com.ca.mat.logging.MATLogHandler;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.LogView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class Logging {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final Filter MAT_FILTER;
    static Map<Logger, Handler> map;
    static Logger bundleLogger;
    static EclipseFormatter formater;
    static ConcurrentHashMap<String, MATLogHandler> logHandlers;
    static ConcurrentHashMap<String, ConsoleHandler> consoleHandlers;
    static ConcurrentHashMap<String, List<LogView>> logViews;
    static ConcurrentHashMap<String, List<LogRecord>> logQueues;

    static {
        map = new WeakHashMap<Logger, Handler>();
        formater = new EclipseFormatter();
        logHandlers = new ConcurrentHashMap();
        consoleHandlers = new ConcurrentHashMap();
        logViews = new ConcurrentHashMap();
        logQueues = new ConcurrentHashMap();
        MAT_FILTER = new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getThrown() == null || !(record.getThrown() instanceof MATIgnoreStackTraceException);
            }
        };
    }

    public static void setLogging(Bundle bundle, boolean announce) {
        String id = bundle.getSymbolicName();
        bundleLogger = Logger.getLogger(id);
        EclipseHandler newHandler = new EclipseHandler(bundle);
        newHandler.setFormatter(formater);
        bundleLogger.addHandler(newHandler);
        bundleLogger.setUseParentHandlers(false);
        bundleLogger.setLevel(Level.ALL);
        if (announce) {
            Dictionary dict = bundle.getHeaders();
            String build = (String)dict.get("Bundle-Build");
            build = build == null || build.equals("--BUILD--") ? "" : String.format(" Build %s", build);
            IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();
            String level = store.getString("loglevels");
            String message = String.format("Logging for %s %s%s started", id, bundle.getVersion().toString(), build);
            ILog elog = Platform.getLog((Bundle)bundle);
            if (level.equals("INFO")) {
                Status status = new Status(1, bundle.getSymbolicName(), 0, message, null);
                elog.log((IStatus)status);
            }
        }
    }

    private static Logger getLogger(String userId) {
        Bundle rapBundle = Platform.getBundle((String)"com.ca.mat.rapfragment");
        if (rapBundle == null || rapBundle.getState() == 1) {
            return Logging.getLoggerEclipse(userId);
        }
        return Logging.getLoggerRAP(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getLoggerRAP(String userId) {
        String namespace = "com.ca.mat.rap";
        Logger log = userId == null || userId.isEmpty() ? Logger.getLogger(namespace) : Logger.getLogger(String.valueOf(namespace) + "." + userId);
        log.setLevel(Level.ALL);
        log.setUseParentHandlers(false);
        Map<Logger, Handler> map = Logging.map;
        synchronized (map) {
            if (Logging.map.get(log) == null) {
                try {
                    IPath path = Activator.plugin.getFragmentActivator().getPropertyPath();
                    String fileName = String.valueOf(path.toOSString()) + '/' + userId + ".log";
                    ConcurrentHashMap<String, StreamHandler> concurrentHashMap = logHandlers;
                    synchronized (concurrentHashMap) {
                        if (!logHandlers.contains(userId)) {
                            logHandlers.put(userId, new MATLogHandler(fileName, userId));
                        }
                    }
                    concurrentHashMap = consoleHandlers;
                    synchronized (concurrentHashMap) {
                        if (!consoleHandlers.contains(userId)) {
                            consoleHandlers.put(userId, new ConsoleHandler());
                        }
                    }
                    MATLogHandler handler = logHandlers.get(userId);
                    handler.setFormatter(formater);
                    handler.createSessionHeader();
                    log.addHandler(handler);
                    ConsoleHandler consHandler = consoleHandlers.get(userId);
                    consHandler.setFilter(MAT_FILTER);
                    try {
                        consHandler.setLevel(Level.parse(System.getProperty("com.ca.logging.level")));
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    log.addHandler(consHandler);
                    Logging.map.put(log, handler);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException iOException) {}
            }
        }
        return log;
    }

    private static Logger getLoggerEclipse(String userId) {
        return bundleLogger;
    }

    public static Logger getLogger(Display display) {
        ServerProxy proxy;
        String user = "";
        if (display != null && !display.isDisposed() && (proxy = Singletons.getServerProxy(display)).getConnectedServer() != null && proxy.getConnectedServer().getUser() != null) {
            user = proxy.getConnectedServer().getUser();
        }
        return Logging.getLogger(user);
    }

    public static List<LogView> getLogViews(String userId) {
        if (userId == null) {
            userId = "";
        }
        return logViews.get(userId);
    }

    public static void addLogView(LogView logView, String userId) {
        if (userId == null) {
            userId = "";
        }
        logViews.putIfAbsent(userId, new ArrayList());
        logViews.get(userId).add(logView);
        logQueues.putIfAbsent(userId, new ArrayList());
        ArrayList<LogRecord> queuedRecords = new ArrayList<LogRecord>();
        queuedRecords.addAll((Collection)logQueues.get(userId));
        logView.displayLogRecords(queuedRecords);
    }

    public static void removeLogView(LogView logView, String userId) {
        if (userId == null) {
            userId = "";
        }
        logViews.get(userId).remove((Object)logView);
        if (logViews.get(userId).isEmpty()) {
            logViews.remove(userId);
            logQueues.remove(userId);
            logHandlers.remove(userId);
            consoleHandlers.remove(userId);
        }
    }

    public static void displayLogRecord(String userId, LogRecord record) {
        if (userId == null) {
            userId = "";
        }
        logViews.putIfAbsent(userId, new ArrayList());
        for (LogView view : logViews.get(userId)) {
            view.displayLogRecord(record);
        }
        if (userId != "") {
            logQueues.putIfAbsent(userId, new ArrayList());
            logQueues.get(userId).add(record);
        }
    }
}

