/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.utils;

import com.ca.mat.MATException;
import com.ca.mat.logging.Logging;
import com.ca.mat.utils.Numbers;
import com.ca.mat.utils.TTHexUtilException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;

public class HexUtil {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final int _2000 = 2000;
    private static final int _10000 = 10000;
    private static final int _100 = 100;
    private static final int _1900 = 1900;
    private static final int _10 = 10;
    private static final int _1000 = 1000;
    private static final int _100000 = 100000;
    private static final boolean parse3270DS;
    public static final String LF;
    private static final DateFormat df;
    private static final DateFormat dflocaltime;
    public static final String EMPTY = "";
    public static final char PLAINDOT = '.';
    public static final char FANCYDOT = '\u25aa';
    static final boolean zOS;
    public static char dot;
    private static String spaces;
    private static final Pattern hexPattern;
    private static final String matchescharacters;
    private static final String matchesallcharacters;
    private static final Pattern patternAllCharacters;
    private static final StringBuilder nulls;
    private static final String timeformat = "%s:%s";

    static {
        char[] displaycharacters;
        parse3270DS = Boolean.getBoolean("com.ca.testingtools.common.HexUtil.parse3270DS");
        LF = System.getProperty("line.separator");
        df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        dflocaltime = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
        zOS = "z/OS".equalsIgnoreCase(System.getProperty("os.name"));
        dot = (char)(zOS ? 46 : 9642);
        spaces = EMPTY;
        hexPattern = Pattern.compile("[0-9A-Fa-f]+");
        StringBuilder string = new StringBuilder(1152);
        byte[] ebcdiccharacters = new byte[192];
        int i = 0;
        while (i < 192) {
            ebcdiccharacters[i] = (byte)(i + 64);
            ++i;
        }
        try {
            String tempstring = new String(ebcdiccharacters, "IBM1047");
            displaycharacters = tempstring.toCharArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            displaycharacters = new char[]{};
        }
        i = 0;
        while (i < displaycharacters.length) {
            string.append(String.format("\\u%04X", displaycharacters[i]));
            ++i;
        }
        String displayString = string.toString();
        matchescharacters = String.format("[%s]+", displayString);
        matchesallcharacters = String.format("[%s%c]+", displayString, Character.valueOf(dot));
        patternAllCharacters = Pattern.compile(matchescharacters);
        nulls = new StringBuilder(8);
    }

    private HexUtil() {
    }

    public static String addTime(String string) {
        if (string != null) {
            return String.format(timeformat, dflocaltime.format(new Date()), string);
        }
        return dflocaltime.format(new Date());
    }

    public static String decryptPassword(String userid, String password) {
        try {
            BigInteger clearpassword = new BigInteger(password, 16);
            BigInteger user = new BigInteger(userid.getBytes("IBM1047"));
            clearpassword = clearpassword.subtract(user);
            return new String(clearpassword.toByteArray(), "IBM1047");
        }
        catch (NumberFormatException numberFormatException) {
            return password;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return password;
        }
    }

    public static String encryptPassword(String userid, String clearpassword) {
        try {
            BigInteger password = new BigInteger(clearpassword.getBytes("IBM1047"));
            BigInteger user = new BigInteger(userid.getBytes("IBM1047"));
            password = password.add(user);
            return password.toString(16);
        }
        catch (Exception exception) {
            return clearpassword;
        }
    }

    public static void FloatingtoBytes(String number, byte[] bytes) throws TTHexUtilException {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        try {
            if (bytes.length > 4) {
                Double value = new Double(number);
                buf.putDouble(value);
            } else {
                Float value = new Float(number);
                buf.putFloat(value.floatValue());
            }
        }
        catch (Exception e) {
            throw new TTHexUtilException("Invalid floating point conversion", e.getCause());
        }
    }

    public static String getErrorText(Throwable e) {
        return HexUtil.getErrorText(e, false);
    }

    public static String getErrorText(Throwable e, boolean addPrefix) {
        if (e == null) {
            return "Unknown Event";
        }
        String text = e.getMessage();
        if (text == null || text.length() == 0) {
            Throwable cause = e.getCause();
            if (cause != null) {
                text = cause.getMessage();
            }
            if (!(text != null && text.length() != 0 || addPrefix)) {
                text = e.getClass().getSimpleName();
            }
        }
        if (text == null || text.length() == 0) {
            return e.getClass().getSimpleName();
        }
        if (addPrefix) {
            text = String.valueOf(e.getClass().getSimpleName()) + ":" + text;
        }
        return text;
    }

    public static byte[] getPasswordKey(String userid, String clearpassword) {
        try {
            String fullsize = HexUtil.spaceFill(clearpassword, 8);
            BigInteger password = new BigInteger(fullsize.getBytes("IBM1047"));
            fullsize = HexUtil.spaceFill(userid, 8);
            BigInteger user = new BigInteger(fullsize.getBytes("IBM1047"));
            password = password.add(user);
            byte[] bytes = password.toByteArray();
            if (bytes.length > 8) {
                throw new MATException("Key too big for target");
            }
            if (bytes.length < 8) {
                byte[] newbytes = new byte[8];
                int ix = bytes.length;
                System.arraycopy(bytes, 0, newbytes, 8 - ix, ix);
                bytes = newbytes;
            }
            return bytes;
        }
        catch (Exception exception) {
            return new byte[8];
        }
    }

    public static byte[] HextoBytes(String string) {
        int length;
        if (string.indexOf(95) != -1) {
            string = string.replaceAll("_", EMPTY);
        }
        if ((length = (string = HexUtil.stripSpaces(string)).length()) % 2 != 0) {
            string = "0" + string;
            ++length;
        }
        if (hexPattern.matcher(string).matches()) {
            byte[] bytes = new byte[length / 2];
            int j = 0;
            int i = 0;
            while (i < length) {
                bytes[j] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
                ++j;
                i += 2;
            }
            return bytes;
        }
        return null;
    }

    public static boolean HextoBytes(String string, byte[] bytes) {
        boolean result = false;
        int length = (string = HexUtil.stripSpaces(string.replace('_', ' '))).length();
        if (length / 2 != bytes.length) {
            return result;
        }
        if (string.matches("[0-9A-Fa-f]+")) {
            int j = 0;
            int i = 0;
            while (i < length) {
                byte item = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
                if (item != bytes[j]) {
                    result = true;
                    bytes[j] = item;
                }
                ++j;
                i += 2;
            }
        }
        return result;
    }

    public static String leftTrim(String string) {
        if (string == null) {
            return EMPTY;
        }
        int i = 0;
        while (i <= string.length() && (string.charAt(i) == ' ' || string.charAt(i) == '\u0000')) {
            ++i;
        }
        return string.substring(i, string.length());
    }

    public static String null2hex(int length) {
        int ix = length * 2;
        while (nulls.length() < ix) {
            nulls.append("00");
        }
        return nulls.substring(0, ix);
    }

    public static void NumbertoByte(String number, byte[] bytes) throws TTHexUtilException {
        try {
            BigInteger value = new BigInteger(number);
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            switch (bytes.length) {
                case 1: {
                    buf.put(value.byteValue());
                    break;
                }
                case 2: {
                    buf.putShort(value.shortValue());
                    break;
                }
                case 4: {
                    buf.putInt(value.intValue());
                    break;
                }
                case 8: {
                    buf.putLong(value.longValue());
                    break;
                }
                default: {
                    byte[] result = value.toByteArray();
                    int i = 0;
                    i = 0;
                    while (i < result.length && i < bytes.length) {
                        bytes[i] = result[i];
                        ++i;
                    }
                    while (i < bytes.length) {
                        bytes[i++] = 0;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TTHexUtilException("Invalid conversion of number", e.getCause());
        }
    }

    public static String rightTrim(String string) {
        if (string == null) {
            return EMPTY;
        }
        int i = string.length() - 1;
        while (i >= 0 && (string.charAt(i) == ' ' || string.charAt(i) == '\u0000')) {
            --i;
        }
        return ++i == string.length() ? string : string.substring(0, i);
    }

    public static byte[] sizeBytes(byte[] bytes, int size) {
        if (bytes == null) {
            return new byte[size];
        }
        if (bytes.length == size) {
            return bytes;
        }
        byte[] result = new byte[size];
        if (bytes.length == 0) {
            return result;
        }
        if (bytes.length < size) {
            System.arraycopy(bytes, 0, result, size - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - size, result, 0, size);
        }
        return result;
    }

    public static String spaceFill(String string, int length) {
        int strlength;
        if (string == null) {
            string = EMPTY;
        }
        if ((strlength = string.length()) >= length) {
            return string;
        }
        if (spaces.length() < length) {
            String formatstr = String.format("%%-%ds", length);
            spaces = String.format(formatstr, spaces);
        }
        String result = String.valueOf(string) + spaces.substring(0, length - strlength);
        return result;
    }

    public static String Squeeze(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        return HexUtil.rightTrim(string.replaceAll("[ \\t]+", " "));
    }

    public static boolean StringtoBytes(String string, byte[] bytes) throws TTHexUtilException {
        boolean changed = false;
        try {
            byte[] ebcdic = string.getBytes("IBM1047");
            int i = 0;
            while (i < ebcdic.length && i < bytes.length) {
                boolean chkdot;
                boolean bl = chkdot = string.charAt(i) == dot;
                if (chkdot) {
                    ebcdic[i] = bytes[i];
                } else if (ebcdic[i] != bytes[i]) {
                    changed = true;
                    bytes[i] = ebcdic[i];
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new TTHexUtilException(e);
        }
        return changed;
    }

    public static String stripSpaces(String string) {
        if (string == null) {
            return EMPTY;
        }
        if (string.indexOf(32) == -1) {
            return string;
        }
        return string.replaceAll(" ", EMPTY);
    }

    public static Calendar TimeStamp(int date, int time) {
        int year;
        if (date == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int thisyear = calendar.get(1) - 2000;
        year += (year = date / 1000) > thisyear && year > 60 ? 1900 : 2000;
        int day = date % 1000;
        int hour = time / 10000;
        int minute = time % 10000 / 100;
        int sec = time % 100;
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, sec);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar TimeStamp(byte[] date, byte[] time) {
        long clock;
        long years;
        try {
            years = Numbers.unpack(date).longValue();
            clock = Numbers.unpack(time).longValue();
        }
        catch (Exception exception) {
            return null;
        }
        if (date.length != 4) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int century = (int)(years / 100000L);
        int year = (int)(years % 100000L);
        int day = year % 1000;
        int thisyear = 1900 + century * 100 + (year /= 1000);
        int hour = (int)(clock / 100000L);
        int minute = (int)(clock % 100000L / 1000L);
        int sec = (int)(clock % 1000L / 10L);
        int milli = (int)(clock % 10L * 100L);
        calendar.clear();
        calendar.set(1, thisyear);
        calendar.set(6, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, sec);
        calendar.set(14, milli);
        return calendar;
    }

    public static Calendar TimeStamp(String timestr) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        try {
            time.setTime(df.parse(timestr));
        }
        catch (ParseException parseException) {
            time = null;
        }
        return time;
    }

    public static String TimeStampString(Calendar timestamp) {
        return timestamp == null ? "Unknown Date" : df.format(timestamp.getTime());
    }

    public static String TimeStampString(int date, int time) {
        return HexUtil.TimeStampString(HexUtil.TimeStamp(date, time));
    }

    public static String toFloating(byte[] bytes) throws TTHexUtilException {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        if (bytes.length == 8) {
            return Double.toString(buf.getDouble());
        }
        if (bytes.length == 4) {
            return Float.toString(buf.getFloat());
        }
        throw new TTHexUtilException("<<No Data>>");
    }

    public static String toHex(byte value) {
        return HexUtil.toHex(new Byte(value), 1);
    }

    public static String toHex(byte[] bytes) {
        return HexUtil.toHex(bytes, 4, ' ');
    }

    public static String toHex(byte[] bytes, int span) {
        return HexUtil.toHex(bytes, span, ' ');
    }

    public static String toHex(byte[] bytes, int span, char delim) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY;
        }
        if (span == 0) {
            span = bytes.length;
        }
        Formatter fmt = new Formatter();
        int offset = 0;
        int size = bytes.length;
        if (span < size) {
            offset = 0;
            while (offset < size) {
                HexUtil.formatHex(fmt, bytes, offset, span);
                if ((offset += span) >= size) continue;
                try {
                    fmt.out().append(delim);
                }
                catch (IOException iOException) {}
            }
        }
        HexUtil.formatHex(fmt, bytes, offset, span);
        return fmt.toString();
    }

    public static String toHex(int value) {
        return HexUtil.toHex(new Integer(value), 4);
    }

    public static String toHex(long value) {
        return HexUtil.toHex(new Long(value), 8);
    }

    public static String toHex(Number value, int length) {
        String formatstr = String.format("%%0%dX", length * 2);
        return String.format(formatstr, value);
    }

    public static String toHex(short value) {
        return HexUtil.toHex(new Short(value), 2);
    }

    public static String toHexDump(byte[] bytes, String title) {
        return HexUtil.toHexDump(bytes, title, 32, 0);
    }

    public static String toHexDump(byte[] bytes, String title, int span, int maxmsg) {
        StringBuilder chars;
        int oneline;
        int header = title == null ? 0 : title.length() + LF.length();
        int length = bytes.length;
        boolean truncated = false;
        span = (span + 3) / 4 * 4;
        int maxlines = 0;
        if (maxmsg > 0 && (maxlines = (oneline = 8 + span + span * 9 + LF.length()) > maxmsg ? 1 : maxmsg / oneline) * span < bytes.length) {
            truncated = true;
            bytes = Arrays.copyOfRange(bytes, 0, span * maxlines);
            length = bytes.length;
        }
        String format = String.format("+%%04X %%-%ds|%%-%ds|", span / 4 * 9, span);
        try {
            chars = new StringBuilder(new String(bytes, 0, length, "IBM1047"));
            int i = 0;
            while (i < chars.length()) {
                char charAt = chars.charAt(i);
                if (charAt < ' ' || charAt > '~') {
                    chars.setCharAt(i, '.');
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "Bad EBCDIC Translation";
        }
        StringBuilder string = new StringBuilder(header + (60 + LF.length()) * (bytes.length / span + 1));
        if (header > LF.length()) {
            string.append(title);
            string.append(LF);
        }
        int index = 0;
        while (index < length) {
            int remaining = length - index;
            int stride = Math.min(span, remaining);
            byte[] set = new byte[stride];
            int offset = index;
            int ix = 0;
            while (ix < stride) {
                set[ix] = bytes[offset++];
                ++ix;
            }
            String hex = HexUtil.toHex(set, 4, ' ');
            String line = String.format(format, index, hex, chars.substring(index, index + stride));
            string.append(line);
            string.append(LF);
            index += span;
        }
        if (truncated) {
            string.append(String.format("Text truncated to %d characters%s", maxmsg, LF));
        }
        if (string.length() >= LF.length()) {
            string.setLength(string.length() - LF.length());
        }
        return string.toString();
    }

    public static String toRegisterHex(byte[] register) {
        register = HexUtil.sizeBytes(register, 8);
        return HexUtil.toHex(register, 4, '_');
    }

    public static String toSigned(byte[] bytes) throws TTHexUtilException {
        try {
            BigInteger value = new BigInteger(bytes);
            return value.toString();
        }
        catch (NumberFormatException numberFormatException) {
            throw new TTHexUtilException("Invalid conversion to signed integer");
        }
    }

    public static String toXMLString(byte[] bytes) {
        if (parse3270DS) {
            return HexUtil.toXMLString2(bytes);
        }
        int length = bytes.length - 1;
        while (length >= 0 && (bytes[length] == 64 || bytes[length] == 0)) {
            --length;
        }
        ++length;
        int ix = 0;
        while (ix < length) {
            if (bytes[ix] == 0) {
                bytes[ix] = 64;
            }
            ++ix;
        }
        try {
            return new String(bytes, 0, length, "IBM1047");
        }
        catch (UnsupportedEncodingException e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Problem while converting string to xml: ", e);
            return EMPTY;
        }
    }

    public static String toXMLString2(byte[] bytes) {
        byte[] newBytes = new byte[bytes.length];
        Arrays.fill(newBytes, (byte)64);
        int ix = 0;
        int newix = 0;
        while (ix < bytes.length) {
            byte item = bytes[ix];
            if (item > 63) {
                newBytes[newix++] = item;
            } else if (item == 0) {
                ++newix;
            } else {
                switch (item) {
                    case 29: {
                        ++ix;
                        ++newix;
                        break;
                    }
                    case 41: {
                        ++newix;
                        byte count = bytes[++ix];
                        ix += count * 2;
                        break;
                    }
                    case 17: {
                        ix += 2;
                        ++newix;
                        break;
                    }
                    case 40: {
                        ix += 2;
                        ++newix;
                        break;
                    }
                    case 44: {
                        ++newix;
                        byte count = bytes[++ix];
                        ix += count * 2;
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 60: {
                        ix += 3;
                        break;
                    }
                    case 18: {
                        ix += 2;
                        break;
                    }
                    case 8: {
                        newBytes[newix++] = item;
                        break;
                    }
                    default: {
                        newBytes[newix++] = bytes[++ix];
                    }
                }
            }
            ++ix;
        }
        int length = newix + 1;
        while (length >= 0 && newBytes[length] == 64) {
            --length;
        }
        ++length;
        try {
            return new String(newBytes, 0, length, "IBM1047");
        }
        catch (UnsupportedEncodingException e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Problem while converting string to xml: ", e);
            return EMPTY;
        }
    }

    public static String toString(byte[] bytes, boolean fill) {
        return HexUtil.toString(bytes, fill, true);
    }

    public static int toMonthNumber(String month) {
        try {
            MonthEnum monthEnum = MonthEnum.valueOf(month);
            return monthEnum.ordinal();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String toString(byte[] bytes, boolean fill, boolean displayonly) {
        try {
            int length = bytes.length;
            if (!fill) {
                --length;
                while (length >= 0 && bytes[length] == 64) {
                    --length;
                }
                ++length;
            }
            String ascii = new String(bytes, 0, length, "IBM1047");
            if (displayonly) {
                boolean hasDots;
                boolean bl = hasDots = !patternAllCharacters.matcher(ascii).matches();
                if (hasDots) {
                    StringBuilder array = new StringBuilder(ascii);
                    int i = 0;
                    while (i < array.length()) {
                        if (bytes[i] > -1 && bytes[i] < 64) {
                            array.setCharAt(i, dot);
                        }
                        ++i;
                    }
                    return array.toString();
                }
            }
            return ascii;
        }
        catch (UnsupportedEncodingException e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Problem while converting bytes to String: ", e);
            return HexUtil.getErrorText(e);
        }
    }

    public static String toDisplay(String text) {
        boolean hasDots;
        if (text == null) {
            return EMPTY;
        }
        if (text.isEmpty()) {
            return text;
        }
        boolean bl = hasDots = !patternAllCharacters.matcher(text).matches();
        if (hasDots) {
            StringBuilder array = new StringBuilder(text);
            try {
                byte[] bytes = text.getBytes("IBM1047");
                int i = 0;
                while (i < array.length()) {
                    if (bytes[i] > -1 && bytes[i] < 64) {
                        array.setCharAt(i, bytes[i] == 0 ? (char)' ' : (char)dot);
                    }
                    ++i;
                }
                return array.toString();
            }
            catch (UnsupportedEncodingException e) {
                Logger log = Logging.getLogger(Display.getCurrent());
                log.log(Level.FINE, "Problem while converting string to MF conforming string: ", e);
            }
        }
        return text;
    }

    public static String toUnSigned(byte[] bytes) throws TTHexUtilException {
        try {
            BigInteger value = new BigInteger(1, bytes);
            return value.toString();
        }
        catch (NumberFormatException numberFormatException) {
            throw new TTHexUtilException("Invalid conversion to unsigned integer");
        }
    }

    private static void formatHex(Formatter fmt, byte[] bytes, int offset, int length) {
        int end = offset + length;
        if (end > bytes.length) {
            end = bytes.length;
        }
        int i = offset;
        while (i < end) {
            fmt.format("%0$02X", bytes[i]);
            ++i;
        }
    }

    public static String getMatchesCharacters() {
        return matchescharacters;
    }

    public static String getMatchesAllCharacters() {
        return matchesallcharacters;
    }

    public static char setDot(boolean fancy) {
        dot = (char)(fancy ? 9642 : 46);
        return dot;
    }

    public static char getDot() {
        return dot;
    }

    private static enum MonthEnum {
        JAN,
        FEB,
        MAR,
        APR,
        MAY,
        JUN,
        JUL,
        AUG,
        SEP,
        OCT,
        NOV,
        DEC;

    }
}

