/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.common.table;

import com.ca.mat.Activator;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableFilter;
import com.ca.mat.common.table.MATTableViewerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MATTableFilterWidget
extends Composite
implements SelectionListener,
ModifyListener,
FocusListener,
MATTableViewerListener,
KeyListener,
MouseListener {
    private IMATTableViewer tableViewer;
    private Composite parent;
    private Text inputField;
    private org.eclipse.swt.widgets.List columnListDropDown;
    private List<Integer> listOfValuableColumns;
    private Timer timerInput = null;
    private Timer timerDropDown = null;
    private Button clearAllButton;
    private Shell columnListShell;
    private MATTableFilter quickFilter;
    private boolean dropDownColumnListUpdateNeeded = false;
    private Map<Integer, Label[]> filterLines = new HashMap<Integer, Label[]>();
    private Map<Integer, Integer> columnListToViewerMapping = new HashMap<Integer, Integer>();
    private static final String FILTER_INITIAL_TEXT = "Quick filter text";
    private static final int COLUMN_LIST_DROPDOWN_MAX_LINES_COUNT = 5;
    private static final int TIMER_DROPDOWN = 4000;
    private static final int TIMER_QUICK_FILTER_SEARCH = 1000;
    private static final String DROPDOWN_TEXT = "Display the column list";
    private static final String FOLD_DROPDOWN_TEXT = "Hide the column list";
    final int INPUT_FIELD_LENGTH_IN_CHARS = 25;
    private ToolItem clearTextButton;
    private ToolItem dropDownButton;
    private boolean isDropdownShellOpen = false;
    private int lastKeyPressed;
    private int lastColumnDropDownListSelection;

    public MATTableFilterWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        GridLayout compositeGridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        this.parent = parent;
        Composite inputFieldComposite = new Composite((Composite)this, 2048);
        inputFieldComposite.setBackground(this.getDisplay().getSystemColor(25));
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        compositeGridLayout.horizontalSpacing = 0;
        compositeGridLayout.verticalSpacing = 0;
        inputFieldComposite.setLayout((Layout)compositeGridLayout);
        this.inputField = new Text(inputFieldComposite, 0x800000);
        GridData gridDataInputField = new GridData();
        gridDataInputField.grabExcessHorizontalSpace = true;
        gridDataInputField.verticalAlignment = 0x1000000;
        gridDataInputField.horizontalAlignment = 1;
        this.inputField.setTextLimit(25);
        this.inputField.setToolTipText("Quick filter input field");
        this.inputField.setFocus();
        ToolBar filterToolBar = new ToolBar(inputFieldComposite, parent.getStyle());
        this.clearTextButton = new ToolItem(filterToolBar, 0x800000);
        this.clearTextButton.addSelectionListener((SelectionListener)this);
        this.clearTextButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.clear"));
        this.disableClearTextButton();
        this.dropDownButton = new ToolItem(filterToolBar, 0x800000);
        this.dropDownButton.addSelectionListener((SelectionListener)this);
        this.setDropDownButton("DropDown");
        this.dropDownButton.setEnabled(false);
        GC gc = new GC((Drawable)this.inputField);
        FontMetrics fm = gc.getFontMetrics();
        int inputFieldCharWidth = fm.getAverageCharWidth();
        gridDataInputField.minimumWidth = 25 * inputFieldCharWidth;
        this.inputField.setLayoutData((Object)gridDataInputField);
        this.inputField.addModifyListener((ModifyListener)this);
        this.inputField.addFocusListener((FocusListener)this);
        this.inputField.addKeyListener((KeyListener)this);
        GridData gridDataClearButton = new GridData(1, 0x1000000, true, false);
        this.clearAllButton = new Button((Composite)this, 8);
        this.clearAllButton.setLayoutData((Object)gridDataClearButton);
        this.clearAllButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.serverdisconnected"));
        this.clearAllButton.setText("All");
        this.clearAllButton.setToolTipText("Clear all filters");
        this.clearAllButton.setEnabled(false);
        this.clearAllButton.addSelectionListener((SelectionListener)this);
    }

    private void disableClearTextButton() {
        this.clearTextButton.setEnabled(false);
        this.clearTextButton.setImage(null);
        this.clearTextButton.setToolTipText("");
        this.clearTextButton.getParent().layout();
        this.clearTextButton.getParent().getParent().layout();
    }

    private void enableClearTextButton() {
        this.clearTextButton.setEnabled(true);
        this.clearTextButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.clear"));
        this.clearTextButton.setToolTipText("Clear the input field");
        this.clearTextButton.getParent().layout();
        this.clearTextButton.getParent().getParent().layout();
    }

    private void setDropDownButton(String dropDownState) {
        if (dropDownState == "DropDown") {
            this.dropDownButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.dropDown"));
            this.dropDownButton.setToolTipText(DROPDOWN_TEXT);
        } else {
            this.dropDownButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.fold"));
            this.dropDownButton.setToolTipText(FOLD_DROPDOWN_TEXT);
        }
    }

    public void setViewer(IMATTableViewer tableViewer) {
        this.tableViewer = tableViewer;
        tableViewer.addViewerListener(this);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() instanceof Button) {
            if (event.getSource() == this.clearAllButton) {
                this.clearAllFilters();
                this.clearAllButton.setEnabled(false);
                this.resetInputFields();
            }
        } else if (event.getSource() instanceof ToolItem) {
            if (event.getSource() == this.clearTextButton) {
                this.inputField.setText("");
                this.setDropDownButton("DropDown");
                this.dropDownButton.setEnabled(false);
                this.disableClearTextButton();
            } else if (event.getSource() == this.dropDownButton) {
                if (!this.isDropdownShellOpen) {
                    this.dropDownListOfColumns();
                } else {
                    this.hideDropDownListOfColumns();
                }
            }
        }
    }

    public void columnListItemSelectedHandler() {
        ArrayList<Integer> specificColumns = new ArrayList<Integer>();
        specificColumns.add(this.columnListToViewerMapping.get(this.columnListDropDown.getSelectionIndex()));
        if (this.timerInput != null) {
            this.timerInput.cancel();
            this.timerInput = null;
        }
        if (!this.inputField.getText().isEmpty()) {
            this.tableViewer.addColumnFilter(specificColumns, this.inputField.getText(), false, false);
            if (this.quickFilter != null) {
                this.tableViewer.removeFilter(this.quickFilter);
            }
        }
        this.hideDropDownListOfColumns();
        this.resetInputFields();
        this.hideDropDownListOfColumns();
    }

    public void resetInputFields() {
        this.resetInputField();
        this.layout();
        this.parent.layout();
    }

    public void clearAllFilters() {
        this.tableViewer.removeAllFilters();
    }

    public void addFilterLine(final MATTableFilter filter) {
        if (filter.getFilteredColumns().size() == 1) {
            GridData filterLabelData = new GridData();
            final Label filterLabel = new Label((Composite)this, 0);
            filterLabel.setLayoutData((Object)filterLabelData);
            int columnIndex = filter.getFilteredColumns().get(0);
            String columnName = this.tableViewer.getColumnName(columnIndex);
            String text = String.valueOf(columnName) + ": " + filter.getText();
            filterLabel.setText(text);
            filterLabel.setToolTipText(String.valueOf(columnName) + " column filter");
            GridData gridDataClearLineLabel = new GridData(1, 0x1000000, true, false);
            final Label clearLineLabel = new Label((Composite)this, 0);
            clearLineLabel.setLayoutData((Object)gridDataClearLineLabel);
            Image clearLabelImage = Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.serverdisconnected");
            clearLineLabel.setImage(clearLabelImage);
            clearLineLabel.setToolTipText("Clear " + columnName + " column filter");
            clearLineLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    filterLabel.dispose();
                    clearLineLabel.dispose();
                    MATTableFilterWidget.this.layout();
                    MATTableFilterWidget.this.parent.layout();
                    Job job = new Job("Remove filter"){

                        protected IStatus run(IProgressMonitor monitor) {
                            MATTableFilterWidget.this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MATTableFilterWidget.this.tableViewer.removeFilter(filter);
                                    MATTableFilterWidget.this.filterLines.remove(filter.getFilteredColumns().get(0));
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            });
            Label[] filterLine = new Label[]{filterLabel, clearLineLabel};
            this.filterLines.put(columnIndex, filterLine);
            if (!this.clearAllButton.isEnabled()) {
                this.clearAllButton.setEnabled(true);
            }
            this.layout();
            this.parent.layout();
        }
    }

    public void removeFilterLine(MATTableFilter filter) {
        int filterColumn;
        if (filter.getFilteredColumns().size() == 1 && this.filterLines.containsKey(filterColumn = filter.getFilteredColumns().get(0).intValue())) {
            Label[] labels;
            Label[] labelArray = labels = this.filterLines.get(filterColumn);
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                Label label = labelArray[n2];
                label.dispose();
                ++n2;
            }
            this.filterLines.remove(filterColumn);
            if (this.filterLines.size() == 0) {
                this.clearAllButton.setEnabled(false);
            }
            this.layout();
            this.parent.layout();
        }
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget instanceof Text && event.getSource() == this.inputField && this.isVisible()) {
            final String originalInputText = this.inputField.getText();
            if (!originalInputText.equals(FILTER_INITIAL_TEXT)) {
                this.inputField.setForeground(this.parent.getDisplay().getSystemColor(2));
                if (!originalInputText.isEmpty()) {
                    MATTableFilter dummyFilter = new MATTableFilter(this.tableViewer, this.tableViewer.getVisibleSortedColumnList(), originalInputText, false, true);
                    dummyFilter.isFilterValidForTheColumnList();
                    this.dropDownColumnListUpdateNeeded = !dummyFilter.getFilteredColumns().equals(this.listOfValuableColumns);
                    this.listOfValuableColumns = dummyFilter.getFilteredColumns();
                    if (this.columnListShell == null) {
                        this.dropDownListOfColumns();
                    } else {
                        this.refreshListOfColumns();
                    }
                } else if (this.columnListShell != null) {
                    this.disableClearTextButton();
                    this.hideDropDownListOfColumns();
                    this.listOfValuableColumns = null;
                    this.dropDownButton.setEnabled(false);
                }
                if (this.timerInput != null) {
                    this.timerInput.cancel();
                    this.timerInput = null;
                }
                this.timerInput = new Timer();
                this.timerInput.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        MATTableFilterWidget.this.parent.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MATTableFilterWidget.this.quickFilter = MATTableFilterWidget.this.tableViewer.addColumnFilter(MATTableFilterWidget.this.tableViewer.getVisibleSortedColumnList(), originalInputText, false, true);
                            }
                        });
                        if (MATTableFilterWidget.this.timerInput != null) {
                            MATTableFilterWidget.this.timerInput.cancel();
                            MATTableFilterWidget.this.timerInput = null;
                        }
                    }
                }, 1000L);
                if (this.timerDropDown != null) {
                    this.timerDropDown.cancel();
                    this.timerDropDown = null;
                }
                this.timerDropDown = new Timer();
                this.timerDropDown.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        MATTableFilterWidget.this.parent.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MATTableFilterWidget.this.hideDropDownListOfColumns();
                            }
                        });
                        if (MATTableFilterWidget.this.timerInput != null) {
                            MATTableFilterWidget.this.timerInput.cancel();
                            MATTableFilterWidget.this.timerInput = null;
                        }
                    }
                }, 4000L);
            } else if (this.columnListShell != null) {
                this.hideDropDownListOfColumns();
            }
        }
    }

    void dropDownListOfColumns() {
        Point inputFieldTopLeftCorner;
        List<Integer> list;
        this.columnListShell = new Shell(this.parent.getShell(), 0);
        this.columnListShell.setLayout((Layout)new FillLayout());
        this.columnListDropDown = new org.eclipse.swt.widgets.List((Composite)this.columnListShell, 2564);
        if (this.listOfValuableColumns != null) {
            if (this.listOfValuableColumns.size() != 0) {
                list = this.listOfValuableColumns;
            } else {
                list = this.getNoValidColumnsInfoList();
                this.columnListDropDown.setEnabled(false);
            }
        } else {
            list = this.tableViewer.getVisibleSortedColumnList();
        }
        this.fillInTheColumnListDropDownAndMapIt(list);
        int columnListShellHeight = this.tableViewer.getVisibleSortedColumnList().size() < 5 ? this.columnListDropDown.getItemHeight() * this.tableViewer.getVisibleSortedColumnList().size() : this.columnListDropDown.getItemHeight() * 5;
        this.columnListDropDown.setSize(this.inputField.getSize().x, columnListShellHeight);
        this.columnListDropDown.addFocusListener((FocusListener)this);
        this.columnListDropDown.addSelectionListener((SelectionListener)this);
        this.columnListDropDown.addKeyListener((KeyListener)this);
        this.columnListDropDown.addMouseListener((MouseListener)this);
        Point columnListShellTopLeftCorner = inputFieldTopLeftCorner = this.parent.getDisplay().map((Control)this.inputField.getParent(), null, this.inputField.getLocation().x, this.inputField.getLocation().y);
        columnListShellTopLeftCorner.y += this.inputField.getSize().y;
        this.columnListShell.setLocation(columnListShellTopLeftCorner.x, columnListShellTopLeftCorner.y);
        this.columnListShell.pack();
        this.columnListShell.open();
        this.inputField.setFocus();
        this.setDropDownButton("Fold");
        this.isDropdownShellOpen = true;
        if (!this.inputField.getText().isEmpty()) {
            this.enableClearTextButton();
            this.clearTextButton.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.clear"));
        }
        if (!this.dropDownButton.isEnabled()) {
            this.dropDownButton.setEnabled(true);
        }
    }

    public void refreshListOfColumns() {
        if (this.columnListDropDown != null && !this.columnListDropDown.isDisposed()) {
            this.columnListDropDown.setEnabled(true);
            if (this.dropDownColumnListUpdateNeeded) {
                List<Integer> list;
                this.columnListDropDown.removeAll();
                if (this.listOfValuableColumns != null) {
                    if (this.listOfValuableColumns.size() != 0) {
                        list = this.listOfValuableColumns;
                    } else {
                        list = this.getNoValidColumnsInfoList();
                        this.columnListDropDown.setEnabled(false);
                    }
                } else {
                    list = this.tableViewer.getVisibleSortedColumnList();
                }
                this.fillInTheColumnListDropDownAndMapIt(list);
                this.dropDownColumnListUpdateNeeded = false;
                this.columnListShell.pack();
                this.columnListShell.layout();
            } else {
                this.addInputContentToTheColumnListDropDown();
            }
        }
    }

    public void fillInTheColumnListDropDownAndMapIt(List<Integer> list) {
        int i = 0;
        while (i < list.size()) {
            try {
                String columnName = this.tableViewer.getColumnName(list.get(i));
                this.columnListDropDown.add(String.valueOf(columnName) + ": " + this.inputField.getText());
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            ++i;
        }
        this.columnListToViewerMapping.clear();
        i = 0;
        while (i < list.size()) {
            this.columnListToViewerMapping.put(i, list.get(i));
            ++i;
        }
    }

    public void addInputContentToTheColumnListDropDown() {
        int i = 0;
        while (i < this.columnListDropDown.getItems().length) {
            String columnName = this.tableViewer.getColumnName(this.columnListToViewerMapping.get(i));
            this.columnListDropDown.setItem(i, String.valueOf(columnName) + ": " + this.inputField.getText());
            ++i;
        }
    }

    public void focusGained(FocusEvent event) {
        if (event.widget instanceof Text && event.getSource() == this.inputField && this.inputField.getText().equals(FILTER_INITIAL_TEXT)) {
            this.inputField.setForeground(this.parent.getDisplay().getSystemColor(2));
            this.inputField.setText("");
        }
    }

    public void focusLost(FocusEvent event) {
        if (event.widget instanceof Text && event.getSource() == this.inputField && this.inputField.getText().isEmpty()) {
            this.resetInputField();
            if (this.columnListShell != null) {
                this.hideDropDownListOfColumns();
            }
        }
    }

    public List<Integer> getNoValidColumnsInfoList() {
        ArrayList<Integer> infoList = new ArrayList<Integer>();
        this.columnListDropDown.add("No valid columns for the input");
        return infoList;
    }

    public void changeColumnDropDownListAppearanceToInfoMessage() {
        this.columnListDropDown.setForeground(this.parent.getDisplay().getSystemColor(2));
        FontData fontData = this.columnListDropDown.getFont().getFontData()[0];
        Font font = new Font((Device)this.parent.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        this.columnListDropDown.setFont(font);
        this.columnListDropDown.setEnabled(false);
    }

    public void resetInputField() {
        this.inputField.setForeground(this.parent.getDisplay().getSystemColor(15));
        this.inputField.setText(FILTER_INITIAL_TEXT);
        this.tableViewer.setFocus();
        this.setDropDownButton("DropDown");
        this.dropDownButton.setEnabled(false);
        this.disableClearTextButton();
    }

    private void hideDropDownListOfColumns() {
        if (this.columnListDropDown != null && !this.columnListDropDown.isDisposed()) {
            this.columnListDropDown.dispose();
            this.columnListDropDown = null;
        }
        if (this.columnListShell != null && !this.columnListShell.isDisposed()) {
            this.columnListShell.dispose();
            this.columnListShell = null;
        }
        this.setDropDownButton("DropDown");
        this.isDropdownShellOpen = false;
    }

    @Override
    public void sortChanged(IMATTableViewer viewer, int column, int direction) {
    }

    @Override
    public void columnResized(IMATTableViewer viewer, int column, int width) {
    }

    @Override
    public void columnMoved(IMATTableViewer viewer, int column, int position) {
        this.refreshListOfColumns();
    }

    @Override
    public void columnShownOrHidden(IMATTableViewer viewer, int column, boolean visible) {
        this.refreshListOfColumns();
    }

    @Override
    public void filterAdded(MATTableFilter filter) {
        if (!filter.isQuickFilter() && filter.getFilteredColumns().size() == 1) {
            this.addFilterLine(filter);
        }
    }

    @Override
    public void filterRemoved(MATTableFilter filter) {
        if (!filter.isQuickFilter() && filter.getFilteredColumns().size() == 1) {
            this.removeFilterLine(filter);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.lastKeyPressed = e.keyCode;
        if (e.widget instanceof Text) {
            if (e.getSource() == this.inputField) {
                if (e.keyCode == 0x1000002 && !this.inputField.getText().isEmpty()) {
                    if (this.columnListDropDown == null) {
                        this.dropDownListOfColumns();
                    } else if (this.columnListDropDown.isDisposed()) {
                        this.dropDownListOfColumns();
                    }
                    this.columnListDropDown.setFocus();
                    this.columnListDropDown.setSelection(0);
                    this.setDropDownButton("Fold");
                    if (this.timerDropDown != null) {
                        this.timerDropDown.cancel();
                        this.timerDropDown = null;
                    }
                }
                if (e.keyCode == 0x1000001 && !this.inputField.getText().isEmpty()) {
                    if (this.columnListDropDown != null && !this.columnListDropDown.isDisposed()) {
                        this.columnListShell.dispose();
                        this.columnListShell = null;
                    }
                    this.setDropDownButton("DropDown");
                }
            }
        } else if (e.widget instanceof org.eclipse.swt.widgets.List && this.lastKeyPressed == 13) {
            this.columnListItemSelectedHandler();
        } else if (e.widget instanceof org.eclipse.swt.widgets.List && (this.lastKeyPressed == 0x1000001 || this.lastKeyPressed == 0x1000002)) {
            if (this.columnListDropDown.getSelectionIndex() == 0 && this.lastColumnDropDownListSelection == 0) {
                this.inputField.setFocus();
                if (this.columnListDropDown != null) {
                    this.columnListShell.dispose();
                    this.columnListShell = null;
                    this.setDropDownButton("DropDown");
                }
                return;
            }
            this.lastColumnDropDownListSelection = this.columnListDropDown.getSelectionIndex();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.getSource() instanceof org.eclipse.swt.widgets.List) {
            this.columnListItemSelectedHandler();
        }
    }
}

