/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.WASTranDelayRowModel;
import com.ca.mat.rowmodels.WASViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.WASViewPage;
import com.ca.mat.views.subpages.AbstractWASSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;

public class WASPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        int type = -1;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        type = presentation.getAnalysisType();
        if (property.equals("hasWASSQLStatements")) {
            MATTableModel model = null;
            model = Singletons.getAnalysisManager().getModel(dsn, "WAS SQL", type);
            return model != null;
        }
        if (property.equals("hasWASSQLDetails")) {
            MATTableModel model = null;
            String section = null;
            HashMap<String, Object> arguments = new HashMap<String, Object[]>();
            if (receiver instanceof WASViewRowModel) {
                WASViewRowModel row = (WASViewRowModel)receiver;
                arguments.put("tranurl", new Object[]{row.getURLName()});
                section = "WAS SQL";
                model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model == null) {
                    return false;
                }
                return model.contains(arguments);
            }
            if (receiver instanceof WASTranDelayRowModel) {
                String wasMethodKey;
                String wasClassKey;
                String wasLnKey;
                WASViewPage.WASContextRestrictions currentContext;
                WASTranDelayRowModel row = (WASTranDelayRowModel)receiver;
                String tranShrt = null;
                if (page instanceof AbstractWASSubpage && (currentContext = ((AbstractWASSubpage)page).getContextRestrictions()) != null) {
                    tranShrt = currentContext.getWASTransaction();
                }
                section = "WAS Tran Delay";
                String dataMode = row.getDataMode();
                if (dataMode.equals("data_mode_application")) {
                    wasLnKey = "waslinea";
                    wasClassKey = "wasclssa";
                    wasMethodKey = "wasmetha";
                } else if (dataMode.equals("data_mode_via")) {
                    wasLnKey = "waslinev";
                    wasClassKey = "wasclssv";
                    wasMethodKey = "wasmethv";
                } else if (dataMode.equals("data_mode_current")) {
                    wasLnKey = "waslinec";
                    wasClassKey = "wasclssc";
                    wasMethodKey = "wasmethc";
                } else {
                    return false;
                }
                arguments = new HashMap();
                if (tranShrt != null) {
                    arguments.put("tranurl", new Object[]{tranShrt});
                }
                arguments.put(wasMethodKey, new Object[]{row.getMethodName()});
                arguments.put(wasClassKey, new Object[]{row.getClassName()});
                arguments.put(wasLnKey, new Object[]{row.getLine()});
                model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                if (model != null) {
                    model = model.filterBy(arguments);
                }
                if (model == null) {
                    return false;
                }
                ArrayList<String> sqlKeysList = new ArrayList<String>();
                MATTableRow[] mATTableRowArray = model.getRows();
                int n = mATTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MATTableRow stepOneRow = mATTableRowArray[n2];
                    WASTranDelayRowModel r = (WASTranDelayRowModel)stepOneRow;
                    String sqlShort = r.getSqlshort().trim();
                    if (sqlShort != null && !sqlShort.equals("")) {
                        sqlKeysList.add(r.getSqlshort());
                    }
                    ++n2;
                }
                return !sqlKeysList.isEmpty();
            }
            return false;
        }
        return false;
    }
}

