/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.rowmodels.TaskViewRowModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class TimeViewRowModel
extends MATTableRow
implements IXmlAttrHandler,
Cloneable,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String TASK_ID = "Task Id";
    public static final String TRAN_ID = "Transaction";
    public static final String CSECT = "Csect";
    public static final String MODULE = "Module";
    public static final String OFFSET = "Offset";
    public static final String CALLER_CSECT = "Caller-Csect";
    public static final String CALLER_MODULE = "Caller-Module";
    public static final String DB_STATEMENT = "Statement";
    public static final String DDN = "DDN";
    public static final String TTYPE1 = "ttype1";
    public static final String TTYPE2 = "ttype2";
    public static final String MAJNM = "majnm";
    public static final String OUTDDN = "outddn";
    public static final String OUT4GLAN = "out4glan";
    public static final String STATUS = "status";
    private Integer seqnr = null;
    private Integer sampno = null;
    private String module = "";
    private String csect = "";
    private String offset = "";
    private String status = "";
    private String det = "";
    private String callerid = "";
    private String callcsct = "";
    private String timcoff = "";
    private String timtask = "";
    private String timtranc = "";
    private String dbstatement = "";
    private String ddn = "";
    private Integer ttype1 = null;
    private Integer ttype2 = null;
    private String delayedRes = "";
    private String delayedComp = "";
    private String curlmod = "";
    private String appllmod = "";
    private String vialmod = "";
    private String majnm = "";
    private String outddn = "";
    private String out4glan = "";
    private String outiosta = "";
    private static final String sourceClass = TaskViewRowModel.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();

    public TimeViewRowModel(MATTableModel model) {
        super(model);
    }

    public TimeViewRowModel() {
        this(null);
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.seqnr, this.sampno, this.module, this.csect, this.offset, this.status, this.det, this.callerid, this.callcsct, this.timcoff, this.timtask, this.timtranc};
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        TimeViewRowModel result = new TimeViewRowModel(model);
        String value = attr.getValue("CALLCSCT");
        if (value != null) {
            result.callcsct = value.trim();
        }
        if ((value = attr.getValue("CALLERID")) != null) {
            result.callerid = value.trim();
        }
        if ((value = attr.getValue("CSECT")) != null) {
            result.csect = value.trim();
        }
        if ((value = attr.getValue("DET")) != null) {
            result.det = value.trim();
        }
        if ((value = attr.getValue("MODULE")) != null) {
            result.module = value.trim();
        }
        if ((value = attr.getValue("OFFSET")) != null) {
            result.offset = value.trim();
        }
        if ((value = attr.getValue("SAMPNO")) != null) {
            result.sampno = Integer.valueOf(value.trim());
        }
        if ((value = attr.getValue("SEQNR")) != null) {
            result.seqnr = Integer.valueOf(value.trim());
        }
        if ((value = attr.getValue("STATUS")) != null) {
            result.status = value.trim();
        }
        if ((value = attr.getValue("TIMCOFF")) != null) {
            result.timcoff = value.trim();
        }
        if ((value = attr.getValue("TIMTASK")) != null) {
            result.timtask = value.trim();
        }
        if ((value = attr.getValue("TIMTRANC")) != null) {
            result.timtranc = value.trim();
        }
        if ((value = attr.getValue("WAITTP1")) != null) {
            result.ttype1 = Integer.valueOf(value.trim());
        }
        if ((value = attr.getValue("WAITTP2")) != null) {
            result.ttype2 = Integer.valueOf(value.trim());
        }
        if ((value = attr.getValue("OUTDRES1")) != null) {
            result.delayedRes = value.trim();
        }
        if ((value = attr.getValue("OUTDCMP1")) != null) {
            result.delayedComp = value.trim();
        }
        if ((value = attr.getValue("OUTDBSTM")) != null) {
            try {
                result.dbstatement = Integer.valueOf(value.trim()).toString();
            }
            catch (NumberFormatException numberFormatException) {
                result.dbstatement = value.trim();
            }
        }
        if ((value = attr.getValue("OUTDDN")) != null) {
            result.ddn = value.trim();
        }
        if ((value = attr.getValue("OUTCLMOD")) != null) {
            result.curlmod = value.trim();
        }
        if ((value = attr.getValue("OUTALMOD")) != null) {
            result.appllmod = value.trim();
        }
        if ((value = attr.getValue("OUTVLMOD")) != null) {
            result.vialmod = value.trim();
        }
        if ((value = attr.getValue("OUTMAJNM")) != null) {
            result.majnm = value.trim();
        }
        if ((value = attr.getValue("OUTDDN")) != null) {
            result.outddn = value.trim();
        }
        if ((value = attr.getValue("OUT4GLAN")) != null) {
            result.out4glan = value.trim();
        }
        if ((value = attr.getValue("OUTIOSTA")) != null) {
            result.outiosta = value.trim();
        }
        return result;
    }

    public TimeViewRowModel clone() {
        TimeViewRowModel result = new TimeViewRowModel(this.model);
        result.callcsct = this.callcsct;
        result.callerid = this.callerid;
        result.csect = this.csect;
        result.det = this.det;
        result.module = this.module;
        result.majnm = this.majnm;
        result.offset = this.offset;
        result.sampno = this.sampno;
        result.seqnr = this.seqnr;
        result.status = this.status;
        result.timcoff = this.timcoff;
        result.timtask = this.timtask;
        result.timtranc = this.timtranc;
        return result;
    }

    public void callerIdSwap(boolean swapEmptyCaller) {
        if (swapEmptyCaller || this.callerid != null && !this.callerid.isEmpty()) {
            String tmp = this.module;
            this.module = this.callerid;
            this.callerid = tmp;
            tmp = this.csect;
            this.csect = this.callcsct;
            this.callcsct = tmp;
            tmp = this.offset;
            this.offset = this.timcoff;
            this.timcoff = tmp;
        }
    }

    public boolean hasDetails() {
        return this.det != null && this.det.equals("Yes");
    }

    public Integer getSeqNumber() {
        return this.seqnr;
    }

    public Integer getObsNumber() {
        return this.sampno;
    }

    public String getModule() {
        return this.module;
    }

    public String getCsect() {
        return this.csect;
    }

    public String getOffset() {
        return this.offset;
    }

    public String getCallerModule() {
        return this.callerid;
    }

    public String getCallerCsect() {
        return this.callcsct;
    }

    public String getCallerOffset() {
        return this.timcoff;
    }

    public Object getStatus() {
        return this.status;
    }

    public Integer getDelayType1() {
        return this.ttype1;
    }

    public Integer getDelayType2() {
        return this.ttype2;
    }

    public String getDelayedResource() {
        return this.delayedRes;
    }

    public String getDelayedComponent() {
        return this.delayedComp;
    }

    public String getCallerCurrentModule() {
        return this.curlmod;
    }

    public String getCallerApplicationModule() {
        return this.appllmod;
    }

    public String getCallerViaModule() {
        return this.vialmod;
    }

    public String getIOStat() {
        return this.outiosta;
    }

    public String getMajNM() {
        return this.majnm;
    }

    public String getTimTranc() {
        return this.timtranc;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (TASK_ID.equals(fieldName)) {
            return this.timtask != null && this.timtask.equals(value);
        }
        if (TRAN_ID.equals(fieldName)) {
            return this.timtranc != null && this.timtranc.equals(value);
        }
        if (CSECT.equals(fieldName)) {
            return this.csect != null && this.csect.equals(value);
        }
        if (MODULE.equals(fieldName)) {
            return this.module != null && this.module.equals(value);
        }
        if (OFFSET.equals(fieldName)) {
            return this.offset != null && this.offset.equals(value);
        }
        if (CALLER_MODULE.equals(fieldName)) {
            return this.callerid != null && this.callerid.equals(value);
        }
        if (CALLER_CSECT.equals(fieldName)) {
            return this.callcsct != null && this.callcsct.equals(value);
        }
        if (DB_STATEMENT.equals(fieldName)) {
            return this.dbstatement != null && this.dbstatement.equals(value);
        }
        if (DDN.equals(fieldName)) {
            return this.ddn != null && this.ddn.equals(value);
        }
        if (TTYPE1.equals(fieldName)) {
            return this.ttype1 != null && this.ttype1.equals(value);
        }
        if (TTYPE2.equals(fieldName)) {
            return this.ttype2 != null && this.ttype2.equals(value);
        }
        if (MAJNM.equals(fieldName)) {
            return this.majnm != null && this.majnm.equals(value);
        }
        if (OUTDDN.equals(fieldName)) {
            return this.outddn != null && this.outddn.equals(value);
        }
        if (OUT4GLAN.equals(fieldName)) {
            return this.out4glan != null && this.out4glan.equals(value);
        }
        if (STATUS.equals(fieldName)) {
            return this.status != null && this.status.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }
}

