/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.rowmodels.MonitorRowModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class MonitorHistoryRowModel
extends MonitorRowModel
implements IXmlAttrHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = MonitorHistoryRowModel.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private String SELJOB = "";
    private Integer RUN = null;
    private String SDATE = "";
    private String STIME = "";
    private String CPUTIME = "";
    private Integer EXCPCNT = null;
    private String SIORATE = null;
    private String ACTIVE = null;
    private String WAIT = null;
    private String NONDISP = null;
    private String profileName = "";
    private String locationName = "";
    private String samplesUsed = null;
    private String cpuMdl = "";
    private String cpuSerial = "";
    private String cpuType = "";
    private String elapsedTime = "";
    private Integer errorSamples = null;
    private String exists = "";
    private String invocationDate = "";
    private String invocationTime = "";
    private String datasetName = "";
    private String osLvl = "";
    private Integer pageInCount = null;
    private String procDelay = null;
    private Integer requestedObservations = null;
    private String observationRate = "";
    private String measuredASID = "";
    private String measuredJobID = "";
    private String measuredProgram = "";
    private String measuredStep = "";
    private String measuredProcstep = "";
    private String SMFID = "";
    private Integer strgAbo = null;
    private Integer strgBel = null;
    private String swapped = null;
    private String system = "";
    private String samplesCollected;

    public MonitorHistoryRowModel() {
        this(null, "");
    }

    public MonitorHistoryRowModel(MATTableModel dataset, String locationName) {
        super(dataset);
        this.locationName = locationName;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.SELJOB, this.RUN, this.SDATE, this.STIME, this.CPUTIME, this.EXCPCNT, this.SIORATE, this.ACTIVE, this.WAIT, this.NONDISP, this.procDelay, this.swapped, this.observationRate, this.samplesCollected, this.samplesUsed, this.elapsedTime, this.measuredJobID, this.measuredStep, this.measuredProcstep, this.measuredProgram, this.measuredASID, this.system, this.SMFID, this.exists, this.datasetName, this.invocationDate, this.invocationTime, this.requestedObservations, this.errorSamples, this.strgAbo, this.strgBel, this.pageInCount, this.osLvl, this.cpuType, this.cpuMdl, this.cpuSerial};
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel dataset, String datasetName) {
        MonitorHistoryRowModel result = new MonitorHistoryRowModel(dataset, datasetName);
        String value = null;
        value = attr.getValue("SELJOB");
        if (value != null) {
            result.SELJOB = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("RUN")) != null) {
            result.RUN = Integer.valueOf(value.trim());
        }
        if ((value = attr.getValue("SDATE")) != null) {
            result.SDATE = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("STIME")) != null) {
            result.STIME = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("CPUTIME")) != null) {
            result.CPUTIME = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("EXCPCNT")) != null && !value.equals("-1")) {
            result.EXCPCNT = Integer.valueOf(value);
        }
        if ((value = attr.getValue("SIORATE")) != null && !value.equals("-1")) {
            result.SIORATE = value.trim();
        }
        if ((value = attr.getValue("ACTIVE")) != null && !value.equals("-1")) {
            result.ACTIVE = value.trim();
        }
        if ((value = attr.getValue("WAIT")) != null && !value.equals("-1")) {
            result.WAIT = value.trim();
        }
        if ((value = attr.getValue("NONDISP")) != null && !value.equals("-1")) {
            result.NONDISP = value.trim();
        }
        if ((value = attr.getValue("TNROF")) != null) {
            result.profileName = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("ANASAMP")) != null) {
            result.samplesUsed = value.trim();
        }
        if ((value = attr.getValue("CPUMDL")) != null && !value.equals("-1")) {
            result.cpuMdl = value.trim();
        }
        if ((value = attr.getValue("CPUSER")) != null) {
            result.cpuSerial = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("CPUTYPE")) != null && !value.equals("-1")) {
            result.cpuType = value.trim();
        }
        if ((value = attr.getValue("ELAPSTIM")) != null) {
            result.elapsedTime = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("ERRSAMP")) != null && !value.equals("-1")) {
            result.errorSamples = Integer.valueOf(value);
        }
        if ((value = attr.getValue("EXIST")) != null) {
            result.exists = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("LDATE")) != null) {
            result.invocationDate = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("LTIME")) != null) {
            result.invocationTime = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("NDSN")) != null) {
            result.datasetName = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("OSLVL")) != null) {
            result.osLvl = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("PAGEIN")) != null && !value.equals("-1")) {
            result.pageInCount = Integer.valueOf(value);
        }
        if ((value = attr.getValue("PROCDLY")) != null && !value.equals("-1")) {
            result.procDelay = value.trim();
        }
        if ((value = attr.getValue("REQSAMP")) != null && !value.equals("-1")) {
            result.requestedObservations = Integer.valueOf(value);
        }
        if ((value = attr.getValue("SAMPRATE")) != null) {
            result.observationRate = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("SELASID")) != null) {
            result.measuredASID = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("SELPROG")) != null) {
            result.measuredProgram = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("SELPSTEP")) != null) {
            result.measuredProcstep = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("SELSTEP")) != null) {
            result.measuredStep = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("SELJOBID")) != null) {
            result.measuredJobID = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("SMFID")) != null) {
            result.SMFID = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("STRGABV")) != null && !value.equals("-1")) {
            result.strgAbo = Integer.valueOf(value);
        }
        if ((value = attr.getValue("STRGBEL")) != null && !value.equals("-1")) {
            result.strgBel = Integer.valueOf(value);
        }
        if ((value = attr.getValue("SWAPPED")) != null && !value.equals("-1")) {
            result.swapped = value.trim();
        }
        if ((value = attr.getValue("SYSTEM")) != null) {
            result.system = this.getValidString(value.trim());
        }
        if ((value = attr.getValue("TOTSAMP")) != null) {
            result.samplesCollected = this.getValidString(value.trim());
        }
        return result;
    }

    private String getValidString(String value) {
        if (value != null && !value.equals("-1")) {
            return value;
        }
        return "N/A";
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getStartDate() {
        return this.SDATE;
    }

    public String getStartTime() {
        return this.STIME;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getExists() {
        return this.exists;
    }

    public String getInvocationDate() {
        return this.invocationDate;
    }

    public String getInvocationTime() {
        return this.invocationTime;
    }

    public int getRun() {
        return this.RUN;
    }

    public boolean compareAnalysisFields(MonitorHistoryRowModel other) {
        if (!this.CPUTIME.equals(other.CPUTIME)) {
            return false;
        }
        boolean result = this.EXCPCNT == null ? other.EXCPCNT == null : this.EXCPCNT.equals(other.EXCPCNT);
        if (!result) {
            return false;
        }
        result = this.SIORATE == null ? other.SIORATE == null : this.SIORATE.equals(other.SIORATE);
        if (!result) {
            return false;
        }
        result = this.samplesUsed == null ? other.samplesUsed == null : this.samplesUsed.equals(other.samplesUsed);
        return result;
    }
}

