/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import org.xml.sax.Attributes;

public class DelayViewRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow,
Cloneable {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String TASK_ID = "taskId";
    public static final String MODULE_ID = "modt";
    public static final String CSECT_ID = "csect";
    public static final String TRAN_ID = "ttran";
    public static final String DBRM_ID = "dbrm";
    public static final String DBRMNR_ID = "dbrmnr";
    public static final String GROUPBY_MODULE = "GROUP_BY_MODULE";
    public static final String GROUPBY_MINORCAT = "GROUP_BY_MINORCAT";
    private String taskId = null;
    private String modt = null;
    private String csect = "";
    private String ttran = null;
    private String dbrm = null;
    private String dbrmnr = null;
    private String majorCategory = "";
    private String minorCategory = "";
    private String delayloc = null;
    private String autonav = null;
    private Double active = null;
    private Double total = null;
    private Double wait = null;
    private Integer ttype1 = null;
    private Integer ttype2 = null;

    public DelayViewRowModel() {
        this(null);
    }

    public DelayViewRowModel(MATTableModel model) {
        this(model, null, null, null, null);
    }

    public DelayViewRowModel(MATTableModel model, String majcat, String mincat, Integer ttype1, Integer ttype2) {
        super(model);
        this.majorCategory = majcat;
        this.minorCategory = mincat;
        this.ttype1 = ttype1;
        this.ttype2 = ttype2;
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        DelayViewRowModel result = new DelayViewRowModel(model);
        String value = null;
        value = attr.getValue("TTASKID");
        if (value != null) {
            result.taskId = value.trim();
        }
        if ((value = attr.getValue("TTRAN")) != null) {
            result.ttran = value.trim();
        }
        if ((value = attr.getValue("TTASKID")) != null) {
            result.taskId = value.trim();
        }
        if ((value = attr.getValue("TTRAN")) != null) {
            result.ttran = value.trim();
        }
        if ((value = attr.getValue("TDBRM")) != null) {
            result.dbrm = value.trim();
        }
        if ((value = attr.getValue("TDBRMNR")) != null) {
            result.dbrmnr = value.trim();
        }
        if ((value = attr.getValue("MODT")) != null) {
            result.modt = value.trim();
        }
        if ((value = attr.getValue("CSET")) != null) {
            result.csect = value.trim();
        }
        if ((value = attr.getValue("MAJCAT")) != null) {
            result.majorCategory = value.trim();
        }
        if ((value = attr.getValue("MINCAT")) != null) {
            result.minorCategory = value.trim();
        }
        if ((value = attr.getValue("NEXTEXEC")) != null) {
            if (value.startsWith("Delay Locations ")) {
                if (result.majorCategory.equals("MQSeries Delay")) {
                    result.delayloc = value.trim();
                    result.autonav = "MQ Series Activity";
                } else {
                    result.delayloc = value.trim();
                    result.autonav = null;
                }
            } else {
                result.delayloc = String.format("Delay Locations %s", result.minorCategory);
                result.autonav = value.trim();
            }
        }
        if ((value = attr.getValue("TACT")) != null) {
            result.active = Double.valueOf(value);
        }
        if ((value = attr.getValue("TWAIT")) != null) {
            result.wait = Double.valueOf(value);
        }
        if ((value = attr.getValue("TTOT")) != null) {
            result.total = Double.valueOf(value);
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.majorCategory, this.minorCategory, this.active, this.wait, this.total};
    }

    public String getDelayLocation() {
        return this.delayloc;
    }

    public String getAutonav() {
        return this.autonav;
    }

    public void setAutonav(String autonav) {
        this.autonav = autonav;
    }

    public String getMajorCat() {
        return this.majorCategory;
    }

    public String getMinorCat() {
        return this.minorCategory;
    }

    public Double getActive() {
        return this.active;
    }

    public Double getWait() {
        return this.wait;
    }

    public Double getTotal() {
        return this.total;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (TASK_ID.equals(fieldName)) {
            return this.taskId != null && this.taskId.equals(value);
        }
        if (TRAN_ID.equals(fieldName)) {
            return this.ttran != null && this.ttran.equals(value);
        }
        if (MODULE_ID.equals(fieldName)) {
            return this.modt != null && this.modt.equals(value);
        }
        if (DBRM_ID.equals(fieldName)) {
            return this.dbrm != null && this.dbrm.equals(value);
        }
        if (DBRMNR_ID.equals(fieldName)) {
            return this.dbrmnr != null && this.dbrmnr.equals(value);
        }
        if (CSECT_ID.equals(fieldName)) {
            return this.csect != null && this.csect.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public void addRow(DelayViewRowModel delayRow) {
        this.active = this.active + delayRow.active;
        this.wait = this.wait + delayRow.wait;
        this.total = this.total + delayRow.total;
    }

    public void addPercent(double active, double wait, double total) {
        this.active = this.active == null ? active : active + this.active;
        this.wait = this.wait == null ? wait : wait + this.wait;
        this.total = this.total == null ? total : total + this.total;
    }

    public DelayViewRowModel clone() {
        DelayViewRowModel result = new DelayViewRowModel();
        result.active = this.active;
        result.autonav = this.autonav;
        result.csect = this.csect;
        result.delayloc = this.delayloc;
        result.majorCategory = this.majorCategory;
        result.minorCategory = this.minorCategory;
        result.modt = this.modt;
        result.taskId = this.taskId;
        result.total = this.total;
        result.wait = this.wait;
        return result;
    }

    public String getModule() {
        return this.modt;
    }

    public int getTType1() {
        return this.ttype1;
    }

    public int getTType2() {
        return this.ttype2;
    }
}

