/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CallStackPage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CallerIdViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (obj instanceof CallerIdRowModel) {
            CallerIdRowModel rowModel = (CallerIdRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.callerid.listing")) {
                Singletons.getListingManager().showListing(presentation, rowModel.getOutModule(), rowModel.getOutCsect(), rowModel.getStatement(), dsn, page.getControl().getDisplay());
            }
            if (commandId.equals("com.ca.mat.commands.analysis.callerid.callstack")) {
                HashMap<String, Object[]> callStackArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> callStackTitles = new ArrayList<String[]>();
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "Call Stack Info", type);
                model = AnalysisUtils.calculateCallStack(model, dsn, type, ((CallerIdRowModel)obj).getOutModule());
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CallStackPage.class, "", dsn, type, presentation, CallStackPage.CONTEXT_HELP_ID, model);
                String partName = "CallStack:";
                for (String[] entry : callStackTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CallStackPage) {
                    CallStackPage callStackPage = (CallStackPage)newPage;
                    callStackPage.setFilterExpressions(callStackArgs);
                    callStackPage.setTitleExpressions(callStackTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
        }
        return null;
    }
}

