/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.Messages;
import com.ca.mat.XMLParser;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.connect.MATFamily;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.dialogs.MATErrorDialog;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.LogRowModel;
import com.ca.mat.xml.XMLRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AnalysisPostprocessJob
extends Job {
    String dsn;
    String profile;
    int analysisType;
    XMLRequest xml;
    Display display;
    IWorkbenchWindow window;
    Logger log;
    StandbyDialog pleaseWaitDialog;
    boolean showView;
    boolean cancelled = false;

    public AnalysisPostprocessJob(String name, String dsn, String profile, int analysisType, XMLRequest xml, IWorkbenchWindow window, boolean showView, StandbyDialog pleaseWaitDialog) {
        super(name);
        this.dsn = dsn;
        this.profile = profile;
        this.analysisType = analysisType;
        this.xml = xml;
        this.display = window.getShell().getDisplay();
        this.window = window;
        this.showView = showView;
        this.pleaseWaitDialog = pleaseWaitDialog;
        this.log = Logging.getLogger(this.display);
    }

    protected IStatus run(IProgressMonitor monitor) {
        String filename;
        InputStream is;
        AnalysisManager analysisManager;
        File attached;
        Integer hash;
        IPersistentPreferenceStore store;
        block33: {
            store = Singletons.getUserPreferenceManager(this.display).getStoreForUserId();
            Element analysisElement = this.xml.getCommand();
            hash = Integer.valueOf(analysisElement.getAttribute("hash"));
            attached = this.xml.getAttachedFile();
            analysisManager = Singletons.getAnalysisManager(this.display);
            is = null;
            if (attached != null) {
                analysisManager.deleteLocalXMLFiles(this.dsn, this.profile);
                filename = ((Element)analysisElement.getElementsByTagName("attachment").item(0)).getAttribute("filename");
                Singletons.getTempFilesManager(this.display).registerTempFile(attached);
                try {
                    if (filename.toLowerCase().endsWith("zip")) {
                        JarInputStream jis = new JarInputStream(new BufferedInputStream(new FileInputStream(attached)));
                        jis.getNextEntry();
                        is = jis;
                        break block33;
                    }
                    is = new FileInputStream(attached);
                }
                catch (IOException e) {
                    this.log.log(Level.WARNING, e.getMessage(), e);
                }
            } else {
                filename = null;
                File[] localFiles = analysisManager.getLocalXMLFiles(this.dsn, this.profile);
                if (localFiles != null && localFiles.length > 0) {
                    ArrayList<InputStream> streams = new ArrayList<InputStream>();
                    streams.add(new ByteArrayInputStream("<dummyRoot>".getBytes()));
                    try {
                        File[] fileArray = localFiles;
                        int n = localFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            streams.add(new FileInputStream(f));
                            ++n2;
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    streams.add(new ByteArrayInputStream("</dummyRoot>".getBytes()));
                    is = new SequenceInputStream(Collections.enumeration(streams));
                }
            }
        }
        if (is == null) {
            return Status.OK_STATUS;
        }
        boolean storeLocalXML = store.getBoolean("MAT_STORE_LOCAL");
        try {
            new XMLParser(this.dsn, is, this.display);
        }
        catch (Exception e1) {
            this.log.log(Level.INFO, "Failed to parse analysis data for " + this.dsn, e1);
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MATErrorDialog.openError(AnalysisPostprocessJob.this.window.getShell(), "Failed to parse analysis data", "Parsing of analysis xml file failed.", e1);
                }
            });
            this.cancelled = true;
        }
        Logger log = Logging.getLogger(this.window.getShell().getDisplay());
        String type = "";
        switch (this.analysisType) {
            case 1: {
                type = "ALL";
                break;
            }
            case 0: {
                type = "NORMAL";
                break;
            }
            case 2: {
                type = "ACTIVE";
                break;
            }
            case 3: {
                type = "WAIT";
            }
        }
        log.log(Level.INFO, String.format(Messages.analysisFinished, this.profile, this.dsn, type));
        if (this.pleaseWaitDialog != null && !this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    AnalysisPostprocessJob.this.pleaseWaitDialog.close();
                    ServerProxy proxy = Singletons.getServerProxy(AnalysisPostprocessJob.this.display);
                    proxy.removeDependentDialog(proxy.getConnectedServer(), AnalysisPostprocessJob.this.pleaseWaitDialog);
                }
            });
        }
        if (storeLocalXML && attached != null) {
            InputStream streamToSave = null;
            try {
                if (filename != null) {
                    if (filename.toLowerCase().endsWith("zip")) {
                        JarInputStream jis = new JarInputStream(new BufferedInputStream(new FileInputStream(attached)));
                        jis.getNextEntry();
                        streamToSave = jis;
                    } else {
                        streamToSave = new FileInputStream(attached);
                    }
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                streamToSave = null;
            }
            analysisManager.storeLocalXMLFile(this.profile, this.dsn, hash, streamToSave, type);
            try {
                if (streamToSave != null) {
                    ((InputStream)streamToSave).close();
                }
            }
            catch (IOException iOException) {}
        }
        this.addLog(this.xml, this.dsn, analysisManager);
        if (!this.cancelled) {
            if (this.showView) {
                analysisManager.showAnalysisView(this.window, this.profile, this.dsn);
            } else {
                analysisManager.analysisParsingCompleted(this.dsn, this.analysisType);
            }
        } else {
            analysisManager.analysisCancelled(this.dsn, this.analysisType);
        }
        if (attached != null) {
            Singletons.getTempFilesManager(this.display).unregisterTempFile(attached);
        }
        return Status.OK_STATUS;
    }

    private void addLog(XMLRequest xml, String dsn, AnalysisManager analysisManager) {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] types = nArray;
        NodeList list = xml.getLogs(null);
        int ix = 0;
        while (ix < list.getLength()) {
            Element log = (Element)list.item(ix);
            String messages = xml.logtoString(log);
            int[] nArray2 = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray2[n2];
                MATTableModel model = analysisManager.getModel(dsn, "LogMessages", type);
                if (model != null) {
                    model.addRow(new LogRowModel(model, messages));
                } else {
                    model = analysisManager.getModel(dsn, "LogMessages", 1);
                    if (model != null) {
                        model.addRow(new LogRowModel(model, messages));
                    }
                }
                ++n2;
            }
            ++ix;
        }
    }

    public boolean belongsTo(Object family) {
        if (family instanceof MATFamily) {
            MATFamily matFamily = (MATFamily)family;
            return matFamily.getDisplay().equals(this.display) && (matFamily.getType() == 0 || matFamily.getType() == 1 && matFamily.getDSN() != null && matFamily.getDSN().equals(this.dsn));
        }
        return super.belongsTo(family);
    }

    protected void canceling() {
        this.cancelled = true;
        Singletons.getAnalysisManager(this.display).analysisCancelled(this.dsn, this.analysisType);
    }
}

