/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat;

import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.handlers.RefreshHandler;
import com.ca.mat.managers.Singletons;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class ServerWatch
implements IPropertyChangeListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String NAME = "Server Watch";
    private Logger log = Logger.getLogger(this.getClass().getName());
    private WeakReference<Display> displayWeakRef;
    private RefreshThread thread;
    private IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();

    public ServerWatch() {
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.displayWeakRef = new WeakReference<Display>(Display.getCurrent());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("MAT_REFRESH")) {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            boolean refresh = Boolean.parseBoolean(String.valueOf(event.getNewValue()));
            int sleep = this.store.getInt("MAT_REFRESH_CYCLE");
            if (refresh) {
                this.thread = new RefreshThread(sleep);
                this.thread.start();
            }
        } else if (key.equals("MAT_REFRESH_CYCLE")) {
            try {
                if (this.thread != null) {
                    this.thread.interrupt();
                }
                boolean refresh = this.store.getBoolean("MAT_REFRESH");
                int sleep = this.store.getInt("MAT_REFRESH_CYCLE");
                if (refresh) {
                    this.thread = new RefreshThread(sleep);
                    this.thread.start();
                }
            }
            catch (NumberFormatException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.thread != null) {
            this.thread.interrupt();
        }
        super.finalize();
    }

    public void refreshServers() {
        try {
            final ServerProxy serverProxy = Singletons.getServerProxy((Display)this.displayWeakRef.get());
            MATServer connectedServer = serverProxy.getConnectedServer();
            if (connectedServer == null) {
                return;
            }
            Display display = connectedServer.getDisplay();
            if (display != null) {
                display.asyncExec((Runnable)new Thread(){

                    @Override
                    public void run() {
                        new RefreshHandler().refreshServers(serverProxy.getConnectedServer().getDisplay());
                    }
                });
            }
        }
        catch (SWTException e) {
            if ("Device is disposed".equals(e.getMessage())) {
                return;
            }
            throw e;
        }
    }

    public void startThread() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        boolean refresh = this.store.getBoolean("MAT_REFRESH");
        int sleep = this.store.getInt("MAT_REFRESH_CYCLE");
        if (refresh) {
            this.thread = new RefreshThread(sleep);
            this.thread.start();
        }
    }

    private final class RefreshThread
    extends Thread {
        private boolean refresh;
        private int sleep;

        public RefreshThread(int sleep) {
            super(ServerWatch.NAME);
            this.refresh = true;
            this.sleep = sleep;
        }

        @Override
        public void run() {
            if (ServerWatch.this.displayWeakRef.get() == null || ((Display)ServerWatch.this.displayWeakRef.get()).isDisposed()) {
                return;
            }
            ServerProxy serverProxy = Singletons.getServerProxy((Display)ServerWatch.this.displayWeakRef.get());
            if (serverProxy.getConnectedServer() == null) {
                return;
            }
            serverProxy.getConnectedServer().getDisplay();
            while (this.refresh && ServerWatch.this.displayWeakRef.get() != null && !((Display)ServerWatch.this.displayWeakRef.get()).isDisposed()) {
                if (serverProxy.getConnectedServer() == null) {
                    return;
                }
                if (serverProxy.getConnectedServer().getStatus() == 12 || serverProxy.getConnectedServer().getStatus() == 12) {
                    serverProxy.refreshServerStatus();
                } else {
                    ServerWatch.this.refreshServers();
                }
                try {
                    Thread.sleep(this.sleep * 1000);
                }
                catch (InterruptedException interruptedException) {
                    this.refresh = false;
                }
            }
        }

        @Override
        public void interrupt() {
            this.refresh = false;
            super.interrupt();
        }
    }
}

