/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat;

import com.ca.mat.utils.HexUtil;
import com.ca.mat.xml.XMLRequest;

public class MATException
extends RuntimeException {
    static String cacopyright = "Copyright \u00a9 2017 CA";
    private static final long serialVersionUID = -1572520214450677768L;
    private String errorMessage;
    private int errorLevel = 0;
    private String reasonCode;

    public MATException() {
    }

    public MATException(String message) {
        super(message);
    }

    public MATException(String string, Throwable cause) {
        super(string, cause);
    }

    public MATException(Throwable cause) {
        super(cause);
    }

    public MATException(XMLRequest xml) {
        this(xml.getErrorMessage());
        this.errorMessage = xml.getErrorMessage();
        this.errorLevel = xml.getErrorLevel();
        this.reasonCode = xml.getReasonCode();
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            this.errorMessage = HexUtil.getErrorText(this, true);
        }
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public String getReasonCode() {
        Throwable cause;
        if ((this.reasonCode == null || this.reasonCode.isEmpty()) && (cause = this.getCause()) != null) {
            this.reasonCode = HexUtil.getErrorText(cause, true);
        }
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }
}

