/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.IPageWithModes;
import com.ca.mat.views.pages.PageWithModesContainer;
import org.eclipse.jface.viewers.IDoubleClickListener;

public class JVMPage
extends AnalysisPageBasic
implements IDoubleClickListener,
IPageWithModes {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID_ROOT = "com.ca.mat.pages.jvmview";
    public static final String ID_PROCESS_MODE = "com.ca.mat.pages.jvmview.processmode";
    public static final String ID_APPLICATION_MODE = "com.ca.mat.pages.jvmview.applicationmode";
    public static final String ID_CURRENT_MODE = "com.ca.mat.pages.jvmview.currentmode";
    public static final String ID_VIA_MODE = "com.ca.mat.pages.jvmview.viamode";
    private String modeType = "display_mode_process";
    private String modelLocation = null;
    private String modeSubtype = null;
    private String aggregateMode;
    private String currentMode = "com.ca.mat.commands.analysis.mode.jvmview.process";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.jvmview";
    public static final String SECTION_NAME = "JVM Information";
    private static final String AUTONAV_THREADS_COMMAND_ID = "com.ca.mat.commands.analysis.jvmview.threads";
    private static final String AUTONAV_METHOD_DETAIL_COMMAND_ID = "com.ca.mat.commands.analysis.jvmview.methoddetails";

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        if (this.modeType.equals("display_mode_process")) {
            viewer.addColumn("Process ID", 7, " Process ID", 1);
            viewer.addColumn("JVM Release", 5, "JVM Release", 1);
            viewer.addColumn("Pct %", 4, " Pct%", 9);
            viewer.addColumn(SECTION_NAME, 10, SECTION_NAME, 1);
            viewer.setSortColumn(2);
            viewer.setSortDirection(1024);
            viewer.setDefaultSortColumn(2);
            viewer.setDefaultSortDirection(1024);
        } else if (this.modeType.equals("display_mode_app")) {
            viewer.addColumn("Class.Method", 9, "Class.Method", 1);
            viewer.addColumn("Class Source", 7, "Class Source", 1);
            viewer.addColumn("Pct %", 4, "Pct %", 9);
            viewer.setDefaultSortColumn(2);
            viewer.setDefaultSortDirection(1024);
        }
        viewer.addDoubleClickListener(this);
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getId() {
        String id = null;
        if (this.modeType.equals("display_mode_process")) {
            id = ID_PROCESS_MODE;
        } else if (this.modeSubtype.equals("data_mode_application")) {
            id = ID_APPLICATION_MODE;
        } else if (this.modeSubtype.equals("data_mode_current")) {
            id = ID_CURRENT_MODE;
        } else if (this.modeSubtype.equals("data_mode_via")) {
            id = ID_VIA_MODE;
        }
        return id;
    }

    @Override
    protected String getViewerMementoType() {
        String VIEWER_MEMENTO_TYPE = null;
        if (this.modeType.equals("display_mode_process")) {
            VIEWER_MEMENTO_TYPE = "pages.jvm.process.viewer";
        } else if (this.modeSubtype.equals("data_mode_application")) {
            VIEWER_MEMENTO_TYPE = "pages.jvm.appl.viewer";
        } else if (this.modeSubtype.equals("data_mode_current")) {
            VIEWER_MEMENTO_TYPE = "pages.jvm.current.viewer";
        } else if (this.modeSubtype.equals("data_mode_via")) {
            VIEWER_MEMENTO_TYPE = "pages.jvm.via.viewer";
        }
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        if (this.modeType.equals("display_mode_process")) {
            return AUTONAV_THREADS_COMMAND_ID;
        }
        return AUTONAV_METHOD_DETAIL_COMMAND_ID;
    }

    public String getModeType() {
        return this.modeType;
    }

    public void setModeType(String modeType) {
        this.modeType = modeType;
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        if (this.modeType == null || this.modeType.equals("display_mode_process")) {
            model = AnalysisUtils.aggregateJVM(model, "group_by_process", "data_mode_application", "display_mode_process", this.dsn);
        } else {
            String modeSubtype = this.getModeSubtype();
            model = AnalysisUtils.aggregateJVM(model, "group_by_method", modeSubtype, "display_mode_app", this.dsn);
        }
    }

    public void setModelLocation(String modelLocation) {
        this.modelLocation = modelLocation;
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    @Override
    public String getAdditionalTitleText() {
        String mode = "";
        mode = this.modeType.equals("display_mode_process") ? "Process" : (this.modeSubtype.equals("data_mode_application") ? "Application" : (this.modeSubtype.equals("data_mode_via") ? "Via" : (this.modeSubtype.equals("data_mode_current") ? "Current" : "Unknown")));
        return "Mode: " + mode;
    }

    public String getModeSubtype() {
        return this.modeSubtype;
    }

    public void setModeSubtype(String modeSubtype) {
        this.modeSubtype = modeSubtype;
    }

    public void setModeAggregate(String aggregateMode) {
        this.aggregateMode = aggregateMode;
    }

    public String getModeAggregate() {
        return this.aggregateMode;
    }

    @Override
    public PageWithModesContainer changeMode(String newMode) {
        String displayMode = null;
        String dataMode = null;
        String section = SECTION_NAME;
        MATTableModel nextModel = null;
        String aggregateMode = null;
        if (newMode.equals("com.ca.mat.commands.analysis.mode.jvmview.application")) {
            displayMode = "display_mode_app";
            dataMode = "data_mode_application";
            aggregateMode = "group_by_method";
        } else if (newMode.equals("com.ca.mat.commands.analysis.mode.jvmview.via")) {
            displayMode = "display_mode_app";
            dataMode = "data_mode_via";
            aggregateMode = "group_by_method";
        } else if (newMode.equals("com.ca.mat.commands.analysis.mode.jvmview.current")) {
            displayMode = "display_mode_app";
            dataMode = "data_mode_current";
            aggregateMode = "group_by_method";
        } else if (newMode.equals("com.ca.mat.commands.analysis.mode.jvmview.process")) {
            displayMode = "display_mode_process";
            dataMode = "data_mode_application";
            aggregateMode = "group_by_process";
        } else {
            throw new RuntimeException("unsupported mode change in JVM (" + newMode + ")");
        }
        nextModel = Singletons.getAnalysisManager().getModel(this.dsn, section, this.type);
        if (aggregateMode != null) {
            nextModel = AnalysisUtils.aggregateJVM(nextModel, aggregateMode, dataMode, displayMode, this.dsn);
        }
        JVMPage newPage = new JVMPage();
        newPage.setDSN(this.dsn);
        newPage.setType(this.type);
        newPage.setModeType(displayMode);
        newPage.setModeSubtype(dataMode);
        newPage.setModeAggregate(aggregateMode);
        newPage.setModelLocation(section);
        newPage.setModel(nextModel);
        newPage.currentMode = newMode;
        return new PageWithModesContainer(newPage, nextModel);
    }

    @Override
    public String getRootId() {
        return ID_ROOT;
    }

    @Override
    public String getCurrentMode() {
        return this.currentMode;
    }

    public class JVMContextRestrictions
    implements Cloneable {
        private String JVMMethodName = null;
        private String JVMMethodSource = null;
        private String JVMMethodSourceKey = null;
        private String JVMMethodNameKey = null;
        private String JVMMethodNameId = null;
        private String JVMMethodSourceId = null;
        private String JVMThread = null;
        private String JVMProcess = null;
        private String displayMode;
        private String dataMode;
        private String fromMode;

        public void setJVMMethodName(String jVMMethodName) {
            this.JVMMethodName = jVMMethodName;
        }

        public String getJVMMethodName() {
            return this.JVMMethodName;
        }

        public void setJVMMethodSource(String jVMMethodSource) {
            this.JVMMethodSource = jVMMethodSource;
        }

        public String getJVMMethodSource() {
            return this.JVMMethodSource;
        }

        public void setJVMThread(String jVMThread) {
            this.JVMThread = jVMThread;
        }

        public String getJVMThread() {
            return this.JVMThread;
        }

        public void setJVMProcess(String jVMProcess) {
            this.JVMProcess = jVMProcess;
        }

        public String getJVMProcess() {
            return this.JVMProcess;
        }

        public void setJVMMethodSourceKey(String jVMMethodSourceKey) {
            this.JVMMethodSourceKey = jVMMethodSourceKey;
        }

        public String getJVMMethodSourceKey() {
            return this.JVMMethodSourceKey;
        }

        public void setJVMMethodNameKey(String jVMMethodNameKey) {
            this.JVMMethodNameKey = jVMMethodNameKey;
        }

        public String getJVMMethodNameKey() {
            return this.JVMMethodNameKey;
        }

        public void setJVMMethodNameId(String jVMMethodNameId) {
            this.JVMMethodNameId = jVMMethodNameId;
        }

        public String getJVMMethodNameId() {
            return this.JVMMethodNameId;
        }

        public void setJVMMethodSourceId(String jVMMethodSourceId) {
            this.JVMMethodSourceId = jVMMethodSourceId;
        }

        public String getJVMMethodSourceId() {
            return this.JVMMethodSourceId;
        }

        public JVMContextRestrictions clone() {
            JVMContextRestrictions result = new JVMContextRestrictions();
            result.JVMMethodName = this.JVMMethodName;
            result.JVMMethodNameId = this.JVMMethodNameId;
            result.JVMMethodNameKey = this.JVMMethodNameKey;
            result.JVMMethodSource = this.JVMMethodSource;
            result.JVMMethodSourceId = this.JVMMethodSourceId;
            result.JVMMethodSourceKey = this.JVMMethodSourceKey;
            result.JVMThread = this.JVMThread;
            result.JVMProcess = this.JVMProcess;
            result.dataMode = this.dataMode;
            result.displayMode = this.displayMode;
            result.fromMode = this.fromMode;
            return result;
        }

        public String getDisplayMode() {
            return this.displayMode;
        }

        public void setDisplayMode(String displayMode) {
            this.displayMode = displayMode;
        }

        public void setDataMode(String dataMode) {
            this.dataMode = dataMode;
        }

        public String getDataMode() {
            return this.dataMode;
        }

        public String getFrom() {
            return this.fromMode;
        }

        public void setFrom(String fromMode) {
            this.fromMode = fromMode;
        }
    }
}

