/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.DataViewPage;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.JVMPage;
import com.ca.mat.views.pages.OverViewReportPage;
import com.ca.mat.views.pages.USSViewPage;
import com.ca.mat.views.pages.WASViewPage;
import com.ca.mat.views.subpages.AbstractJVMSubpage;
import com.ca.mat.views.subpages.AbstractUSSSubpage;
import com.ca.mat.views.subpages.AbstractWASSubpage;
import com.ca.mat.views.subpages.TextDisplaySubpage;
import org.eclipse.core.expressions.PropertyTester;

public class PageTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        if (property.equals("isExpectedPage")) {
            return expectedValue.equals(page.getId());
        }
        if (property.equals("linklistOptionOn") && page instanceof DataViewPage) {
            Singletons.getAnalysisManager().getFocusedAnalysisPage();
            return ((DataViewPage)page).getLinklist();
        }
        if (property.equals("hasDelayLocations") && page instanceof DelayViewPage) {
            return true;
        }
        if (property.equals("canFilterContextBy") && expectedValue != null && expectedValue instanceof String) {
            Cloneable context;
            if (page instanceof JVMPage) {
                return true;
            }
            if (page instanceof AbstractJVMSubpage) {
                context = ((AbstractJVMSubpage)page).getContextRestrictions();
                if (context == null) {
                    return true;
                }
                if (expectedValue.equals("process")) {
                    return ((JVMPage.JVMContextRestrictions)context).getJVMProcess() == null;
                }
                if (expectedValue.equals("thread")) {
                    return ((JVMPage.JVMContextRestrictions)context).getJVMThread() == null;
                }
            } else {
                if (page instanceof WASViewPage) {
                    return true;
                }
                if (page instanceof AbstractWASSubpage) {
                    context = ((AbstractWASSubpage)page).getContextRestrictions();
                    if (context == null) {
                        return true;
                    }
                    if (expectedValue.equals("transaction")) {
                        return ((WASViewPage.WASContextRestrictions)context).getWASTransaction() == null;
                    }
                }
            }
        }
        if (property.equals("isTextPage")) {
            if (page instanceof OverViewReportPage) {
                return true;
            }
            return page instanceof TextDisplaySubpage;
        }
        if (property.equals("hasProcessInfoFromPage")) {
            if (page instanceof AbstractUSSSubpage) {
                AbstractUSSSubpage ussPage = (AbstractUSSSubpage)page;
                String dsn = ussPage.getDSN();
                int type = ussPage.getType();
                USSViewPage.USSContextRestrictions context = ussPage.getContextRestrictions();
                if (context == null) {
                    return false;
                }
                String processId = context.getProcessId();
                if (processId == null) {
                    return false;
                }
                String section = "USSView Process " + processId.trim();
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                return model != null;
            }
            return false;
        }
        return false;
    }
}

