/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.Constants;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DelayViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.JVMPage;
import com.ca.mat.views.pages.USSViewPage;
import com.ca.mat.views.subpages.DelayLocationsSubpage;
import com.ca.mat.views.subpages.QueueManagerActivitySubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DelayViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        if (obj instanceof DelayViewRowModel) {
            IAnalysisSubpagePresentation detachedView;
            MATTableModel model;
            Class<?> cl;
            DelayViewRowModel rowModel = (DelayViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.delayview.delaylocations")) {
                DelayViewPage delayView = (DelayViewPage)page;
                HashMap<String, Object[]> delayLocArgs = new HashMap<String, Object[]>();
                delayLocArgs.putAll(delayView.getFilterExpressions());
                ArrayList<String[]> delayLocTitles = new ArrayList<String[]>();
                delayLocTitles.addAll(delayView.getTitleExpressions());
                delayLocArgs.put("ttype1", new Object[]{rowModel.getTType1()});
                delayLocArgs.put("ttype2", new Object[]{rowModel.getTType2()});
                delayLocTitles.add(new String[]{"Delay Type", rowModel.getMinorCat()});
                MATTableModel model2 = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model2 = model2.filterBy(delayLocArgs);
                model2 = AnalysisUtils.calculateDelayLocations(model2, dsn, type, Display.getCurrent());
                IAnalysisSubpagePresentation detachedView2 = AnalysisPagePresentationFactory.showNewDetached(DelayLocationsSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.delaylocations", model2);
                String partName = "Delay Locations:";
                for (String[] entry : delayLocTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView2.setPresentationName(partName);
                AnalysisPage newPage = detachedView2.getCurrentPage();
                if (newPage != null && newPage instanceof DelayLocationsSubpage) {
                    DelayLocationsSubpage delayLocation = (DelayLocationsSubpage)newPage;
                    delayLocation.setFilterExpressions(delayLocArgs);
                    delayLocation.setTitleExpressions(delayLocTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
                return null;
            }
            HashMap<String, Object[]> delayLocArgs = null;
            ArrayList<String[]> delayLocTitles = null;
            String autonav = rowModel.getAutonav();
            if (autonav == null) {
                return null;
            }
            if (autonav.equals("JVM Applications")) {
                autonav = "JVM Information";
            } else if (autonav.equals("Queue Manager Activity")) {
                DelayViewPage delayView = (DelayViewPage)presentation.getCurrentPage();
                Object[] tranId = delayView.getFilterExpressions().get("Transaction");
                if (tranId != null) {
                    autonav = String.format("MQ-Series-Activity Tran %s", tranId[0].toString());
                    delayLocArgs = new HashMap<String, Object[]>();
                    delayLocArgs.putAll(delayView.getFilterExpressions());
                    delayLocTitles = new ArrayList<String[]>();
                    delayLocTitles.addAll(delayView.getTitleExpressions());
                } else {
                    autonav = "MQ Series Activity";
                }
            } else if (autonav.equals("IMS TranNameView")) {
                autonav = "IMS Statements";
            } else if (autonav.equals("CA-IDMS Delays")) {
                autonav = "IDMS Delays";
            }
            MATTableModel result = Singletons.getAnalysisManager().getModel(dsn, autonav, type);
            if (result == null) {
                MessageDialog.openInformation((Shell)page.getControl().getShell(), (String)"No data available", (String)("There is no " + autonav + " data collected in this measurement"));
                return null;
            }
            HashMap<Class, Class> subpageMap = Constants.getSubpageMapping();
            Class subpageClass = subpageMap.get(cl = result.getRows()[0].getClass());
            if (subpageClass == null) {
                throw new RuntimeException(String.format("No subpage defined for rowmodel %s", cl.toString()));
            }
            if (JVMPage.class.isAssignableFrom(subpageClass)) {
                model = Singletons.getAnalysisManager().getModel(dsn, "JVM Information", type);
                model = AnalysisUtils.aggregateJVM(model, "group_by_process", "data_mode_application", "display_mode_process", dsn);
                detachedView = AnalysisPagePresentationFactory.showNewDetached(subpageClass, autonav, dsn, type, presentation, "com.ca.mat.help.jvmview", model);
                ((JVMPage)detachedView.getCurrentPage()).setModelLocation("JVM Information");
            } else if (USSViewPage.class.isAssignableFrom(subpageClass)) {
                model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
                model = AnalysisUtils.calculateUSSViewExperimental(model, dsn, type, rowModel.getTType2());
                detachedView = AnalysisPagePresentationFactory.showNewDetached(subpageClass, autonav, dsn, type, presentation, "com.ca.mat.help.ussview", model);
                USSViewPage newPage = (USSViewPage)detachedView.getActivePage();
                USSViewPage.USSContextRestrictions context = new USSViewPage.USSContextRestrictions(newPage);
                context.setWaitType2(rowModel.getTType2());
                newPage.setContextRestrictions(context);
            } else {
                detachedView = AnalysisPagePresentationFactory.showNewDetached(subpageClass, autonav, dsn, type, presentation);
            }
            detachedView.setPresentationName(Constants.getSubpageTitleMapping().get(cl));
            AnalysisPage detachedPage = detachedView.getCurrentPage();
            if (detachedPage != null) {
                if (delayLocArgs != null && delayLocTitles != null) {
                    if (detachedPage != null && detachedPage instanceof QueueManagerActivitySubpage) {
                        QueueManagerActivitySubpage delayLocation = (QueueManagerActivitySubpage)page;
                        delayLocation.setFilterExpressions(delayLocArgs);
                        delayLocation.setTitleExpressions(delayLocTitles);
                        ((AnalysisPageCalculated)detachedPage).refreshHeader();
                    }
                    if (detachedPage != null && detachedPage instanceof AnalysisPageCalculated) {
                        ((AnalysisPageCalculated)page).refreshHeader();
                    }
                } else if (detachedPage != null && detachedPage instanceof QueueManagerActivitySubpage) {
                    ((AnalysisPageCalculated)detachedPage).refreshHeader();
                }
            }
            return null;
        }
        return null;
    }
}

