/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DataDetailRowModel;
import com.ca.mat.rowmodels.DataViewRowModel;
import com.ca.mat.rowmodels.PoolDatasetRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AdabasPage;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.DB2Page;
import com.ca.mat.views.pages.DataViewPage;
import com.ca.mat.views.pages.DatacomPage;
import com.ca.mat.views.pages.IDMSPage;
import com.ca.mat.views.pages.VolumeStatisticsPage;
import com.ca.mat.views.subpages.IMSStatementSubpage;
import com.ca.mat.views.subpages.QueueManagerActivitySubpage;
import com.ca.mat.views.subpages.TextDisplayTableFormatSubpage;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;

public class DataViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    String dsorg = "";
    String recfm = "";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        int type = presentation.getAnalysisType();
        if (obj instanceof DataViewRowModel) {
            DataViewRowModel rowModel = (DataViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.idmsdelays")) {
                String section = "IDMS Delays";
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IDMSPage.class, section, dsn, type, presentation);
                detachedView.setPresentationName("IDMS Delays");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.imsstatementdetailsall")) {
                String section = "IMS Statements";
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, dsn, type, presentation);
                detachedView.setPresentationName("IMS Statements");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.db2statementdetails")) {
                String section = "DB2 View";
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DB2Page.class, section, dsn, type, presentation);
                detachedView.setPresentationName("DB2 Statements");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.datacomstatementdetails")) {
                String section = "DATACOM Statements";
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DatacomPage.class, section, dsn, type, presentation);
                detachedView.setPresentationName("DATACOM Statements");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.adabasstatementdetails")) {
                String section = "ADABAS Statements";
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(AdabasPage.class, section, dsn, type, presentation);
                detachedView.setPresentationName("ADABAS Statements");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.queuemanageractivity")) {
                String section = "MQ Series Activity";
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(QueueManagerActivitySubpage.class, section, dsn, type, presentation);
                detachedView.setPresentationName("Queue Manager Activity");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.dataview.volumedetails")) {
                String section = "Volume Statistics";
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
                String[] volsers = rowModel.getVolsers();
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("volser", volsers);
                if (volsers.length == 0) {
                    model = new MATTableModel();
                }
                if (model != null) {
                    model = model.filterBy(arguments, true);
                }
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(VolumeStatisticsPage.class, section, dsn, type, presentation, "com.ca.mat.help.datasetdetails", model);
                detachedView.setPresentationName("Volume Statistics: " + rowModel.getDDName() + "/" + rowModel.getDatasetName());
                return null;
            }
        }
        if (commandId.equals("com.ca.mat.commands.analysis.dataview.datasetdetails")) {
            Object[] rows;
            MATTableRow rowModel;
            String section = "Dataset Statistics";
            String ddname = "";
            String dsname = "";
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, section, type);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            if (obj instanceof DataViewRowModel) {
                rowModel = (DataViewRowModel)obj;
                dsname = ((DataViewRowModel)rowModel).getDatasetName();
                ddname = ((DataViewRowModel)rowModel).getDDName();
                this.dsorg = ((DataViewRowModel)rowModel).getDSORG();
                this.recfm = ((DataViewRowModel)rowModel).getRECFM();
                arguments.put("dsnd", new Object[]{dsname});
                arguments.put("ddnd", new Object[]{ddname});
            } else if (obj instanceof PoolDatasetRowModel) {
                rowModel = (PoolDatasetRowModel)obj;
                dsname = ((PoolDatasetRowModel)rowModel).getDatasetName();
                ddname = ((PoolDatasetRowModel)rowModel).getDDName();
                arguments.put("ddnd", new Object[]{ddname});
                arguments.put("dsnd", new Object[]{dsname});
            } else {
                return null;
            }
            if (model != null && (rows = (model = model.filterBy(arguments)).getRows()).length > 0) {
                model = this.populateRowModel(model, rows);
            }
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.datasetdetails", model);
            detachedView.setPresentationName("Data Set Details: " + ddname + "/" + dsname);
            return null;
        }
        DataViewPage currentDataView = (DataViewPage)page;
        if (commandId.equals("com.ca.mat.commands.analysis.dataview.linkoff")) {
            currentDataView.setLinklist(false);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
            evaluationService.requestEvaluation("com.ca.mat.linklistOptionOn");
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.analysis.dataview.linkon")) {
            currentDataView.setLinklist(true);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
            evaluationService.requestEvaluation("com.ca.mat.linklistOptionOn");
            return null;
        }
        return null;
    }

    private MATTableModel populateRowModel(MATTableModel model, Object[] datarows) {
        MATTableModel newmodel = new MATTableModel();
        DataStatsRowModel detail = null;
        String displayValue = "";
        DataDetailRowModel datarow = (DataDetailRowModel)datarows[0];
        DataStatsRowModel dsorgrow = new DataStatsRowModel(newmodel, "DS Org", this.dsorg);
        newmodel.addRow(dsorgrow);
        DataStatsRowModel recFMRow = new DataStatsRowModel(newmodel, "Rec FM", this.recfm);
        newmodel.addRow(recFMRow);
        for (DataDetailRowModel.DataCell cell : datarow.getGeneralDataCells()) {
            if (cell.value == null || cell.value.toString().isEmpty() || (displayValue = cell.value.toString()).startsWith(" ")) continue;
            detail = new DataStatsRowModel(newmodel, model.getColumnDescription(cell.name), displayValue);
            newmodel.addRow(detail);
        }
        Object[] objectArray = datarows;
        int n = datarows.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            datarow = (DataDetailRowModel)obj;
            if (datarows.length > 1) {
                detail = new DataStatsRowModel(newmodel, "", "");
                newmodel.addRow(detail);
                detail = new DataStatsRowModel(newmodel, datarow.getDDSType(), "-------------------------");
                newmodel.addRow(detail);
            }
            for (DataDetailRowModel.DataCell cell : datarow.getComponentSpecificDataCells()) {
                if (cell.value == null || cell.value.toString().isEmpty() || (displayValue = cell.value.toString()).startsWith(" ")) continue;
                detail = new DataStatsRowModel(newmodel, model.getColumnDescription(cell.name), displayValue);
                newmodel.addRow(detail);
            }
            ++n2;
        }
        return newmodel;
    }

    public class DataStatsRowModel
    extends MATTableRow {
        private String value;
        private String fieldName;

        public DataStatsRowModel(MATTableModel model, String fieldName, String value) {
            super(model);
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        protected Object[] getArray() {
            return new String[]{this.fieldName, this.value};
        }
    }
}

