/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeView4GLRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.AnalysisView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.subpages.HistogramSubpage;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CodeView4GLNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof AnalysisView)) {
            return null;
        }
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        String dsn = presentation.getDSN();
        String profile = presentation.getProfile();
        String commandId = event.getCommand().getId();
        int type = presentation.getAnalysisType();
        if (obj instanceof CodeView4GLRowModel) {
            CodeView4GLRowModel rowModel = (CodeView4GLRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.codeview4gl.histogram")) {
                String partName;
                MATTableModel model = Singletons.getAnalysisManager().getStaticModel("TUN4GLS");
                HashMap<String, Object[]> args = new HashMap<String, Object[]>();
                if (rowModel.getLanguage() != null && rowModel.getLanguage().equals("IDEAL")) {
                    partName = String.valueOf(rowModel.getLanguage()) + " Histogram: System " + rowModel.getSystem() + " Program " + rowModel.getRoutine();
                    args.put("library", new Object[]{String.valueOf(rowModel.getSystem()) + rowModel.getObjectVersion()});
                    args.put("routine", new Object[]{rowModel.getRoutine()});
                } else {
                    partName = String.valueOf(rowModel.getLanguage()) + " Histogram: Library " + rowModel.getLibrary() + " Routine " + rowModel.getRoutine();
                    args.put("library", new Object[]{rowModel.getLibrary()});
                    args.put("routine", new Object[]{rowModel.getRoutine()});
                }
                model = model.filterBy(args);
                model = AnalysisUtils.calculateHistogram4GL(model, dsn, rowModel.getRoutine(), type, rowModel.getLanguage(), Display.getCurrent());
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(HistogramSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.histogram", model);
                detachedView.setPresentationName(partName);
                if (detachedView.getCurrentPage() instanceof HistogramSubpage) {
                    HistogramSubpage hist = (HistogramSubpage)detachedView.getCurrentPage();
                    hist.setTotalDelay(rowModel.getTotal());
                    hist.setMode(0);
                }
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.codeview4gl.registerlisting")) {
                if (rowModel.getLanguage().equals("IDEAL")) {
                    Singletons.getListingManager().startListingRegistrationIdeal(part.getSite().getShell(), rowModel.getSystem(), rowModel.getRoutine(), rowModel.getObjectVersion(), rowModel.getSourceVersion(), profile, dsn);
                } else {
                    Singletons.getListingManager().startListingRegistration(part.getSite().getShell(), rowModel.getLibrary(), rowModel.getRoutine(), profile, dsn, "Natural");
                }
            }
        }
        return null;
    }
}

