/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.dialogs.DefineMonitorDialog;
import com.ca.mat.dialogs.MessageDialogWithCheckbox;
import com.ca.mat.handlers.RefreshHandler;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.views.MonitorTreeView;
import com.ca.mat.xml.XMLParserUtil;
import com.ca.mat.xml.XMLRequest;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class MonitorHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        String commandId = event.getCommand().getId();
        if (commandId.equals("com.ca.mat.commands.monitor.define")) {
            this.openDefineOrEditMonitorDialog(event, true);
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.monitor.edit")) {
            this.openDefineOrEditMonitorDialog(event, false);
            return null;
        }
        if (commandId.equals("com.ca.mat.commands.display.schedules")) {
            this.displaySchedules(event);
            return null;
        }
        if (part instanceof MonitorTreeView) {
            IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            for (Object item : selection) {
                if (!(item instanceof MonitorProfileRowModel)) continue;
                MonitorProfileRowModel profile = (MonitorProfileRowModel)item;
                String profileName = profile.getProfileName();
                ServerProxy serverProxy = Singletons.getServerProxy(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
                if (commandId.equals("com.ca.mat.commands.monitor.delete")) {
                    MessageDialogWithCheckbox dialog = this.openDeleteMonitorDialog(event);
                    if (dialog.getReturnCode() != 0) continue;
                    serverProxy.delete(profileName, true, dialog.isCheckBoxSelected());
                    RefreshHandler refresh = new RefreshHandler();
                    refresh.refreshServers(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
                    continue;
                }
                if (commandId.equals("com.ca.mat.commands.invoke")) {
                    serverProxy.invoke(profileName, true);
                    continue;
                }
                if (!commandId.equals("com.ca.mat.commands.stop")) continue;
                serverProxy.stop(profileName, true);
            }
        }
        return null;
    }

    private void displaySchedules(ExecutionEvent event) {
        ServerProxy serverProxy = Singletons.getServerProxy(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
        ServerCallback callback = new ServerCallback(){

            @Override
            public void processReply(XMLRequest reply, MATServer server) {
                try {
                    XMLParserUtil.parseXMLAttachment(reply, server);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ca.mat.views.monitorschedulesview", null, 1);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void cancel(XMLRequest reply, MATServer server) {
            }

            @Override
            public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                return false;
            }
        };
        serverProxy.list(7, 2, callback, false);
    }

    private MessageDialogWithCheckbox openDeleteMonitorDialog(ExecutionEvent event) {
        String dialogTitle = "Delete Monitor Profile";
        String warningText = "Are you sure you want to delete this profile?";
        String checkboxText = "Delete data sets";
        Shell parentShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        MessageDialogWithCheckbox dialog = new MessageDialogWithCheckbox(parentShell, dialogTitle, warningText, checkboxText);
        dialog.create();
        dialog.open();
        return dialog;
    }

    private void openDefineOrEditMonitorDialog(ExecutionEvent event, boolean newMonitor) {
        DefineMonitorDialog dialog;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!newMonitor && !selection.isEmpty()) {
            MonitorProfileRowModel profile = (MonitorProfileRowModel)selection.getFirstElement();
            dialog = new DefineMonitorDialog(shell, profile);
        } else {
            dialog = new DefineMonitorDialog(shell);
        }
        dialog.create();
        dialog.open();
    }
}

