/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.XMLFileRowModel;
import com.ca.mat.views.LocalXMLFilesView;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteFileHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof LocalXMLFilesView)) {
            return null;
        }
        IStructuredSelection sel = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<File> list = new ArrayList<File>(sel.size());
        for (Object obj : sel) {
            File[] files;
            if (!(obj instanceof XMLFileRowModel)) continue;
            XMLFileRowModel fileRow = (XMLFileRowModel)obj;
            File[] fileArray = files = Singletons.getAnalysisManager().getLocalXMLFiles(fileRow.getDsn(), fileRow.getProfile());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.canWrite() && file.isFile()) {
                    list.add(file);
                }
                ++n2;
            }
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        AnalysisManager analManager = Singletons.getAnalysisManager(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
        String question = "";
        if (list.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"File not found", (String)"File not found on local filesystem, it may have been already deleted.");
            analManager.refreshLocalXMLViews();
            return null;
        }
        if (list.size() > 1) {
            question = String.format("Do you want to delete these %d files", list.size());
        } else {
            String target = ((File)list.get(0)).getName();
            int index = target.lastIndexOf(46);
            if (index > 0 && (index = target.lastIndexOf(46, index - 1)) > 0) {
                target = target.substring(0, index);
            }
            question = String.format("Do you want to delete file: %s", target);
        }
        if (!MessageDialog.openQuestion((Shell)shell, (String)"Confirm File Delete", (String)question)) {
            analManager.refreshLocalXMLViews();
            return null;
        }
        for (File file : list) {
            try {
                File dir = file.getParentFile();
                file.delete();
                if (dir == null || dir.list().length != 0) continue;
                dir.delete();
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, String.format("Failed to delete file: ", file), e);
            }
        }
        analManager.refreshLocalXMLViews();
        return null;
    }
}

