/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.AnalysisView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.subpages.TextDisplaySubpage;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class AnalysisDetachedView
extends AnalysisView
implements IAnalysisSubpagePresentation {
    private IAnalysisPagePresentation parent;
    public static final String ID = "com.ca.mat.views.analysisdetachedview";

    public IAnalysisSubpagePresentation showDetachedPage(Class pageClass, String modelName, String dsn, int type, IAnalysisPagePresentation parent, String contextHelpId, MATTableModel externalModel, boolean deferPAgeFocus) {
        Logger log = Logging.getLogger((Display)Display.getCurrent());
        try {
            String secId = pageClass + "/" + modelName + "/" + dsn + "/" + type + "/" + new Date().getTime();
            IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID, secId, 3);
            AnalysisDetachedView instance = (AnalysisDetachedView)part;
            instance.secondaryId = secId;
            instance.setAnalysisType(type);
            instance.setDSN(dsn);
            instance.setProfile(parent.getProfile());
            if (!instance.detached) {
                int y;
                instance.detached = true;
                IViewReference ref = instance.getSite().getPage().findViewReference(ID, instance.secondaryId);
                if (ref == null && instance.secondaryId != null) {
                    String viewId404795 = "com.ca.mat.views.analysisdetachedview:" + instance.secondaryId;
                    ref = instance.getSite().getPage().findViewReference(viewId404795, instance.secondaryId);
                }
                part = (IViewPart)ref.getPart(false);
                MPart partmodel = ((WorkbenchPartReference)ref).getModel();
                MPlaceholder placeholder = partmodel.getCurSharedRef();
                EModelService s = (EModelService)instance.getSite().getService(EModelService.class);
                Point cursor = Display.getDefault().getCursorLocation();
                Rectangle bounds = Display.getDefault().getBounds();
                Point size = new Point(700, 400);
                int x = cursor.x;
                if (x + size.x > bounds.x + bounds.width) {
                    x = bounds.x + bounds.width - size.x;
                }
                if (x < bounds.x) {
                    x = bounds.x;
                }
                if ((y = cursor.y) + size.y > bounds.y + bounds.height) {
                    y = bounds.y + bounds.height - size.y;
                }
                if (y < bounds.y) {
                    y = bounds.y;
                }
                s.detach((MPartSashContainerElement)placeholder, x, y, size.x, size.y);
                MATTableModel model = externalModel;
                if (model == null) {
                    model = Singletons.getAnalysisManager().getModel(dsn, modelName, type);
                }
                if (model != null) {
                    TextDisplaySubpage textPage;
                    AnalysisPageBasic basicPage;
                    AnalysisPage page = (AnalysisPage)pageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (page instanceof AnalysisPageCalculated) {
                        AnalysisPageCalculated pageCalc = (AnalysisPageCalculated)page;
                        pageCalc.showHeader(true);
                    }
                    if (page instanceof AnalysisPageBasic) {
                        basicPage = (AnalysisPageBasic)page;
                        basicPage.setContextHelpId(contextHelpId);
                    } else if (TextDisplaySubpage.class.isAssignableFrom(pageClass)) {
                        textPage = (TextDisplaySubpage)page;
                        textPage.setContextHelpId(contextHelpId);
                    }
                    instance.addPage(page, true);
                    instance.updateTitle();
                    instance.showPage(page);
                    instance.setParent(parent);
                    if (page instanceof AnalysisPageBasic) {
                        basicPage = (AnalysisPageBasic)page;
                        basicPage.setModel(model);
                    } else if (TextDisplaySubpage.class.isAssignableFrom(pageClass)) {
                        textPage = (TextDisplaySubpage)page;
                        textPage.setModel(model);
                    }
                    IAnalysisPagePresentation topParent = parent;
                    while (topParent != null && !(topParent instanceof AnalysisTabbedView)) {
                        topParent = ((AnalysisDetachedView)topParent).getParent();
                    }
                    if (topParent != null) {
                        topParent.addViewToCloseUponClosing((IAnalysisPagePresentation)instance);
                    }
                    if (!deferPAgeFocus) {
                        Singletons.getAnalysisManager().analysisPageFocused(page);
                    }
                } else {
                    log.log(Level.INFO, "Model not found: {0} : {1} : {2}", new Object[]{dsn, modelName, type});
                }
                instance.getSite().getShell().forceActive();
            }
            return instance;
        }
        catch (PartInitException e) {
            log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        catch (SecurityException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        catch (InstantiationException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
        return null;
    }

    public IAnalysisPagePresentation getParent() {
        return this.parent;
    }

    private void setParent(IAnalysisPagePresentation parent) {
        this.parent = parent;
    }
}

