/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.xml;

import com.ca.mat.XMLParser;
import com.ca.mat.connect.MATServer;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.xml.XMLRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLParserUtil {
    public static void parseXMLAttachment(XMLRequest reply, MATServer server) throws Exception {
        InputStream inputStream;
        File attachedFile = null;
        if (reply.hasAttachedFile()) {
            attachedFile = reply.getAttachedFile();
            Singletons.getTempFilesManager(server.getDisplay()).registerTempFile(attachedFile);
            inputStream = new BufferedInputStream(new FileInputStream(reply.getAttachedFile()));
        } else {
            inputStream = reply.toInputStream();
        }
        new XMLParser(null, inputStream, server.getDisplay());
        try {
            inputStream.close();
            if (attachedFile != null) {
                Singletons.getTempFilesManager(server.getDisplay()).unregisterTempFile(attachedFile);
            }
        }
        catch (IOException e1) {
            Logger log = Logging.getLogger(server.getDisplay());
            log.log(Level.INFO, "Exception while closing attachment with monitor tree data", e1);
        }
    }
}

