/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.Activator;
import com.ca.mat.logging.Logging;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class PersistenceManager {
    private static final String sourceClass = PersistenceManager.class.getName();
    Logger log;
    private Map<String, IMemento> map = new HashMap<String, IMemento>();

    public PersistenceManager() {
        this.log = Logging.getLogger(Display.getCurrent());
        this.loadAll();
    }

    public IMemento createNew() {
        return XMLMemento.createWriteRoot((String)"viewState");
    }

    public IMemento get(String id) {
        if (!this.map.containsKey(id)) {
            this.set(id, this.createNew());
        }
        return this.map.get(id);
    }

    public void set(String id, IMemento value) {
        this.map.put(id, value);
    }

    public void reset(String id) {
        if (this.map.containsKey(id)) {
            this.map.remove(id);
        }
    }

    public void loadAll() {
        IPath propertyPath = Activator.plugin.getFragmentActivator().getPropertyPath();
        File file = (propertyPath = propertyPath.append("matproperties.xml")).toFile();
        if (file != null && file.exists()) {
            try {
                IMemento[] mementos;
                this.map = new HashMap<String, IMemento>();
                XMLMemento root = XMLMemento.createReadRoot((Reader)new FileReader(file));
                IMemento[] iMementoArray = mementos = root.getChildren("viewState");
                int n = mementos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento memento = iMementoArray[n2];
                    String viewId = memento.getString("ID");
                    if (viewId != null) {
                        this.map.put(viewId, memento);
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                this.log.log(Level.INFO, "Failed to load persistent properties", e);
            }
            catch (WorkbenchException e) {
                this.log.log(Level.INFO, "Failed to load persistent properties", e);
            }
        }
    }

    public void saveAll() {
        File file;
        IPath propertyPath = Activator.plugin.getFragmentActivator().getPropertyPath();
        File directory = propertyPath.toFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(file = (propertyPath = propertyPath.append("matproperties.xml")).toFile()).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.log.log(Level.INFO, "Failed to create the file for persistent properties", e);
            }
        }
        XMLMemento root = XMLMemento.createWriteRoot((String)"Root");
        for (Map.Entry<String, IMemento> entry : this.map.entrySet()) {
            entry.getValue().putString("ID", entry.getKey());
            root.copyChild(entry.getValue());
        }
        try {
            root.save((Writer)new FileWriter(file));
        }
        catch (IOException e) {
            this.log.log(Level.INFO, "Failed to save persistent properties", e);
        }
    }

    public void clearAll() {
        this.map.clear();
        this.saveAll();
    }
}

