/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.JVMInfoRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.JVMPage;
import com.ca.mat.views.pages.PageWithModesContainer;
import com.ca.mat.views.subpages.AbstractJVMSubpage;
import com.ca.mat.views.subpages.JVMMethodDetailSubpage;
import com.ca.mat.views.subpages.JVMMethodsSubpage;
import com.ca.mat.views.subpages.JVMProcessesSubpage;
import com.ca.mat.views.subpages.JVMThreadsSubpage;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JVMNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAnalysisSubpagePresentation detachedView;
        JVMInfoRowModel row;
        JVMPage jvmPage;
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        String displayMode = null;
        String dataMode = null;
        String section = null;
        MATTableModel nextModel = null;
        HashMap<String, Object> arguments = null;
        String aggregateMode = null;
        if (page instanceof JVMPage) {
            jvmPage = (JVMPage)page;
            if (commandId.startsWith("com.ca.mat.commands.analysis.mode")) {
                PageWithModesContainer newPageContainer;
                boolean compare;
                if (commandId.equals("com.ca.mat.commands.analysis.mode.jvmview.application")) {
                    compare = Singletons.getCompareManager().getCompare();
                    if (compare) {
                        Singletons.getCompareManager().modeChanged(commandId);
                    }
                } else if (commandId.equals("com.ca.mat.commands.analysis.mode.jvmview.via")) {
                    compare = Singletons.getCompareManager().getCompare();
                    if (compare) {
                        Singletons.getCompareManager().modeChanged(commandId);
                    }
                } else if (commandId.equals("com.ca.mat.commands.analysis.mode.jvmview.current")) {
                    compare = Singletons.getCompareManager().getCompare();
                    if (compare) {
                        Singletons.getCompareManager().modeChanged(commandId);
                    }
                } else if (commandId.equals("com.ca.mat.commands.analysis.mode.jvmview.process")) {
                    compare = Singletons.getCompareManager().getCompare();
                    if (compare) {
                        Singletons.getCompareManager().modeChanged(commandId);
                    }
                } else {
                    return null;
                }
                if ((newPageContainer = jvmPage.changeMode(commandId)).getModel() != null) {
                    AnalysisTabbedView tabView;
                    presentation.addPage(newPageContainer.getAnalysisPage(), true);
                    ((JVMPage)newPageContainer.getAnalysisPage()).setModel(newPageContainer.getModel());
                    presentation.showPage(newPageContainer.getAnalysisPage());
                    Singletons.getAnalysisManager().analysisPageFocused(newPageContainer.getAnalysisPage());
                    if (presentation instanceof AnalysisTabbedView && !jvmPage.equals((tabView = (AnalysisTabbedView)presentation).getPage("JVM"))) {
                        jvmPage.dispose();
                    }
                }
            }
        }
        if (commandId.equals("com.ca.mat.commands.analysis.jvmview.threads") && obj instanceof JVMInfoRowModel && (page instanceof JVMPage || page instanceof AbstractJVMSubpage)) {
            JVMPage.JVMContextRestrictions currentContext;
            arguments = new HashMap<String, Object[]>();
            if (page instanceof JVMPage) {
                currentContext = new JVMPage.JVMContextRestrictions((JVMPage)page);
                dataMode = "data_mode_application";
                currentContext.setFrom("Process");
            } else {
                currentContext = ((AbstractJVMSubpage)page).getContextRestrictions();
                this.fillFiltersFromContext(currentContext, arguments);
                dataMode = currentContext.getDataMode();
            }
            row = (JVMInfoRowModel)obj;
            String pid = row.getProcessId();
            section = "JVM Information";
            aggregateMode = "group_by_thread";
            displayMode = "display_mode_threads";
            currentContext.setDataMode(dataMode);
            currentContext.setDisplayMode(displayMode);
            arguments.put("jvmpid", new Object[]{pid});
            currentContext.setJVMProcess(pid);
            nextModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
            nextModel = nextModel.filterBy(arguments);
            nextModel = AnalysisUtils.aggregateJVM(nextModel, aggregateMode, dataMode, displayMode, dsn);
            detachedView = AnalysisPagePresentationFactory.showNewDetached(JVMThreadsSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.jvmthreads", nextModel, true);
            AnalysisPage newPage = detachedView.getActivePage();
            ((AbstractJVMSubpage)newPage).setContextRestrictions(currentContext);
            ((AbstractJVMSubpage)newPage).refreshHeader();
            Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
            detachedView.setPresentationName("JVM Thread TCBs");
        } else {
            String[] keys;
            String currentDataMode;
            if (commandId.equals("com.ca.mat.commands.analysis.jvmview.methoddetails") && obj instanceof JVMInfoRowModel && (page instanceof JVMPage || page instanceof AbstractJVMSubpage)) {
                String filterMethodNameKey;
                JVMPage.JVMContextRestrictions currentContext;
                if (page instanceof JVMPage) {
                    jvmPage = (JVMPage)page;
                    currentContext = new JVMPage.JVMContextRestrictions(jvmPage);
                    if (jvmPage.getModeType().equals("display_mode_process")) {
                        currentContext.setFrom("Process");
                    } else if (jvmPage.getModeSubtype().equals("data_mode_application")) {
                        currentContext.setFrom("Application");
                    } else if (jvmPage.getModeSubtype().equals("data_mode_via")) {
                        currentContext.setFrom("Via");
                    } else if (jvmPage.getModeSubtype().equals("data_mode_current")) {
                        currentContext.setFrom("Current");
                    }
                } else {
                    currentContext = ((AbstractJVMSubpage)page).getContextRestrictions();
                }
                row = (JVMInfoRowModel)obj;
                arguments = new HashMap();
                displayMode = "display_mode_lines";
                aggregateMode = "group_by_line";
                section = "JVM Information";
                if (page.getId().equals("com.ca.mat.pages.jvmview.processmode") || page.getId().equals("com.ca.mat.pages.jvmview.applicationmode") || page.getId().equals("com.ca.mat.pages.jvmview.currentmode") || page.getId().equals("com.ca.mat.pages.jvmview.viamode")) {
                    currentDataMode = row.getDataMode();
                    keys = this.determineConstantKeys(currentDataMode, commandId);
                    filterMethodNameKey = keys[0];
                    String filterMethodSourceKey = keys[1];
                    String filterMethodNameValue = row.getMethodId();
                    String filterMethodSourceValue = row.getSourceId();
                    arguments.put(filterMethodNameKey, new Object[]{filterMethodNameValue});
                    arguments.put(filterMethodSourceKey, new Object[]{filterMethodSourceValue});
                    currentContext.setJVMMethodName(row.getClassMethod());
                    currentContext.setJVMMethodNameId(filterMethodNameValue);
                    currentContext.setJVMMethodNameKey(filterMethodNameKey);
                    currentContext.setJVMMethodSource(row.getClassSource());
                    currentContext.setJVMMethodSourceId(filterMethodSourceValue);
                    currentContext.setJVMMethodSourceKey(filterMethodSourceKey);
                    String classMethod = row.getClassMethod();
                    if (classMethod.equals("** No Calls **")) {
                        return null;
                    }
                } else if (page instanceof AbstractJVMSubpage) {
                    this.fillFiltersFromContext(currentContext, arguments);
                    currentDataMode = currentContext.getDataMode();
                    if (page instanceof JVMMethodsSubpage) {
                        keys = this.determineConstantKeys(currentDataMode, commandId);
                        filterMethodNameKey = keys[0];
                        String filterMethodSourceKey = keys[1];
                        String filterMethodNameValue = row.getMethodId();
                        String filterMethodSourceValue = row.getSourceId();
                        nextModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
                        nextModel = nextModel.filterBy(arguments);
                        arguments = new HashMap();
                        arguments.put(filterMethodNameKey, new Object[]{filterMethodNameValue});
                        arguments.put(filterMethodSourceKey, new Object[]{filterMethodSourceValue});
                        currentContext.setJVMMethodName(row.getClassMethod());
                        currentContext.setJVMMethodNameId(filterMethodNameValue);
                        currentContext.setJVMMethodNameKey(filterMethodNameKey);
                        currentContext.setJVMMethodSource(row.getClassSource());
                        currentContext.setJVMMethodSourceId(filterMethodSourceValue);
                        currentContext.setJVMMethodSourceKey(filterMethodSourceKey);
                    }
                } else {
                    throw new RuntimeException(String.format("Invalid page encountered for command (%1$s) - page (%2$s)", commandId, page.getClass().toString()));
                }
                row.getClassSource();
                if (nextModel == null) {
                    nextModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
                }
                nextModel = nextModel.filterBy(arguments);
                nextModel = AnalysisUtils.aggregateJVM(nextModel, aggregateMode, currentDataMode, displayMode, dsn);
                detachedView = AnalysisPagePresentationFactory.showNewDetached(JVMMethodDetailSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.jvmmethdet", nextModel, true);
                AnalysisPage newPage = detachedView.getActivePage();
                ((AbstractJVMSubpage)newPage).setContextRestrictions(currentContext);
                ((AbstractJVMSubpage)newPage).refreshHeader();
                Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
                detachedView.setPresentationName("JVM Method Details");
                return null;
            }
            if (commandId.equals("com.ca.mat.commands.analysis.jvmview.processes") && obj instanceof JVMInfoRowModel && page instanceof JVMPage || page instanceof AbstractJVMSubpage) {
                String classSource;
                String classMethod;
                String filterMethodSourceValue;
                String filterMethodNameValue;
                String filterMethodSourceKey;
                String filterMethodNameKey;
                JVMPage.JVMContextRestrictions currentContext;
                if (page instanceof JVMPage) {
                    jvmPage = (JVMPage)page;
                    currentContext = new JVMPage.JVMContextRestrictions(jvmPage);
                    if (jvmPage.getModeType().equals("display_mode_process")) {
                        currentContext.setFrom("Process");
                    } else if (jvmPage.getModeSubtype().equals("data_mode_application")) {
                        currentContext.setFrom("Application");
                    } else if (jvmPage.getModeSubtype().equals("data_mode_via")) {
                        currentContext.setFrom("Via");
                    } else if (jvmPage.getModeSubtype().equals("data_mode_current")) {
                        currentContext.setFrom("Current");
                    }
                } else {
                    currentContext = ((AbstractJVMSubpage)page).getContextRestrictions();
                }
                row = (JVMInfoRowModel)obj;
                arguments = new HashMap();
                displayMode = "display_mode_process";
                aggregateMode = "group_by_process";
                section = "JVM Information";
                if (page instanceof JVMPage || page instanceof JVMMethodsSubpage) {
                    currentDataMode = row.getDataMode();
                    keys = this.determineConstantKeys(currentDataMode, commandId);
                    filterMethodNameKey = keys[0];
                    filterMethodSourceKey = keys[1];
                    filterMethodNameValue = row.getMethodId();
                    filterMethodSourceValue = row.getSourceId();
                    arguments.put(filterMethodNameKey, new Object[]{filterMethodNameValue});
                    arguments.put(filterMethodSourceKey, new Object[]{filterMethodSourceValue});
                    classMethod = row.getClassMethod();
                    classSource = row.getClassSource();
                    if (classMethod.equals("** No Calls **")) {
                        classMethod = "N/A";
                        classSource = "N/A";
                    }
                } else {
                    throw new RuntimeException(String.format("Invalid page encountered for command (%1$s) - page (%2$s)", commandId, page.getClass().toString()));
                }
                currentContext.setJVMMethodName(classMethod);
                currentContext.setJVMMethodNameId(filterMethodNameValue);
                currentContext.setJVMMethodNameKey(filterMethodNameKey);
                currentContext.setJVMMethodSource(classSource);
                currentContext.setJVMMethodSourceId(filterMethodSourceValue);
                currentContext.setJVMMethodSourceKey(filterMethodSourceKey);
                currentContext.setDisplayMode(displayMode);
                currentContext.setDataMode(currentDataMode);
                nextModel = Singletons.getAnalysisManager().getModel(dsn, section, type);
                nextModel = nextModel.filterBy(arguments);
                nextModel = AnalysisUtils.aggregateJVM(nextModel, aggregateMode, currentDataMode, displayMode, dsn);
                detachedView = AnalysisPagePresentationFactory.showNewDetached(JVMProcessesSubpage.class, section, dsn, type, presentation, "com.ca.mat.help.jvmprocesses", nextModel, true);
                AnalysisPage newPage = detachedView.getActivePage();
                ((AbstractJVMSubpage)newPage).setContextRestrictions(currentContext);
                ((AbstractJVMSubpage)newPage).refreshHeader();
                Singletons.getAnalysisManager().analysisPageFocused(detachedView.getCurrentPage());
                detachedView.setPresentationName("JVM Processes");
                return null;
            }
        }
        return null;
    }

    private String[] determineConstantKeys(String currentDataMode, String commandId) {
        String filterMethodNameKey = "";
        String filterMethodSourceKey = "";
        if (currentDataMode.equals("data_mode_application")) {
            filterMethodNameKey = "jvmmetha";
            filterMethodSourceKey = "jvmsrcea";
        } else if (currentDataMode.equals("data_mode_via")) {
            filterMethodNameKey = "jvmmethv";
            filterMethodSourceKey = "jvmsrcev";
        } else if (currentDataMode.equals("data_mode_current")) {
            filterMethodNameKey = "jvmmethc";
            filterMethodSourceKey = "jvmsrcec";
        } else {
            throw new RuntimeException(String.format("Invalid row state in command (%1$s) dataMode(%2$s)", commandId, currentDataMode));
        }
        return new String[]{filterMethodNameKey, filterMethodSourceKey};
    }

    private void fillFiltersFromContext(JVMPage.JVMContextRestrictions currentContext, HashMap<String, Object[]> arguments) {
        if (currentContext.getJVMMethodNameId() != null) {
            arguments.put(currentContext.getJVMMethodNameKey(), new Object[]{currentContext.getJVMMethodNameId()});
        }
        if (currentContext.getJVMMethodSourceId() != null) {
            arguments.put(currentContext.getJVMMethodSourceKey(), new Object[]{currentContext.getJVMMethodSourceId()});
        }
        if (currentContext.getJVMProcess() != null) {
            arguments.put("jvmpid", new Object[]{currentContext.getJVMProcess()});
        }
        if (currentContext.getJVMThread() != null) {
            arguments.put("jvmtcb", new Object[]{currentContext.getJVMThread()});
        }
    }
}

