/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.Activator;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class BundleAnalyzeHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String filename = event.getParameter("com.ca.mat.command.filename");
        if (filename == null || filename.isEmpty()) {
            filename = "Example.xml";
        }
        String bundlename = event.getParameter("com.ca.mat.command.bundle");
        Bundle bundle = null;
        bundle = bundlename == null || bundlename.isEmpty() ? Activator.plugin.getBundle() : Platform.getBundle((String)bundlename);
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getResource(filename);
        if (url == null) {
            return null;
        }
        AnalysisManager analManager = Singletons.getAnalysisManager(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
        try {
            IViewReference[] viewRefs;
            boolean exampleOpen = false;
            IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = viewRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewRef = iViewReferenceArray[n2];
                if (viewRef.getId().equals("com.ca.mat.views.analysistabbedview") && viewRef.getSecondaryId().startsWith("Example")) {
                    exampleOpen = true;
                    break;
                }
                ++n2;
            }
            if (!exampleOpen) {
                if (analManager.getAnalysisState("Example", 1) == 2) {
                    analManager.showAnalysisView(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "Example", "Example");
                } else {
                    InputStream is = url.openStream();
                    int[] nArray = new int[4];
                    nArray[0] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    analManager.processAnalysis(is, "Example", "Example", nArray, true, "Log file not found");
                }
            }
        }
        catch (Exception e) {
            Logging.getLogger(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay()).log(Level.WARNING, "Error while accessing bundle file to retrieve sample analysis", e);
        }
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }
}

