/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.connect.MATLoginCancelledException;
import com.ca.mat.connect.MATSecurityException;
import com.ca.mat.connect.PropertyChangeManager;
import com.ca.mat.dialogs.IUserLogonDialog;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.tuntables.TunprofRowModel;
import com.ca.mat.rowmodels.tuntables.TunsspRowModel;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.MonitorTreeView;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;

public class MATServer
extends PropertyChangeManager
implements IAdaptable,
Comparable<MATServer> {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = MATServer.class.getName();
    static Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = log.getLevel();
    public static final String SERVER_NAME = "Name";
    public static final String SERVER_STATUS = "Status";
    public static final String SERVER_CONNECTING = "Connecting..";
    public static final String SERVER_REFRESHING = "Refreshing..";
    public static final String SERVER_CONNECTED = "Connected";
    public static final String SERVER_UNKNOWN = "Unknown";
    public static final String SERVER_ACTIVE = "Active";
    public static final String SERVER_HOST = "Host";
    public static final String SERVER_PORT = "Port";
    public static final String SERVER_USER = "UserID";
    public static final String SERVER_TYPE = "Type";
    public static final String SERVER_PASSWD = "Password";
    public static final String SERVER_SESSION = "Session";
    public static final String SERVER_SECUTITY_ENABLED = "SecurityEnabled";
    public static final String SERVER_UUID = "UUID";
    public static final String SERVER_SAVE_PASSWD = "SAVE_PASSWD";
    public static final int SERVER_STATUS_CONNECTING = 1;
    public static final int SERVER_STATUS_CONNECTED = 2;
    public static final int SERVER_STATUS_AVAILABLE = 3;
    public static final int SERVER_STATUS_REFRESHING = 4;
    private static final int SERVER_STATUS_ACTIVE_THREASHOLD = 10;
    public static final int SERVER_STATUS_UNKNOWN = 11;
    public static final int SERVER_STATUS_ERROR = 12;
    private static final boolean savepasswordEnabled = Boolean.getBoolean("com.ca.testingtools.savepassword");
    protected String name = "";
    protected String hostname = "";
    private boolean userDialog = false;
    protected int port = 0;
    private String user = "";
    private String password = "";
    private boolean savepassword = false;
    protected String prefix;
    protected IPersistentPreferenceStore store;
    public static final String toStringFormat = "%1$s(%2$s %3$d) %4$s";
    private String statusText = "Unknown";
    private int status = 11;
    protected String UUIDString = "";
    private TunsspRowModel tunssp;
    private String protocol;
    WeakReference<Display> displayWeakRef;

    public MATServer(String name, String host, String port, String uuid, Display display) {
        this.store = Singletons.getUserPreferenceManager(display).getStoreForUserId();
        this.name = name == null ? "" : name;
        this.hostname = host.trim();
        this.port = Integer.decode(port.trim());
        this.UUIDString = uuid;
        this.setUUIDString();
        this.prefix = String.valueOf(uuid) + "_";
        if (!savepasswordEnabled) {
            this.setSavepassword(false);
        }
        this.displayWeakRef = new WeakReference<Display>(display);
        this.savepassword = this.store.getBoolean(String.valueOf(this.prefix) + SERVER_SAVE_PASSWD);
        this.user = this.store.getString(String.valueOf(this.prefix) + SERVER_USER);
        if (this.savepassword) {
            this.password = this.store.getString(String.valueOf(this.prefix) + SERVER_PASSWD);
            this.password = HexUtil.decryptPassword(this.user, this.password);
        }
    }

    @Override
    public int compareTo(MATServer anotherServer) {
        if (this == anotherServer) {
            return 0;
        }
        if (anotherServer == null) {
            return -1;
        }
        if (this == null) {
            return 1;
        }
        int result = this.name.compareToIgnoreCase(anotherServer.getName());
        if (result == 0) {
            result = this.port == anotherServer.getPort() ? 0 : (this.port < anotherServer.getPort() ? -1 : 1);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MATServer) {
            return this.getUUIDString().equals(((MATServer)obj).getUUIDString());
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (this.getClass().equals(adapter)) {
            return this;
        }
        return null;
    }

    public String getHostname() {
        return this.hostname == null ? null : this.hostname.trim();
    }

    public void logOff() {
        this.userDialog = false;
        this.setPassword("");
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_PASSWD, null, (Object)"");
        this.firePropertyChange(event);
    }

    public boolean isUserLoggedon() {
        return this.userDialog && this.user.length() >= 1;
    }

    public String getName() {
        return this.name;
    }

    private String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized String getLogonUser() throws MATException {
        if (!this.userDialog || this.user.length() < 1) {
            final Vector wrapper = new Vector();
            if (this.displayWeakRef.get() != null) {
                ((Display)this.displayWeakRef.get()).syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!MATServer.this.userDialog || MATServer.this.user.length() < 1) {
                            IUserLogonDialog dialog = Singletons.getUserLogonDialog();
                            dialog.setServer(MATServer.this);
                            dialog.create();
                            dialog.open();
                            if (dialog.getReturnCode() != 0) {
                                int result = dialog.getErrorResult();
                                if (result != 0) {
                                    MATException exception = dialog.getReturnCode() == -1 ? new MATSecurityException() : new MATLoginCancelledException();
                                    exception.setErrorLevel(result);
                                    exception.setErrorMessage(dialog.getErrorText());
                                    exception.setReasonCode(dialog.getReason());
                                    wrapper.add(exception);
                                } else {
                                    wrapper.add(new MATLoginCancelledException());
                                }
                            }
                        }
                    }
                });
            }
            if (wrapper.size() > 0) {
                throw (MATException)wrapper.get(0);
            }
        }
        this.userDialog = true;
        return this.user;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSavepassword() {
        return this.savepassword;
    }

    public boolean setHostname(String newhostname) {
        String string = newhostname = newhostname == null ? "" : newhostname.trim();
        if (!newhostname.equals(this.hostname)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_HOST, (Object)this.hostname, (Object)newhostname);
            this.hostname = newhostname;
            this.firePropertyChange(event);
            this.logOff();
            return true;
        }
        return false;
    }

    public void setPassword(String password) {
        String string = password = password == null ? "" : password.trim();
        if (!this.password.equals(password)) {
            this.password = password;
            if (this.savepassword) {
                String tempassword = HexUtil.encryptPassword(this.user, password);
                this.store.setValue(String.valueOf(this.prefix) + SERVER_PASSWD, tempassword);
                try {
                    this.store.save();
                }
                catch (IOException iOException) {}
            } else {
                this.clearPassword();
            }
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void resetPassword() {
        this.setPassword(null);
        this.userDialog = false;
    }

    private void clearPassword() {
        this.store.setToDefault(String.valueOf(this.prefix) + SERVER_PASSWD);
        try {
            this.store.save();
        }
        catch (IOException iOException) {}
    }

    public boolean setPort(int port) {
        if (this.port != port) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_PORT, (Object)this.port, (Object)port);
            this.port = port;
            this.firePropertyChange(event);
            this.logOff();
            return true;
        }
        return false;
    }

    public void setSavepassword(boolean savepassword) {
        if (this.savepassword != savepassword) {
            this.savepassword = savepassword;
            this.store.setValue(String.valueOf(this.prefix) + SERVER_SAVE_PASSWD, this.savepassword);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
            if (!savepassword) {
                this.clearPassword();
            }
        }
    }

    public boolean setUser(String user) {
        String string = user = user == null ? "" : user.trim();
        if (!this.user.equals(user)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_USER, (Object)this.user, (Object)user);
            this.user = user;
            this.firePropertyChange(event);
            this.store.setValue(String.valueOf(this.prefix) + SERVER_USER, this.user);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getText();
    }

    private final void setUUIDString() {
        if (this.UUIDString == null || this.UUIDString.length() == 0) {
            this.UUIDString = UUID.randomUUID().toString();
        }
    }

    public String getUUIDString() {
        this.setUUIDString();
        return this.UUIDString;
    }

    public void setName(String name) {
        String string = name = name == null ? "" : name.trim();
        if (!this.name.equals(name)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_NAME, (Object)this.name, (Object)name);
            this.name = name;
            this.firePropertyChange(event);
        }
    }

    public String getStatusText() {
        return this.statusText == null ? SERVER_UNKNOWN : this.statusText;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTooltip() {
        String tooltip = "Name:     " + this.name + "\n" + "Host:     " + this.hostname + "\n" + "Port:     " + this.port + "\n" + "Status:   " + this.statusText;
        TunprofRowModel profileRow = Singletons.getMonitorManager().getTunProfile();
        if (profileRow != null) {
            tooltip = String.valueOf(tooltip) + "\nServer Id: " + profileRow.getServerId();
        }
        if (this.tunssp != null) {
            tooltip = String.valueOf(tooltip) + "\nExplain SQL:            " + this.tunssp.getExplainHarvestedSQL() + "\n" + "Get SQL from Catalog:   " + this.tunssp.getUseDB2Catalog() + "\n" + "DB2 Requestor Location: " + this.tunssp.getReqestorLocation() + "\n" + "DB2 Correlation ID:     " + this.tunssp.getCorrelationId() + "\n" + "DB2 Operator ID:        " + this.tunssp.getOperatorId() + "\n" + "DB2 Thread Address:     " + this.tunssp.getThreadAddress();
        }
        return tooltip;
    }

    public Image getStatusIcon() {
        switch (this.status) {
            case 1: {
                return Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.refresh");
            }
            case 4: {
                return Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.refresh");
            }
            case 2: {
                return Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.serverconnected");
            }
            case 3: {
                return Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.serverrunning");
            }
        }
        return Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.serverfailed");
    }

    public Color getStatusColor() {
        switch (this.status) {
            case 1: {
                return Display.getCurrent().getSystemColor(8);
            }
            case 4: {
                return Display.getCurrent().getSystemColor(6);
            }
            case 2: {
                return Display.getCurrent().getSystemColor(6);
            }
            case 3: {
                return Display.getCurrent().getSystemColor(6);
            }
            case 11: {
                return Display.getCurrent().getSystemColor(16);
            }
        }
        return Display.getCurrent().getSystemColor(3);
    }

    public void setStatusText(int status, String statusText) {
        PropertyChangeEvent event;
        String string = statusText = statusText == null ? "" : statusText.trim();
        if (!this.statusText.equals(statusText)) {
            event = new PropertyChangeEvent((Object)this, "StatusText", (Object)this.statusText, (Object)statusText);
            this.statusText = statusText;
            this.firePropertyChange(event);
        }
        if (this.status != status) {
            event = new PropertyChangeEvent((Object)this, "status", (Object)this.status, (Object)status);
            this.status = status;
            this.firePropertyChange(event);
            if (status == 12) {
                this.logOff();
            }
        }
    }

    public boolean isActive() {
        return this.status < 10;
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return String.format(toStringFormat, this.getName(), this.getHostname(), this.getPort(), this.getStatusText());
    }

    public static void checkStatus() {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IHandlerService handlerService = this.getHandlerService();
                ICommandService commandService = this.getCommandService();
                Command generateCmd = commandService.getCommand("com.ca.testingtools.commands.refreshserver");
                ExecutionEvent executionEvent = handlerService.createExecutionEvent(generateCmd, new Event());
                try {
                    generateCmd.executeWithChecks(executionEvent);
                }
                catch (Exception e) {
                    log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
                return null;
            }

            private ICommandService getCommandService() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                Object serviceObject = workbench.getAdapter(ICommandService.class);
                if (serviceObject != null) {
                    ICommandService service = (ICommandService)serviceObject;
                    return service;
                }
                return null;
            }

            private IHandlerService getHandlerService() {
                Object serviceObject;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (serviceObject = wb.getAdapter(IHandlerService.class)) != null) {
                    IHandlerService service = (IHandlerService)serviceObject;
                    return service;
                }
                return null;
            }
        };
        job.schedule(2000L);
    }

    public String getEPassword() {
        return HexUtil.encryptPassword(this.user, this.getPassword());
    }

    public Display getDisplay() {
        return (Display)this.displayWeakRef.get();
    }

    public void setTunssp(TunsspRowModel tunssp) {
        this.tunssp = tunssp;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        if (part instanceof MonitorTreeView) {
            MonitorTreeView view = (MonitorTreeView)part;
            view.serverChanged(this);
        }
    }

    public TunsspRowModel getTunssp() {
        return this.tunssp;
    }
}

