/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.pages.IPageTextViewer;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;

public class PageTextViewer
extends TextViewer
implements IPageTextViewer {
    private int[] maxLengths = null;
    private String[] headerRows;
    private MATTableModel model;
    private boolean tableFormat;
    private static final String HEADER_SEPARATOR = "--------------------------------------------------------------------------------";

    public PageTextViewer(Composite parent, Integer style) {
        super(parent, style.intValue());
        this.canDoOperation(4);
        this.canDoOperation(5);
        this.enableOperation(4, true);
        this.enableOperation(10, true);
    }

    public void setModel(MATTableModel model, boolean tableFormat) {
        this.model = model;
        this.tableFormat = tableFormat;
        Document document = null;
        MATTableRow[] rows = null;
        StringBuilder sb = new StringBuilder();
        if (this.headerRows != null) {
            String[] stringArray = this.headerRows;
            int n = this.headerRows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                sb.append(row);
                sb.append(HexUtil.LF);
                ++n2;
            }
            sb.append(HEADER_SEPARATOR);
            sb.append(HexUtil.LF);
        }
        if (model != null) {
            rows = model.getRows();
        }
        if (rows != null) {
            if (tableFormat) {
                int y;
                int x = 0;
                while (x < rows.length) {
                    if (this.maxLengths == null) {
                        this.maxLengths = new int[rows[x].getObjects().length];
                    }
                    y = 0;
                    while (y < rows[x].getObjects().length) {
                        int length = rows[x].getText(y).length();
                        if (length > this.maxLengths[y]) {
                            this.maxLengths[y] = length;
                        }
                        ++y;
                    }
                    ++x;
                }
                x = 0;
                while (x < rows.length) {
                    y = 0;
                    while (y < rows[x].getObjects().length) {
                        String text = rows[x].getText(y);
                        if (text != null && text != "") {
                            sb.append(String.format("%-" + this.maxLengths[y] + "s", text));
                        } else {
                            sb.append(String.format("%-1s", " "));
                        }
                        sb.append(" ");
                        ++y;
                    }
                    sb.append(HexUtil.LF);
                    ++x;
                }
            } else {
                int x = 0;
                while (x < rows.length) {
                    String text = rows[x].getText(0);
                    if (text != null) {
                        sb.append(text);
                    } else {
                        sb.append("");
                    }
                    sb.append(HexUtil.LF);
                    ++x;
                }
            }
            document = new Document(sb.toString());
        } else {
            document = new Document("");
        }
        this.setInput(document);
    }

    public void select(int line) {
        this.setTopIndex(line + 1);
        int end = this.getTopIndexStartOffset();
        this.setTopIndex(line);
        int start = this.getTopIndexStartOffset();
        this.setTopIndex(Math.max(line - 6, 0));
        this.setSelectedRange(start, end - start);
    }

    public void setHeader(String[] headerRows) {
        this.headerRows = headerRows;
        if (this.model != null) {
            this.setModel(this.model, this.tableFormat);
        }
    }
}

