/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.Constants;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DataViewRowModel;
import com.ca.mat.views.pages.AnalysisPageBasic;
import java.util.HashMap;

public class DataViewPage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID = "com.ca.mat.pages.dataview";
    public static final String SECTION_NAME = "DataView";
    private static final String VIEWER_MEMENTO_TYPE = "pages.dataview.viewer";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.dataview";
    static final String DEFAULT_AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.dataview.datasetdetails";
    private boolean linklist = false;
    private MATTableModel originalModel;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        AnalysisManager manager = Singletons.getAnalysisManager();
        this.originalModel = manager.getModel(this.dsn, SECTION_NAME, this.type);
        viewer.addColumn("DD name", 5, "  DD name", 1, true, false);
        viewer.addColumn("Dataset name", 6, "  Dataset name", 1, true, true);
        viewer.addColumn("Delay %", 4, "  Delay%", 9, true, true);
        viewer.addColumn("Block Size", 5, "Block Size", 2, true, true);
        viewer.addColumn("Record Length", 5, "Record Length", 2, true, true);
        viewer.addColumn("RECFM", 5, "  RECFM", 1, true, true);
        viewer.addColumn("EXCPs", 5, "  EXCPs", 2, true, true);
        viewer.addColumn("Connect Time", 5, "Connect Time", 2, true, true);
        viewer.addColumn("R/W", 2, "  R/W", 1, true, true);
        viewer.addColumn("DSORG", 5, "  DSORG", 1, true, true);
        viewer.addColumn("Access Method", 5, "Access Method", 1, true, true);
        viewer.addColumn("Buffer Number", 5, "Buffer Number", 2, true, true);
        viewer.addColumn("Number Extents", 3, "Number Extents", 2, true, true);
        viewer.addColumn("Alloc Unit", 5, "Alloc Unit", 1, true, true);
        viewer.addColumn("PRI Size", 5, "PRI Size", 2, true, true);
        viewer.addColumn("SEC Size", 5, "SEC Size", 2, true, true);
        viewer.addColumn("Seq Nr.", 5, "Seq Nr.", 2, true, true);
        viewer.addColumn("UCB Addr", 5, "UCB Addr", 1, true, true);
        viewer.addColumn("VOLSER(s)", 7, "  VOLSER(s)", 1, true, true);
        viewer.setSecondarySortColumn(0, 16);
        viewer.setDefaultSortColumn(0);
        viewer.setDefaultSortDirection(128);
        if (this.linklist) {
            this.setModel(this.originalModel);
        } else {
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("ddndet", new Object[]{"LINKLST", "LPALIB"});
            if (this.originalModel != null) {
                MATTableModel model = this.originalModel.filterBy(arguments, true, true);
                super.setModel(model);
            }
        }
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        this.setModel(model);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void setModel(MATTableModel newModel) {
        this.originalModel = newModel;
        if (this.linklist) {
            super.setModel(this.originalModel);
        } else {
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("ddndet", new Object[]{"LINKLST", "LPALIB"});
            if (this.originalModel != null) {
                MATTableModel model = this.originalModel.filterBy(arguments, true, true);
                super.setModel(model);
            }
        }
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        String commandId = DEFAULT_AUTONAV_COMMAND_ID;
        if (this.getViewer().getSelectedRows() != null && this.getViewer().getSelectedRows().length > 0) {
            DataViewRowModel row = (DataViewRowModel)this.getViewer().getSelectedRows()[0];
            if (Constants.getDataViewAutonavMapping().containsKey(row.getDDName())) {
                commandId = Constants.getDataViewAutonavMapping().get(row.getDDName());
            }
        }
        return commandId;
    }

    public boolean getLinklist() {
        return this.linklist;
    }

    public void setLinklist(boolean includeLinklist) {
        this.linklist = includeLinklist;
        if (this.linklist) {
            this.getViewer().setCATableModel(this.originalModel);
        } else {
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("ddndet", new Object[]{"LINKLST", "LPALIB"});
            if (this.originalModel != null) {
                MATTableModel model = this.originalModel.filterBy(arguments, true, true);
                this.getViewer().setCATableModel(model);
            }
        }
    }
}

