/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.Activator;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.handlers.AnalyzeHandler;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.CompareManager;
import com.ca.mat.managers.IAnalysisListener;
import com.ca.mat.managers.ICompareListener;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.IDMSViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.AnalysisView;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.IMATView;
import com.ca.mat.views.pages.AdabasPage;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.CodeView4GLPage;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.DB2Page;
import com.ca.mat.views.pages.DashboardPage;
import com.ca.mat.views.pages.DataViewPage;
import com.ca.mat.views.pages.DatacomPage;
import com.ca.mat.views.pages.DelayViewPage;
import com.ca.mat.views.pages.EmptyPage;
import com.ca.mat.views.pages.IDMSPage;
import com.ca.mat.views.pages.IMSPage;
import com.ca.mat.views.pages.IPageWithModes;
import com.ca.mat.views.pages.JVMPage;
import com.ca.mat.views.pages.LinkPage;
import com.ca.mat.views.pages.LogPage;
import com.ca.mat.views.pages.ModViewPage;
import com.ca.mat.views.pages.OverViewReportPage;
import com.ca.mat.views.pages.PageWithModesContainer;
import com.ca.mat.views.pages.PoolViewPage;
import com.ca.mat.views.pages.TaskViewPage;
import com.ca.mat.views.pages.TimeViewPage;
import com.ca.mat.views.pages.TranViewPage;
import com.ca.mat.views.pages.USSViewPage;
import com.ca.mat.views.pages.WASViewPage;
import com.ca.mat.views.subpages.IMSDBDDetailSubpage;
import com.ca.mat.views.subpages.IMSStatementSubpage;
import com.ca.mat.views.subpages.QueueManagerActivitySubpage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AnalysisTabbedView
extends AnalysisView
implements IAnalysisListener,
ICompareListener,
IMATView {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID = "com.ca.mat.views.analysistabbedview";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.analysisview";
    private static final String DATA_LOADING_MESSAGE = "Loading analysis data, please wait..";
    private static final String DATA_CANCELED_MESSAGE = "Analysis data request canceled.";
    private static final String DATA_ERROR_MESSAGE = "Error loading analysis data.";
    private static final String NO_DATA_MESSAGE = "No data available";
    private static final String NOT_IN_LOCAL_MESSAGE = "Data not present in local file";
    private static final String IMS_BATCH_MESSAGE = "No IMS transactions available, IMS has been used in batch only.";
    private TabFolder tabFolder;
    private Composite typeSwitcher;
    private Map<String, AnalysisPage> pages = new HashMap<String, AnalysisPage>();
    private Map<String, TabItem> pageButtons = new HashMap<String, TabItem>();
    private Map<Integer, Button> typeButtons = new HashMap<Integer, Button>();
    private AnalysisPage initialPage = null;
    private EmptyPage loadingDataPage = null;
    private LinkPage canceledDataPage = null;
    private LinkPage errorDataPage = null;
    private LinkPage notInLocalPage = null;
    private EmptyPage noDataPage = null;
    private Button compareButton;
    private static final String TITLE = "CA Mainframe Application Tuner";

    @Override
    public void setDSN(String dsn) {
        this.dsn = dsn;
        Singletons.getAnalysisManager().addAnalysisListener(this, this.dsn);
        if (dsn.endsWith(".xml")) {
            dsn = dsn.replace(".xml", "");
        }
        this.setPartName(String.format("Analysis: %s", dsn));
    }

    @Override
    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(new IPartListener(){
            private IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            private Shell activeShell = this.activeWindow.getShell();
            private String currentTitle = this.activeShell.getText();

            public void partOpened(IWorkbenchPart part) {
                this.setTitle();
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                this.setTitle();
            }

            public void partActivated(IWorkbenchPart part) {
                this.setTitle();
            }

            private void setTitle() {
                IWorkbenchPart activePart = this.activeWindow.getPartService().getActivePart();
                if (activePart != null && this.currentTitle.endsWith(AnalysisTabbedView.TITLE)) {
                    if (activePart.getTitle().isEmpty()) {
                        this.activeShell.setText(AnalysisTabbedView.TITLE);
                    } else {
                        this.activeShell.setText(String.valueOf(activePart.getTitle()) + "-" + AnalysisTabbedView.TITLE);
                    }
                }
            }
        });
        String secondaryId = this.getViewSite().getSecondaryId();
        String[] parts = secondaryId.split("/");
        this.setDSN(parts[1]);
        this.setProfile(parts[0]);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        parent.setLayout((Layout)layout);
        this.buildToolbar(parent);
        if (Activator.plugin.hasRAPFragment()) {
            this.buildTypeSwitcher(parent);
            super.createPartControl(parent, false);
            this.tabFolder.setLayoutData((Object)new GridData(4, 0, true, false));
        } else {
            this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            this.buildTypeSwitcher((Composite)this.tabFolder);
            super.createPartControl((Composite)this.tabFolder, false);
        }
        this.fillToolbar();
        this.showPage(this.initialPage, true);
        IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
        help.setHelp(this.initialPage.getControl(), this.initialPage.getContextHelpId());
        CompareManager cManager = Singletons.getCompareManager();
        cManager.addCompareListener(this);
        if (cManager.getCompare()) {
            this.pageChanged(cManager.getModelName(), null);
            this.typeChanged(cManager.getType());
        }
        this.updateTitle();
    }

    private void buildTypeSwitcher(Composite parent) {
        this.typeSwitcher = new Composite(parent, 0);
        this.typeSwitcher.setLayout((Layout)new RowLayout());
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        this.typeSwitcher.setLayoutData((Object)gridData2);
        this.addAnalysisType("All", 1, true);
        this.addAnalysisType("Normal", 0, false);
        this.addAnalysisType("Active", 2, false);
        this.addAnalysisType("Wait", 3, false);
        this.addSyncButton();
    }

    private void setHeaderVisibility(boolean visible) {
        this.typeSwitcher.setVisible(visible);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.exclude = !visible;
        this.typeSwitcher.setLayoutData((Object)gridData);
        this.subTitleLabel.setVisible(visible);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.exclude = !visible;
        this.subTitleLabel.setLayoutData((Object)gridData);
        this.subTitleLabel.getParent().layout();
    }

    private void addAnalysisType(String title, final int type, boolean selected) {
        final Button button = new Button(this.typeSwitcher, 16);
        button.setText(title);
        this.typeButtons.put(type, button);
        button.setSelection(selected);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Singletons.getCompareManager().typeChanged(type);
                if (button.getSelection()) {
                    AnalysisTabbedView.this.typeChanged(type);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addSyncButton() {
        this.compareButton = new Button(this.typeSwitcher, 32);
        this.compareButton.setText("Compare");
        this.compareButton.setSelection(Singletons.getCompareManager().getCompare());
        this.compareButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean compare = AnalysisTabbedView.this.compareButton.getSelection();
                Singletons.getCompareManager().setCompare(compare);
                if (compare) {
                    String pageId;
                    String currentModeTarget = null;
                    String currentModeActual = null;
                    if (AnalysisTabbedView.this.getActivePage() instanceof IPageWithModes) {
                        pageId = ((IPageWithModes)((Object)AnalysisTabbedView.this.getActivePage())).getRootId();
                        currentModeTarget = ((IPageWithModes)((Object)AnalysisTabbedView.this.getActivePage())).getCurrentMode();
                    } else {
                        pageId = AnalysisTabbedView.this.getActivePage().getId();
                    }
                    Singletons.getCompareManager().typeChanged(AnalysisTabbedView.this.analysisType);
                    if (AnalysisTabbedView.this.getActivePage() != null) {
                        for (Map.Entry entry : AnalysisTabbedView.this.pages.entrySet()) {
                            String candidate;
                            AnalysisPage entryPage = (AnalysisPage)entry.getValue();
                            if (entryPage instanceof IPageWithModes) {
                                candidate = ((IPageWithModes)((Object)entryPage)).getRootId();
                                currentModeActual = ((IPageWithModes)((Object)entryPage)).getCurrentMode();
                            } else {
                                candidate = ((AnalysisPage)entry.getValue()).getId();
                            }
                            if (!candidate.equals(pageId)) continue;
                            AnalysisPage result = currentModeTarget != null && currentModeActual != null && !currentModeActual.equals(currentModeTarget) ? ((IPageWithModes)((Object)AnalysisTabbedView.this.getActivePage())).changeMode(currentModeTarget).getAnalysisPage() : AnalysisTabbedView.this.getActivePage();
                            Singletons.getCompareManager().pageChanged((String)entry.getKey(), result);
                            break;
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void buildToolbar(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        this.tabFolder.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.tabFolder.setLayoutData((Object)gridData);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell;
                TabItem tab = (TabItem)e.item;
                if (tab.getText().isEmpty()) {
                    return;
                }
                String title = tab.getText();
                AnalysisPage page = (AnalysisPage)AnalysisTabbedView.this.pages.get(title);
                AnalysisTabbedView.this.pageChanged(title, null);
                Singletons.getAnalysisManager().analysisPageFocused(AnalysisTabbedView.this.getCurrentPage());
                Singletons.getCompareManager().pageChanged(title, null);
                String partTitle = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart().getTitle();
                IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
                help.setHelp(page.getControl(), page.getContextHelpId());
                IViewPart helpView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.help.ui.HelpView");
                if (helpView != null) {
                    help.displayHelp(page.getContextHelpId());
                }
                if ((activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).getText().endsWith(AnalysisTabbedView.TITLE)) {
                    activeShell.setText(String.valueOf(title) + " view" + "-" + partTitle + "-" + AnalysisTabbedView.TITLE);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void fillToolbar() {
        MATTableModel model;
        AnalysisPage page;
        this.loadingDataPage = new EmptyPage();
        this.addPage(this.loadingDataPage, true);
        this.loadingDataPage.setMessage(DATA_LOADING_MESSAGE);
        final Shell shell = this.getSite().getShell();
        this.canceledDataPage = new LinkPage(DATA_CANCELED_MESSAGE);
        this.canceledDataPage.addLinkButton("Retry", new Runnable(){

            @Override
            public void run() {
                new AnalyzeHandler().analyze(AnalysisTabbedView.this.profile, AnalysisTabbedView.this.dsn, AnalysisTabbedView.this.analysisType, shell, false);
            }
        });
        this.addPage(this.canceledDataPage, true);
        this.errorDataPage = new LinkPage(DATA_ERROR_MESSAGE);
        this.errorDataPage.addLinkButton("Retry", new Runnable(){

            @Override
            public void run() {
                new AnalyzeHandler().analyze(AnalysisTabbedView.this.profile, AnalysisTabbedView.this.dsn, AnalysisTabbedView.this.analysisType, shell, false);
            }
        });
        this.addPage(this.errorDataPage, true);
        this.noDataPage = new EmptyPage();
        this.addPage(this.noDataPage, true);
        this.noDataPage.setMessage(NO_DATA_MESSAGE);
        this.notInLocalPage = new LinkPage(NOT_IN_LOCAL_MESSAGE);
        this.notInLocalPage.addLinkButton("Get from Server", new Runnable(){

            @Override
            public void run() {
                new AnalyzeHandler().analyze(AnalysisTabbedView.this.profile, AnalysisTabbedView.this.dsn, AnalysisTabbedView.this.analysisType, shell, false);
            }
        });
        this.addPage(this.notInLocalPage, true);
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "TimeView")) {
            page = new DashboardPage();
            this.initialPage = page;
            this.addPage(page, true);
            this.addToolbarButton("Dashboard", page);
            this.tabFolder.setSelection(this.pageButtons.get("Dashboard"));
        }
        page = new OverViewReportPage();
        if (this.initialPage == null) {
            this.initialPage = page;
        }
        this.addPage(page, true);
        this.addToolbarButton("Overview", page);
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "TaskView")) {
            page = new TaskViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Task", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "TimeView")) {
            page = new DelayViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Delay", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "TimeView")) {
            CodeViewPage codeViewpage = new CodeViewPage();
            codeViewpage.setModeType(CodeViewRowModel.TYPE_CSECT);
            this.addPage(codeViewpage, false);
            this.addToolbarButton("Code", codeViewpage);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "TimeView")) {
            page = new TimeViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Time", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "DataView")) {
            page = new DataViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Data", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "TranView")) {
            page = new TranViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Tran", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "ModView")) {
            page = new ModViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Modules", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "BufferPoolTotals")) {
            page = new PoolViewPage();
            this.addPage(page, false);
            this.addToolbarButton("Pool", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "USSView Functions")) {
            page = new USSViewPage();
            ((USSViewPage)page).setContextRestrictions((USSViewPage)page.new USSViewPage.USSContextRestrictions());
            this.addPage(page, false);
            this.addToolbarButton("USS", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "DB2 View")) {
            page = new DB2Page();
            this.addPage(page, false);
            this.addToolbarButton("DB2", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "ADABAS Statements")) {
            page = new AdabasPage();
            this.addPage(page, false);
            this.addToolbarButton("Adabas", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "DATACOM Statements")) {
            page = new DatacomPage();
            this.addPage(page, false);
            this.addToolbarButton("Datacom", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "CodeView Mode-4GL") && (model = Singletons.getAnalysisManager().getModel(this.dsn, "CodeView Mode-4GL", 1)) != null) {
            if (model.contains("xlang", "IDEAL")) {
                page = new CodeView4GLPage();
                ((CodeView4GLPage)page).setLanguage("IDEAL");
                this.addPage(page, false);
                this.addToolbarButton("Ideal", page);
            }
            if (model.contains("xlang", "NATURAL")) {
                page = new CodeView4GLPage();
                ((CodeView4GLPage)page).setLanguage("NAT");
                this.addPage(page, false);
                this.addToolbarButton("Natural", page);
            }
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "IDMS Delays")) {
            page = new IDMSPage();
            this.addPage(page, false);
            this.addToolbarButton("IDMS", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "IMS TranNameView")) {
            page = new IMSPage();
            this.addPage(page, false);
            this.addToolbarButton("IMS", page);
        } else if (Singletons.getAnalysisManager().hasModel(this.dsn, "IMS Statements")) {
            LinkPage linkPage = new LinkPage(IMS_BATCH_MESSAGE);
            final AnalysisTabbedView inst = this;
            linkPage.addLinkButton("Show IMS Statements", new Runnable(){

                @Override
                public void run() {
                    String section = "IMS Statements";
                    MATTableModel model = Singletons.getAnalysisManager().getModel(AnalysisTabbedView.this.dsn, section, AnalysisTabbedView.this.getAnalysisType());
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSStatementSubpage.class, section, AnalysisTabbedView.this.getDSN(), AnalysisTabbedView.this.getAnalysisType(), inst, "com.ca.mat.help.imsstatement", model);
                    detachedView.setPresentationName("IMS Statements");
                }
            });
            linkPage.addLinkButton("Show IMS DBD Details", new Runnable(){

                @Override
                public void run() {
                    String section = "IMS Statements";
                    MATTableModel model = Singletons.getAnalysisManager().getModel(AnalysisTabbedView.this.dsn, section, AnalysisTabbedView.this.getAnalysisType());
                    if (model != null) {
                        model = AnalysisUtils.aggregateDBD(model, AnalysisTabbedView.this.dsn);
                    }
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(IMSDBDDetailSubpage.class, section, AnalysisTabbedView.this.getDSN(), AnalysisTabbedView.this.getAnalysisType(), inst, "com.ca.mat.help.imsstatement", model);
                    detachedView.setPresentationName("IMS DBD Details");
                }
            });
            page = linkPage;
            this.addPage(page, false);
            this.addToolbarButton("IMS", page);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "JVM Information")) {
            JVMPage jvmPage = new JVMPage();
            jvmPage.setModeType("display_mode_process");
            jvmPage.setModeAggregate("group_by_process");
            jvmPage.setModeSubtype("data_mode_application");
            this.addPage(jvmPage, false);
            this.addToolbarButton("JVM", jvmPage);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "WAS Tran Stats")) {
            WASViewPage waspage = new WASViewPage();
            waspage.setModeType("display_mode_url");
            waspage.setModeAggregate("group_by_tran");
            this.addPage(waspage, false);
            this.addToolbarButton("Java", waspage);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "MQ Series Activity")) {
            QueueManagerActivitySubpage mqpage = new QueueManagerActivitySubpage();
            this.addPage(mqpage, false);
            this.addToolbarButton("MQ", mqpage);
        }
        if (Singletons.getAnalysisManager().hasModel(this.dsn, "LogMessages")) {
            page = new LogPage();
            this.addPage(page, false);
            this.addToolbarButton("Log", page);
        }
    }

    public void addToolbarButton(String title, AnalysisPage page) {
        TabItem tab = new TabItem(this.tabFolder, 0);
        tab.setText(title);
        tab.setData("org.eclipse.rap.rwt.customVariant", (Object)"toolbarButton");
        this.pageButtons.put(title, tab);
        this.pages.put(title, page);
    }

    @Override
    public String getDSN() {
        return this.dsn;
    }

    public AnalysisPage getPage(String key) {
        return this.pages.get(key);
    }

    public TabItem getSelectedTab() {
        return this.tabFolder.getSelection().length > 0 ? this.tabFolder.getSelection()[0] : null;
    }

    private void setSelectedTab(TabItem item) {
        this.tabFolder.setSelection(item);
    }

    @Override
    public void dispose() {
        Singletons.getCompareManager().removeCompareListener(this);
        Singletons.getAnalysisManager().removeAnalysisListener(this, this.dsn);
        for (AnalysisPage page : this.pages.values()) {
            page.dispose();
        }
        this.pages.clear();
        this.pageButtons.clear();
        this.typeButtons.clear();
        super.dispose();
    }

    public static boolean anyOpen() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = activeWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] references;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = references = page.getViewReferences();
            int n3 = references.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference viewRef = iViewReferenceArray[n4];
                String id = viewRef.getId();
                if (id.equals(ID) || id.startsWith("com.ca.mat.views.analysistabbedview:")) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void analysisChanged(String DSN) {
        this.showBusy(false);
        int state = Singletons.getAnalysisManager().getAnalysisState(this.dsn, this.analysisType);
        switch (state) {
            case 1: {
                this.showPage(this.loadingDataPage);
                break;
            }
            case 3: {
                this.showPage(this.canceledDataPage);
                break;
            }
            case 666: {
                this.showPage(this.errorDataPage);
                break;
            }
            case 0: {
                this.showPage(this.noDataPage);
                break;
            }
            case 21: {
                this.showPage(this.noDataPage);
                break;
            }
            case 4: {
                this.showPage(this.notInLocalPage);
                break;
            }
            case 5: {
                this.showPage(this.loadingDataPage);
                break;
            }
            case 2: {
                AnalysisPage pageToShow = this.getActivePage();
                if (pageToShow instanceof EmptyPage || pageToShow instanceof LinkPage) {
                    for (Map.Entry<String, TabItem> entry : this.pageButtons.entrySet()) {
                        if (!entry.getValue().equals(this.getSelectedTab())) continue;
                        pageToShow = this.pages.get(entry.getKey());
                        pageToShow.setType(this.analysisType);
                    }
                }
                this.showPage(pageToShow, true);
                this.updateTitle();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown analysis state: " + state);
            }
        }
    }

    private void showPage(AnalysisPage pageToPrepare, boolean typeChanged) {
        AnalysisPageBasic page;
        MATTableModel model;
        super.showPage(pageToPrepare);
        this.setHeaderVisibility(true);
        if (typeChanged) {
            pageToPrepare.setType(this.analysisType);
        }
        if (pageToPrepare instanceof DashboardPage) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "DelayViewCalculated", 1);
            if (model == null) {
                model = Singletons.getAnalysisManager().getModel(this.dsn, "TimeView", 1);
                model = AnalysisUtils.calculateDelayView(model, this.dsn, this.analysisType);
                Singletons.getAnalysisManager().put(this.dsn, "DelayViewCalculated", model, 1);
            }
            ((DashboardPage)pageToPrepare).setProfile(this.profile);
            ((DashboardPage)pageToPrepare).setModel(model);
            this.setHeaderVisibility(false);
        }
        if (pageToPrepare instanceof CodeViewPage && ((CodeViewPage)pageToPrepare).getModel() != null) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "Code View", this.analysisType);
            CodeViewPage codePage = (CodeViewPage)pageToPrepare;
            if (model == null) {
                model = Singletons.getAnalysisManager().getModel(this.dsn, "TimeView", this.analysisType);
                model = AnalysisUtils.calculateCodeView(model, this.dsn, this.analysisType);
                Singletons.getAnalysisManager().put(this.dsn, "Code View", model, this.analysisType);
            }
            if (codePage.getModeType() != CodeViewRowModel.TYPE_CSECT) {
                model = AnalysisUtils.changeCodeViewMode(model, codePage.getModeType(), this.getDSN());
            }
            codePage.setModel(model);
        } else if (pageToPrepare instanceof DelayViewPage) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "DelayViewCalculated", this.analysisType);
            if (model == null) {
                model = Singletons.getAnalysisManager().getModel(this.dsn, "TimeView", this.analysisType);
                model = AnalysisUtils.calculateDelayView(model, this.dsn, this.analysisType);
                Singletons.getAnalysisManager().put(this.dsn, "DelayViewCalculated", model, this.analysisType);
            }
            ((DelayViewPage)pageToPrepare).setModel(model);
        } else if (pageToPrepare instanceof JVMPage) {
            page = (JVMPage)pageToPrepare;
            String modeType = ((JVMPage)page).getModeType();
            MATTableModel model2 = Singletons.getAnalysisManager().getModel(this.dsn, "JVM Information", this.analysisType);
            if (((JVMPage)pageToPrepare).getModel().isEmpty()) {
                if (modeType == null || modeType.equals("display_mode_process")) {
                    model2 = AnalysisUtils.aggregateJVM(model2, "group_by_process", "data_mode_application", "display_mode_process", this.dsn);
                    ((JVMPage)page).setModeAggregate("group_by_process");
                    ((JVMPage)page).setModeSubtype("data_mode_application");
                    ((JVMPage)page).setModeType("display_mode_process");
                } else {
                    String modeSubtype = ((JVMPage)page).getModeSubtype();
                    model2 = AnalysisUtils.aggregateJVM(model2, "group_by_method", modeSubtype, "display_mode_app", this.dsn);
                    ((JVMPage)page).setModeAggregate("group_by_method");
                }
                ((JVMPage)pageToPrepare).setModel(model2);
            }
            ((JVMPage)pageToPrepare).setModelLocation("JVM Information");
        } else if (pageToPrepare instanceof WASViewPage) {
            String location;
            page = (WASViewPage)pageToPrepare;
            String modeType = ((WASViewPage)page).getModeType();
            String string = location = modeType.equals("display_mode_url") ? "WAS Tran Stats" : "WAS Tran Delay";
            if (((WASViewPage)this.getActivePage()).getModel().isEmpty()) {
                MATTableModel model3 = Singletons.getAnalysisManager().getModel(this.dsn, location, this.analysisType);
                if (modeType.equals("display_mode_appl") || modeType.equals("display_mode_curr") || modeType.equals("display_mode_via")) {
                    model3 = AnalysisUtils.aggregateWAS(model3, "group_by_class_method_line", ((WASViewPage)page).getModeSubtype(), "display_mode_class", this.dsn);
                }
                ((WASViewPage)this.getActivePage()).setModel(model3);
            }
            ((WASViewPage)this.getActivePage()).setModelLocation(location);
        } else if (pageToPrepare instanceof IDMSPage) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "IDMS Delays", this.analysisType);
            String modeType = ((IDMSPage)pageToPrepare).getModeType();
            if (modeType == null) {
                modeType = IDMSViewRowModel.TYPE_MODULE;
            }
            model = AnalysisUtils.changeIDMSModel(model, modeType, this.dsn);
            if (((IDMSPage)this.getActivePage()).getModel().isEmpty()) {
                ((IDMSPage)pageToPrepare).setModel(model);
            }
        } else if (pageToPrepare instanceof USSViewPage) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "USSView Functions Calculated", this.analysisType);
            if (model == null) {
                model = Singletons.getAnalysisManager().getModel(this.dsn, "TimeView", this.analysisType);
                model = AnalysisUtils.calculateUSSView(model, this.dsn, this.analysisType);
                Singletons.getAnalysisManager().put(this.dsn, "USSView Functions Calculated", model, this.analysisType);
            }
            ((USSViewPage)pageToPrepare).setModel(model);
        } else if (pageToPrepare instanceof QueueManagerActivitySubpage) {
            model = Singletons.getAnalysisManager().getModel(this.dsn, "MQ Series Activity", this.analysisType);
            ((QueueManagerActivitySubpage)pageToPrepare).setModel(model);
        }
    }

    @Override
    public void compareChanged(boolean sync) {
        if (!this.compareButton.isDisposed()) {
            this.compareButton.setSelection(sync);
        }
    }

    @Override
    public void pageChanged(String tabPageName, AnalysisPage pageToCopy) {
        if (this.getActivePage() != null && this.getActivePage().equals(this.pages.get(tabPageName)) && !(this.getActivePage() instanceof IPageWithModes)) {
            return;
        }
        AnalysisPage page = this.pages.get(tabPageName);
        if (page == null) {
            page = this.noDataPage;
        }
        TabItem tab = this.pageButtons.get(tabPageName);
        boolean typeChanged = page.getType() != this.analysisType;
        int state = Singletons.getAnalysisManager().getAnalysisState(this.dsn, this.analysisType);
        if (page instanceof LogPage && Singletons.getAnalysisManager().getModel(this.dsn, "LogMessages", 1) == null) {
            state = 21;
        }
        switch (state) {
            case 1: {
                this.showPage(this.loadingDataPage);
                break;
            }
            case 3: {
                this.showPage(this.canceledDataPage);
                break;
            }
            case 666: {
                this.showPage(this.errorDataPage);
                break;
            }
            case 0: {
                this.showPage(this.noDataPage);
                break;
            }
            case 21: {
                this.showPage(this.noDataPage);
                break;
            }
            case 4: {
                this.showPage(this.notInLocalPage);
                break;
            }
            case 5: {
                this.showPage(this.loadingDataPage);
                break;
            }
            case 2: {
                page.setType(this.analysisType);
                if (pageToCopy != null && page instanceof IPageWithModes && pageToCopy instanceof IPageWithModes) {
                    page = ((IPageWithModes)((Object)page)).changeMode(((IPageWithModes)((Object)pageToCopy)).getCurrentMode()).getAnalysisPage();
                }
                this.showPage(page, typeChanged);
            }
        }
        this.updateTitle();
        if (tab != null) {
            this.setSelectedTab(tab);
            this.setFocus();
        } else {
            this.tabFolder.setSelection(new TabItem[0]);
        }
        this.requestRefresh();
    }

    @Override
    public void modeChanged(String newModeIdentifier) {
        AnalysisPage pageToPrepare = this.getActivePage();
        if (!(pageToPrepare instanceof IPageWithModes)) {
            return;
        }
        PageWithModesContainer pageContainer = ((IPageWithModes)((Object)pageToPrepare)).changeMode(newModeIdentifier);
        this.addPage(pageContainer.getAnalysisPage(), true);
        ((IPageWithModes)((Object)pageContainer.getAnalysisPage())).setModel(pageContainer.getModel());
        this.showPage(pageContainer.getAnalysisPage());
        this.requestRefresh();
    }

    @Override
    public void typeChanged(int type) {
        if (this.analysisType == type) {
            return;
        }
        Button button = this.typeButtons.get(type);
        this.analysisType = type;
        int state = Singletons.getAnalysisManager().getAnalysisState(this.dsn, this.analysisType);
        if (this.getActivePage() instanceof LogPage && Singletons.getAnalysisManager().getModel(this.dsn, "LogMessages", 1) == null) {
            state = 21;
        }
        switch (state) {
            case 1: {
                if (!Singletons.getAnalysisManager(this.getCurrentPage().getControl().getShell().getDisplay()).hasRunningJobs(this.dsn)) {
                    new AnalyzeHandler().analyze(this.profile, this.dsn, type, this.getCurrentPage().getControl().getShell(), false);
                }
                this.showPage(this.loadingDataPage);
                break;
            }
            case 3: {
                this.showPage(this.noDataPage);
                new AnalyzeHandler().analyze(this.profile, this.dsn, type, this.getCurrentPage().getControl().getShell(), false);
                break;
            }
            case 666: {
                this.showPage(this.errorDataPage);
                break;
            }
            case 0: {
                this.showPage(this.noDataPage);
                new AnalyzeHandler().analyze(this.profile, this.dsn, type, this.getCurrentPage().getControl().getShell(), false);
                break;
            }
            case 21: {
                this.showPage(this.noDataPage);
                break;
            }
            case 4: {
                this.showPage(this.notInLocalPage);
                break;
            }
            case 5: {
                this.showPage(this.loadingDataPage);
                break;
            }
            case 2: {
                AnalysisPage pageToShow = this.getActivePage();
                if (pageToShow instanceof EmptyPage || pageToShow instanceof LinkPage) {
                    for (Map.Entry<String, TabItem> entry : this.pageButtons.entrySet()) {
                        if (!entry.getValue().equals(this.getSelectedTab())) continue;
                        pageToShow = this.pages.get(entry.getKey());
                    }
                }
                this.getActivePage().setType(type);
                this.showPage(pageToShow, true);
                this.updateTitle();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown analysis state: " + state);
            }
        }
        for (Button b : this.typeButtons.values()) {
            b.setSelection(false);
        }
        button.setSelection(true);
        this.requestRefresh();
    }

    @Override
    public Display getDisplay() {
        return this.tabFolder.getDisplay();
    }

    @Override
    protected final void updateTitle() {
        String additionalText;
        if (this.getActivePage() instanceof AnalysisPageBasic) {
            additionalText = ((AnalysisPageBasic)this.getActivePage()).getAdditionalTitleText();
            if (!additionalText.isEmpty()) {
                additionalText = ", " + additionalText;
            }
        } else {
            additionalText = "";
        }
        String subTitleText = String.format("Analysis for: %1$s DSN: %2$s%3$s", this.profile, this.dsn.replace(".xml", ""), additionalText);
        this.subTitleLabel.setText(subTitleText);
    }
}

