/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.utils;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.CertificateException;

public class KeystoreUtil {
    private static final String trustStorePathVariable = "ca.security.truststore";
    private static final String trustStoreTypeVariable = "ca.security.truststore.type";
    private static final String configurationFile = "/conf/sslConfig.ini";
    private static final String windowsJavaTrustStore = "\\lib\\security\\cacerts";
    private static final String linuxJavaTrustStore = "/lib/security/cacerts";
    private static final String javaHome = "java.home";
    private static final String catalinaBaseName = "catalina.base";
    private Logger log;
    private KeyStore trustStore;

    public KeystoreUtil(Logger log) {
        this.log = log;
    }

    protected String getConfigurationFilePath() {
        String SSLMetadataFilePath = null;
        String catalinaBase = System.getProperty(catalinaBaseName);
        SSLMetadataFilePath = String.valueOf(catalinaBase) + configurationFile;
        return SSLMetadataFilePath;
    }

    protected String getTrustStorePath() {
        String temp = System.getProperty(javaHome);
        String path = temp.contains("\\") ? String.valueOf(temp) + windowsJavaTrustStore : String.valueOf(temp) + linuxJavaTrustStore;
        return path;
    }

    protected String getTrustStorePath(String configurationFilePath) {
        String keyringPath = null;
        File file = new File(configurationFilePath);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            Properties configurationFile = new Properties();
            configurationFile.load(reader);
            keyringPath = configurationFile.getProperty(trustStorePathVariable);
            if (keyringPath.equalsIgnoreCase("")) {
                throw new MATException(Messages.sslConfigFileIsEmpty);
            }
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.SEVERE, Messages.sslConfigFileDoesNotExist, e);
        }
        catch (NullPointerException e) {
            this.log.log(Level.SEVERE, Messages.sslConfigTruststorePathNotFound, e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return keyringPath;
    }

    protected String getTrustStoreType(String configurationFilePath) {
        String keystoreType = null;
        File file = new File(configurationFilePath);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            Properties configurationFile = new Properties();
            configurationFile.load(reader);
            keystoreType = configurationFile.getProperty(trustStoreTypeVariable);
            if (keystoreType.equalsIgnoreCase("")) {
                throw new MATException(Messages.sslConfigFileIsEmpty);
            }
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.SEVERE, Messages.sslConfigFileDoesNotExist, e);
        }
        catch (NullPointerException e) {
            this.log.log(Level.SEVERE, Messages.sslConfigTruststoreTypeNotFound, e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return keystoreType;
    }

    public SSLSocketFactory createSocketFactory() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException, ClassNotFoundException {
        block8: {
            String trustStorePath;
            if (Activator.plugin.hasRAPFragment()) {
                trustStorePath = this.getTrustStorePath(this.getConfigurationFilePath());
                String trustStoreType = this.getTrustStoreType(this.getConfigurationFilePath());
                try {
                    if (trustStoreType.equalsIgnoreCase("JCERACFKS") || trustStoreType.equalsIgnoreCase("JCECCARACFKS")) {
                        this.loadESMKeystoreFile(trustStoreType, trustStorePath);
                        break block8;
                    }
                    this.loadJKSKeystoreFile(trustStoreType, trustStorePath);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            } else if (Activator.plugin.hasEclipseFragment()) {
                trustStorePath = this.getTrustStorePath();
                try {
                    this.loadJKSKeystoreFile(trustStorePath);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.trustStore);
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, tmf.getTrustManagers(), null);
        SSLSocketFactory sslFactory = ctx.getSocketFactory();
        return sslFactory;
    }

    private void loadJKSKeystoreFile(String type, String path) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, ClassNotFoundException {
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fis = null;
        fis = new FileInputStream(this.getTrustStorePath());
        try {
            this.trustStore.load(fis, null);
        }
        catch (java.security.cert.CertificateException e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void loadJKSKeystoreFile(String path) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, ClassNotFoundException {
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fis = null;
        fis = new FileInputStream(this.getTrustStorePath());
        try {
            this.trustStore.load(fis, null);
        }
        catch (java.security.cert.CertificateException e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void loadESMKeystoreFile(String type, String path) throws IOException {
        if (type.equals("JCERACFKS") || type.equals("JCECCARACFKS")) {
            InputStream stream = null;
            try {
                this.trustStore = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            this.log.fine("KeyStore file name is: " + path);
            try {
                URL url = new URL(null, path);
                this.log.finer("URL  is " + url.toString());
                try {
                    stream = url.openStream();
                }
                catch (Throwable t) {
                    this.log.severe(t.getMessage());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            try {
                this.log.finer("Loading the keystore");
                this.trustStore.load(stream, null);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (java.security.cert.CertificateException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            this.log.fine("keyStore instance is " + this.trustStore.toString());
        }
    }
}

