/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dialogs;

import com.ca.mat.Activator;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.AnalysisTabbedView;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.subpages.TextDisplaySubpage;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuSeparatorImpl;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class AnalysisPageDialog
extends TrayDialog
implements IAnalysisSubpagePresentation,
ISelectionChangedListener {
    String dsn;
    int analysisType;
    AnalysisPage activePage;
    Composite viewArea;
    Label subTitleLabel;
    String fixedSubtitle;
    protected String profile;
    private MenuManager menuMgr;
    private IAnalysisPagePresentation parent;

    public AnalysisPageDialog() {
        this(null);
    }

    public AnalysisPageDialog(Shell shell) {
        super(shell);
        this.setShellStyle(1104);
    }

    public boolean isDialog() {
        return false;
    }

    public Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createToolbar(parent);
        this.viewArea = new Composite(parent, 4);
        this.viewArea.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        gData.horizontalIndent = 0;
        gData.verticalIndent = 0;
        this.viewArea.setLayoutData((Object)gData);
        this.buildContextMenu();
        return this.viewArea;
    }

    public void createToolbar(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(4, 128, true, false);
        wrapper.setLayoutData((Object)gData);
        this.subTitleLabel = new Label(wrapper, 4);
        gData = new GridData(4, 128, true, false);
        gData.horizontalIndent = 5;
        gData.verticalIndent = 0;
        this.subTitleLabel.setLayoutData((Object)gData);
        this.subTitleLabel.setVisible(false);
        gData = new GridData(131072, 128, false, false);
        final ToolBar bar = new ToolBar(wrapper, 0);
        gData = new GridData(131072, 128, false, false);
        bar.setLayoutData((Object)gData);
        bar.setLayout((Layout)new FillLayout(131072));
        final ToolItem viewMenuItem = new ToolItem(bar, 8);
        viewMenuItem.setImage(Activator.plugin.getImageRegistry().get("com.ca.mat.plugin.menu"));
        viewMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Singletons.getAnalysisManager((Display)viewMenuItem.getDisplay()).analysisPageFocused(AnalysisPageDialog.this.getActivePage());
                AnalysisPageDialog.this.setGlobalSelection(AnalysisPageDialog.this.getActivePage().getSelectionProvider().getSelection());
                Rectangle bounds = viewMenuItem.getBounds();
                Point menuLocation = viewMenuItem.getDisplay().map((Control)bar, null, new Point(bounds.x, bounds.y + bounds.height));
                IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
                MenuManager manager = new MenuManager("menu", "menu:com.ca.mat.views.analysisdetachedview?after=additions");
                menuService.populateContributionManager((ContributionManager)manager, "menu:com.ca.mat.views.analysisdetachedview?after=additions");
                if (manager.getItems().length == 0) {
                    AnalysisPageDialog.this.buildContextMenuE42(manager);
                    AnalysisPageDialog.this.updateContextMenuE42((IMenuManager)manager);
                }
                Menu context = manager.createContextMenu((Control)AnalysisPageDialog.this.getShell());
                int i = 0;
                IContributionItem[] iContributionItemArray = manager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.fill(context, i);
                    ++i;
                    ++n2;
                }
                context.setLocation(menuLocation);
                context.setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    public IAnalysisSubpagePresentation showDetachedPage(Class pageClass, String modelName, String dsn, int type, IAnalysisPagePresentation parent, String contextHelpId, MATTableModel externalModel, boolean deferPageFocus) {
        int y;
        AnalysisPageDialog dialog = new AnalysisPageDialog(parent.getActivePage().getControl().getShell());
        dialog.create();
        dialog.setDSN(dsn);
        dialog.setAnalysisType(type);
        dialog.setParent(parent);
        dialog.setProfile(parent.getProfile());
        dialog.updateTitle();
        dialog.setBlockOnOpen(false);
        MATTableModel model = externalModel;
        if (model == null) {
            model = Singletons.getAnalysisManager().getModel(dsn, modelName, type);
        }
        if (model != null) {
            try {
                TextDisplaySubpage textPage;
                AnalysisPageBasic basicPage;
                AnalysisPage page = (AnalysisPage)pageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (page instanceof AnalysisPageCalculated) {
                    AnalysisPageCalculated pageCalc = (AnalysisPageCalculated)page;
                    pageCalc.showHeader(true);
                }
                if (page instanceof AnalysisPageBasic) {
                    basicPage = (AnalysisPageBasic)page;
                    basicPage.setContextHelpId(contextHelpId);
                } else if (TextDisplaySubpage.class.isAssignableFrom(pageClass)) {
                    textPage = (TextDisplaySubpage)page;
                    textPage.setContextHelpId(contextHelpId);
                }
                dialog.addPage(page, true);
                dialog.showPage(page);
                if (page instanceof AnalysisPageBasic) {
                    basicPage = (AnalysisPageBasic)page;
                    basicPage.setModel(model);
                } else if (TextDisplaySubpage.class.isAssignableFrom(pageClass)) {
                    textPage = (TextDisplaySubpage)page;
                    textPage.setModel(model);
                }
                IAnalysisPagePresentation topParent = parent;
                while (topParent != null && !(topParent instanceof AnalysisTabbedView)) {
                    topParent = topParent.getParent();
                }
                if (topParent != null) {
                    topParent.addViewToCloseUponClosing((IAnalysisPagePresentation)dialog);
                }
                if (!deferPageFocus) {
                    Singletons.getAnalysisManager().analysisPageFocused(page);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        Point cursor = dialog.getShell().getDisplay().getCursorLocation();
        Rectangle bounds = dialog.getShell().getDisplay().getBounds();
        Point size = new Point(700, 400);
        int x = cursor.x;
        if (x + size.x > bounds.x + bounds.width) {
            x = bounds.x + bounds.width - size.x;
        }
        if (x < bounds.x) {
            x = bounds.x;
        }
        if ((y = cursor.y) + size.y > bounds.y + bounds.height) {
            y = bounds.y + bounds.height - size.y;
        }
        if (y < bounds.y) {
            y = bounds.y;
        }
        dialog.getShell().setBounds(x, y, size.x, size.y);
        dialog.open();
        dialog.getActivePage().getControl().setFocus();
        return dialog;
    }

    public IAnalysisPagePresentation getParent() {
        return this.parent;
    }

    private void setParent(IAnalysisPagePresentation parent) {
        this.parent = parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(700, 400);
    }

    public void addPage(AnalysisPage page, boolean createControl) {
        page.setDSN(this.dsn);
        page.setType(this.analysisType);
        if (createControl) {
            page.createControl(this.viewArea);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = true;
            page.getControl().setLayoutData((Object)gData);
            page.getControl().setVisible(false);
        }
    }

    public void showPage(AnalysisPage newPage) {
        if (this.activePage != null) {
            this.activePage.setMenu(null);
            this.activePage.getControl().setVisible(false);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = true;
            this.activePage.getControl().setLayoutData((Object)gData);
        }
        if (newPage.getControl() == null) {
            newPage.createControl(this.viewArea);
        }
        this.hookSelectionListener(this.activePage, newPage);
        this.activePage = newPage;
        Menu menu = this.menuMgr.createContextMenu(this.activePage.getControl());
        this.activePage.setMenu(menu);
        this.activePage.getControl().setVisible(true);
        this.activePage.setPresentation((IAnalysisPagePresentation)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.activePage.getControl(), this.activePage.getContextHelpId());
        GridData gData = new GridData(4, 4, true, true);
        gData.exclude = false;
        this.activePage.getControl().setLayoutData((Object)gData);
        this.viewArea.layout();
        this.updateTitle();
    }

    public AnalysisPage getActivePage() {
        return this.activePage;
    }

    public String getDSN() {
        return this.dsn;
    }

    public void setDSN(String dsn) {
        this.dsn = dsn;
    }

    public void setAnalysisType(int type) {
        this.analysisType = type;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getActivePageID() {
        if (this.activePage != null) {
            return this.activePage.getId();
        }
        return null;
    }

    public int getAnalysisType() {
        return this.analysisType;
    }

    public void addViewToCloseUponClosing(IAnalysisPagePresentation view) {
    }

    public void removeViewToCloseUponClosing(IAnalysisPagePresentation view) {
    }

    public AnalysisPage getCurrentPage() {
        return this.activePage;
    }

    protected void updateTitle() {
        if (this.fixedSubtitle == null) {
            String additionalText;
            String type = "unknown";
            if (this.analysisType == 1) {
                type = "ALL";
            }
            if (this.analysisType == 0) {
                type = "NORMAL";
            }
            if (this.analysisType == 2) {
                type = "ACTIVE";
            }
            if (this.analysisType == 3) {
                type = "WAIT";
            }
            this.subTitleLabel.setVisible(true);
            String subTitleText = String.format("Analysis for: %1$s DSN: %2$s analysis type: %3$s", this.profile, this.dsn, type);
            if (this.activePage instanceof AnalysisPageBasic && !(additionalText = ((AnalysisPageBasic)this.activePage).getAdditionalTitleText()).equals("")) {
                subTitleText = String.valueOf(subTitleText) + ", " + additionalText;
            }
            this.subTitleLabel.setText(subTitleText);
        }
    }

    public void overrideSubtitle(String subtitle) {
        this.fixedSubtitle = subtitle;
        this.subTitleLabel.setText(this.fixedSubtitle);
    }

    public void hookSelectionListener(AnalysisPage oldPage, AnalysisPage newPage) {
        if (oldPage != null && oldPage.getSelectionProvider() != null) {
            oldPage.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (newPage != null && newPage.getSelectionProvider() != null) {
            newPage.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void setPresentationName(String name) {
        this.getShell().setText(name);
    }

    public ISelection getSelection() {
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setGlobalSelection(event.getSelection());
    }

    private void setGlobalSelection(ISelection selection) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
        IEvaluationContext context = evaluationService.getCurrentState();
        context.addVariable("selection", (Object)selection);
    }

    private void buildContextMenu() {
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        this.menuMgr = new MenuManager("menu", "popup:com.ca.mat.views.analysisview?after=additions");
        menuService.populateContributionManager((ContributionManager)this.menuMgr, "popup:com.ca.mat.views.analysisview");
        Menu menu = this.menuMgr.createContextMenu((Control)this.viewArea);
        this.viewArea.setMenu(menu);
        if (this.activePage != null) {
            this.activePage.setMenu(menu);
        }
        if (this.menuMgr.getItems().length == 0) {
            this.buildContextMenuE42(this.menuMgr);
            this.menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    AnalysisPageDialog.this.updateContextMenuE42(manager);
                }
            });
        }
    }

    private void buildContextMenuE42(MenuManager menuMgr) {
        Workbench workbench = (Workbench)PlatformUI.getWorkbench();
        MApplication application = (MApplication)workbench.getContext().get(MApplication.class);
        List items = application.getMenuContributions();
        for (MMenuContribution item : items) {
            if (!item.getParentId().equals("com.ca.mat.views.analysisview")) continue;
            for (MMenuElement menuItem : item.getChildren()) {
                Separator contribItem;
                if (menuItem instanceof MenuSeparatorImpl) {
                    contribItem = new Separator();
                    menuMgr.add((IContributionItem)contribItem);
                    continue;
                }
                menuItem.getElementId();
                contribItem = new CommandContributionItem((IServiceLocator)workbench, menuItem.getElementId(), menuItem.getElementId(), null, null, null, null, menuItem.getLabel(), menuItem.getMnemonics(), menuItem.getTooltip(), 8);
                menuMgr.add((IContributionItem)contribItem);
            }
        }
    }

    private void updateContextMenuE42(IMenuManager manager) {
        IContributionItem[] items = manager.getItems();
        manager.removeAll();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            manager.add(item);
            if (item.getId() != null && item.getId().equals("org.eclipse.ui.edit.selectAll")) {
                item.setVisible(this.getActivePage() instanceof TextDisplaySubpage);
            } else {
                item.setVisible(item.isEnabled());
            }
            ++n2;
        }
        manager.update();
    }

    public void closePresentation() {
        this.activePage.dispose();
        this.activePage = null;
        this.close();
    }
}

