/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IMSReportRowModel;
import com.ca.mat.views.pages.AnalysisPageBasic;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IMSPage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID = "com.ca.mat.pages.ims";
    public static final String SECTION_NAME = "IMS TranNameView";
    private static final String HEADER_SECTION_NAME = "IMS Region Information Report";
    private static final String VIEWER_MEMENTO_TYPE = "pages.ims.viewer";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.imsview";
    public static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.imsview.imsstatementdetailsline";
    private Label regActive;
    private Label regActivePercent;
    private Label regIdle;
    private Label regIdlePercent;
    private Label regTotal;
    private Label regTotalPercent;
    private Label avgElapsed;
    private Label ctlReg;
    private Label msgRegLabel;
    private Label msgReg;
    private Label imsId;

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        AnalysisManager manager = Singletons.getAnalysisManager();
        MATTableModel model = null;
        model = manager.getModel(this.dsn, SECTION_NAME, this.type);
        viewer.addColumn("TranCode", 5, "TranCode", 1, true, false);
        viewer.addColumn("PSB Name", 5, "PSB Name", 1, false, true);
        viewer.addColumn("Tran Count", 5, "Tran Count", 2, true, true);
        viewer.addColumn("Total Elapsed Time (sec)", 5, "Total Elapsed Time (sec)", 11, true, true);
        viewer.addColumn("Avg Elapsed Time (sec)", 5, "Avg Elapsed Time (sec)", 11, true, true);
        viewer.addColumn("DL/I Call Interface", 5, "DL/I Call Interface", 1, true, true);
        viewer.addColumn("CPU Time (cpu sec)", 5, "CPU Time (cpu sec)", 11, true, true);
        viewer.addColumn("CPU Avg. (cpu sec)", 5, "CPU Avg. (cpu sec)", 11, true, true);
        viewer.setSortColumn(3);
        viewer.setSortDirection(1024);
        this.setModel(model);
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        this.setModel(model);
    }

    @Override
    public void createHeaderPart(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        wrapper.setLayoutData((Object)gridData);
        Composite group1 = new Composite(wrapper, 0);
        group1.setLayout((Layout)new GridLayout(3, false));
        this.addNewLabel(group1, "Region Active:");
        this.regActive = this.addNewField(group1, "N/A");
        this.regActivePercent = this.addNewField(group1, "");
        this.addNewLabel(group1, "Region Idle:");
        this.regIdle = this.addNewField(group1, "N/A");
        this.regIdlePercent = this.addNewField(group1, "");
        this.addNewLabel(group1, "Region Total:");
        this.regTotal = this.addNewField(group1, "N/A");
        this.regTotalPercent = this.addNewField(group1, "");
        this.addNewLabel(group1, "Average elapsed:");
        this.avgElapsed = this.addNewField(group1, "N/A");
        this.addNewField(group1, "(all transactions)");
        Composite group2 = new Composite(wrapper, 0);
        group2.setLayout((Layout)new GridLayout(2, false));
        this.addNewLabel(group2, "CTL Region:");
        this.ctlReg = this.addNewField(group2, "N/A");
        this.msgRegLabel = this.addNewLabel(group2, "Region:");
        this.msgReg = this.addNewField(group2, "N/A");
        this.addNewLabel(group2, "IMS ID:");
        this.imsId = this.addNewField(group2, "N/A");
        AnalysisManager manager = Singletons.getAnalysisManager();
        MATTableModel model = manager.getModel(this.dsn, HEADER_SECTION_NAME, this.type);
        this.setHeaderModel(model);
    }

    private Label addNewLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(text);
        return label;
    }

    private Label addNewField(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setFont(JFaceResources.getTextFont());
        label.setText(text);
        return label;
    }

    public void setHeaderModel(MATTableModel model) {
        if (model != null && !model.isEmpty() && model.getRows()[0] instanceof IMSReportRowModel) {
            IMSReportRowModel row = (IMSReportRowModel)model.getRows()[0];
            this.regActive.setText(row.getRegionActive(false));
            this.regActivePercent.setText("(" + row.getRegionActive(true) + ")");
            this.regIdle.setText(row.getRegionIdle(false));
            this.regIdlePercent.setText("(" + row.getRegionIdle(true) + ")");
            this.regTotal.setText(row.getRegionTotal(false));
            this.regTotalPercent.setText("(" + row.getRegionTotal(true) + ")");
            this.avgElapsed.setText(row.getAvgElapsed());
            this.ctlReg.setText(row.getCTLRegion());
            this.msgRegLabel.setText(String.valueOf(row.getMsgRegionType()) + " Region:");
            this.msgReg.setText(row.getMsgRegion());
            this.imsId.setText(row.getIMSId());
        }
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }
}

