/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.Activator;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.XMLFileRowModel;
import com.ca.mat.views.IMATView;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class LocalXMLFilesView
extends ViewPart
implements IDoubleClickListener,
IMATView {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private IMATTableViewer viewer;
    public static final String ID = "com.ca.mat.views.localxmlfilesview";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.localview";
    private static final String ANALYZE = "com.ca.mat.commands.analyzelocal";
    public static final String VIEWER_MEMENTO_TYPE = "localXMLFiles.viewer";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.viewer = MATTableViewerFactory.createNew(parent, 66306);
        this.viewer.addColumn("Profile", 5, null, 1);
        this.viewer.addColumn("DSN", 6, null, 1);
        this.viewer.addDoubleClickListener(this);
        Singletons.getAnalysisManager().registerLocalXMLView(this);
        Singletons.getViewerSynchronizationManager().addViewer(VIEWER_MEMENTO_TYPE, this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setDefaultSortColumn(0);
        this.refreshModel();
    }

    public void refreshModel() {
        final MATTableModel model = new MATTableModel();
        IPath localXMLPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
        localXMLPath = localXMLPath.append("analysis");
        File f = localXMLPath.toFile();
        this.populateModel(f, model, true);
        this.viewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LocalXMLFilesView.this.viewer.setCATableModel(model);
            }
        });
    }

    private void populateModel(File dir, MATTableModel model, boolean top) {
        if (dir.exists() && dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.toString() != null && !file.toString().equals("") && (file.getName().endsWith(".xml") || file.isDirectory())) {
                    if (file.isDirectory()) {
                        this.populateModel(file, model, false);
                    } else {
                        XMLFileRowModel row = this.createRowFromPartialModel(model, file.getName(), top ? null : dir.getName());
                        if (row != null) {
                            model.addRow(row);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private XMLFileRowModel createRowFromPartialModel(MATTableModel model, String filename, String profile) {
        XMLFileRowModel result = null;
        if (filename.matches(".+(_ALL\\.|_NORMAL\\.|_ACTIVE\\.|_WAIT\\.).+")) {
            boolean found = false;
            String dsn = filename.replaceAll("_ALL.+$", "").replaceAll("_NORMAL.+$", "").replaceAll("_ACTIVE.+$", "").replaceAll("_WAIT.+$", "");
            MATTableRow[] mATTableRowArray = model.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                if (row instanceof XMLFileRowModel) {
                    XMLFileRowModel xmlFileRow = (XMLFileRowModel)row;
                    if (xmlFileRow != null && dsn.equals(xmlFileRow.getDsn()) && profile.equals(xmlFileRow.getProfile())) {
                        found = true;
                        break;
                    }
                } else {
                    result = null;
                }
                ++n2;
            }
            result = !found ? new XMLFileRowModel(model, profile, dsn) : null;
        } else {
            result = new XMLFileRowModel(model, profile, filename);
        }
        return result;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void doubleClick(DoubleClickEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            service.executeCommand(ANALYZE, null);
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Autonavigation failed", e);
        }
    }

    public void dispose() {
        Singletons.getAnalysisManager().removeLocalXMLView(this);
        Singletons.getViewerSynchronizationManager().removeViewer(this.viewer);
        super.dispose();
    }

    public IMATTableViewer getViewer() {
        return this.viewer;
    }
}

