/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels.tuntables;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class Tun4GLSRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String LIBRARY = "library";
    public static final String ROUTINE = "routine";
    Logger log = Logger.getLogger(this.getClass().getName());
    private String gl4key = "";
    private String gl4lang = "";
    private String gl4rtnnm = "";
    private String gl4libnm = "";
    private Integer gl4stmt = null;
    private String gl4src = "";
    private Double gl4cpu = null;
    private Double gl4wait = null;
    private String gl4srcvr = "";

    public Tun4GLSRowModel() {
        super(null);
    }

    public Tun4GLSRowModel(MATTableModel model) {
        super(model);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        Tun4GLSRowModel result = new Tun4GLSRowModel(model);
        String value = attr.getValue("GL4KEY");
        if (value != null) {
            result.gl4key = value.trim();
        }
        if ((value = attr.getValue("GL4LANG")) != null) {
            result.gl4lang = value.trim();
        }
        if ((value = attr.getValue("GL4RTNNM")) != null) {
            result.gl4rtnnm = value.trim();
        }
        if ((value = attr.getValue("GL4LIBNM")) != null) {
            result.gl4libnm = value.trim();
        }
        if ((value = attr.getValue("GL4STMT")) != null) {
            result.gl4stmt = Integer.valueOf(value);
        }
        if ((value = attr.getValue("GL4SRC")) != null) {
            result.gl4src = value.trim();
        }
        if ((value = attr.getValue("GL4CPU")) != null) {
            result.gl4cpu = Double.valueOf(value);
        }
        if ((value = attr.getValue("GL4WAIT")) != null) {
            result.gl4wait = Double.valueOf(value);
        }
        if ((value = attr.getValue("GL4SRCVR")) != null) {
            result.gl4srcvr = value.trim();
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.gl4key, this.gl4lang, this.gl4rtnnm, this.gl4libnm, this.gl4stmt, this.gl4src, this.gl4cpu, this.gl4wait, this.gl4srcvr};
    }

    public Integer getStatement() {
        return this.gl4stmt;
    }

    public String getSourceLine() {
        return this.gl4src;
    }

    public double getCPU() {
        return this.gl4cpu;
    }

    public double getWait() {
        return this.gl4wait;
    }

    public String getRoutine() {
        return this.gl4rtnnm;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (LIBRARY.equals(fieldName)) {
            return this.gl4libnm != null && this.gl4libnm.equals(value);
        }
        if (ROUTINE.equals(fieldName)) {
            return this.gl4rtnnm != null && this.gl4rtnnm.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }
}

