/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.rowmodels.LongNameTableRowModel;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class WASViewRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String sourceClass = WASViewRowModel.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private String tranurl = "";
    private Double exepct = null;
    private Double invpct = null;
    private Double volpct = null;
    private Double totpct = null;
    private Integer trncount = null;
    private Double totrespt = null;
    private Double avgrespt = null;
    private Double maxrespt = null;
    private Double minrespt = null;
    private String URLFinal;
    public static final String FILTER_TRANURL = "tranurl";

    public WASViewRowModel() {
        this(null);
    }

    public WASViewRowModel(MATTableModel model) {
        super(model);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        WASViewRowModel result = new WASViewRowModel(model);
        String value = null;
        value = attr.getValue("TRANURL");
        if (value != null) {
            result.tranurl = value.trim();
        }
        if ((value = attr.getValue("TRNCOUNT")) != null) {
            result.trncount = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TOTRESPT")) != null) {
            result.totrespt = Double.valueOf(value);
        }
        if ((value = attr.getValue("AVGRESPT")) != null) {
            result.avgrespt = Double.valueOf(value);
        }
        if ((value = attr.getValue("MAXRESPT")) != null) {
            result.maxrespt = Double.valueOf(value);
        }
        if ((value = attr.getValue("MINRESPT")) != null) {
            result.minrespt = Double.valueOf(value);
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.getURLNameTranslated(), this.exepct, this.invpct, this.volpct, this.totpct, this.trncount, this.totrespt, this.avgrespt, this.maxrespt, this.minrespt};
    }

    public String getURLName() {
        return this.tranurl;
    }

    public String getURLNameTranslated() {
        if (this.URLFinal == null) {
            String value = null;
            MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("LongName", new Object[]{"WAS"});
            arguments.put("SubType", new Object[]{"TRANURL"});
            arguments.put("ShrtName", new Object[]{this.tranurl});
            if (longNames != null) {
                longNames = longNames.filterBy(arguments);
            }
            if (longNames != null && longNames.getRows().length > 0) {
                value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
            }
            if (value != null) {
                this.URLFinal = value;
            }
        }
        return this.URLFinal;
    }

    public String getTranURL() {
        return this.tranurl;
    }

    public void setExepct(Double exepct) {
        this.exepct = exepct;
    }

    public void setInvpct(Double invpct) {
        this.invpct = invpct;
    }

    public void setVolpct(Double volpct) {
        this.volpct = volpct;
    }

    public void setTotpct(Double totpct) {
        this.totpct = totpct;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (FILTER_TRANURL.equals(fieldName)) {
            return this.tranurl != null && this.tranurl.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public int getTotCount() {
        return this.trncount;
    }

    public double getTotResp() {
        return this.totrespt;
    }

    public double getAvgResp() {
        return this.avgrespt;
    }

    public double getMaxResp() {
        return this.maxrespt;
    }

    public double getMinResp() {
        return this.minrespt;
    }
}

