/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.xml.XMLRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class HistoryOpenHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Display display = HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object item : selection) {
            if (!(item instanceof MonitorProfileRowModel)) continue;
            this.openHistory((MonitorProfileRowModel)item, display);
        }
        return null;
    }

    private void openHistory(MonitorProfileRowModel element, Display display) {
        try {
            Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ca.mat.views.monitorhistoryview", element.getProfileName(), 1);
            MonitorManager mManager = Singletons.getMonitorManager(display);
            String profile = element.getProfileName();
            if (mManager.getHistoryStatus(profile) != 2) {
                UpdateHistory callback = new UpdateHistory(profile);
                ServerProxy serverProxy = Singletons.getServerProxy(display);
                serverProxy.listHistory(element.getProfileName(), 2, callback, true);
                mManager.historyDownloadStarted(profile);
            }
        }
        catch (SWTException e) {
            if ("Device is disposed".equals(e.getMessage())) {
                return;
            }
            throw e;
        }
        catch (PartInitException e) {
            Logger log = Logging.getLogger(Activator.plugin.getWorkbench().getDisplay());
            log.log(Level.WARNING, "Failed to open monitor history view", e);
        }
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager().unregisterTempFile(reply.getAttachedFile());
        }
    }

    private class UpdateHistory
    implements ServerCallback {
        String profile;

        public UpdateHistory(String profile) {
            this.profile = profile;
        }

        @Override
        public void processReply(XMLRequest reply, MATServer server) {
            if (server.equals(Singletons.getServerProxy(server.getDisplay()).getConnectedServer())) {
                try {
                    MonitorManager mManager = Singletons.getMonitorManager(server.getDisplay());
                    mManager.historyDownloadFinished(server, this.profile, reply);
                    Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ca.mat.views.monitorhistoryview", this.profile, 1);
                }
                catch (PartInitException e1) {
                    Logger log = Logging.getLogger(Activator.plugin.getWorkbench().getDisplay());
                    log.log(Level.WARNING, "Failed to open Monitor History view", e1);
                }
                catch (Exception e) {
                    Logger log = Logging.getLogger(server.getDisplay());
                    log.log(Level.WARNING, "Failed to read monitor history records", e);
                }
            }
        }

        @Override
        public void cancel(XMLRequest reply, MATServer server) {
            MonitorManager mManager = Singletons.getMonitorManager(server.getDisplay());
            mManager.historyDownloadFailed(this.profile);
            HistoryOpenHandler.this.deleteTempFile(reply);
        }

        @Override
        public boolean abort(XMLRequest reply, MATException e, MATServer server) {
            MonitorManager mManager = Singletons.getMonitorManager(server.getDisplay());
            mManager.historyDownloadFailed(this.profile);
            HistoryOpenHandler.this.deleteTempFile(reply);
            return false;
        }
    }
}

