/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.Activator;
import com.ca.mat.MATException;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.xml.XMLRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.PartInitException;

public class MonitorHistoryServerCallback
implements ServerCallback {
    String profile;
    boolean showView;

    public MonitorHistoryServerCallback(String profile, boolean showView) {
        this.profile = profile;
        this.showView = showView;
    }

    @Override
    public void processReply(XMLRequest reply, MATServer server) {
        if (server.equals(Singletons.getServerProxy(server.getDisplay()).getConnectedServer())) {
            try {
                MonitorManager mManager = Singletons.getMonitorManager(server.getDisplay());
                mManager.historyDownloadFinished(server, this.profile, reply);
                if (this.showView) {
                    Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ca.mat.views.monitorhistoryview", this.profile, 1);
                }
            }
            catch (PartInitException e1) {
                Logger log = Logging.getLogger(Activator.plugin.getWorkbench().getDisplay());
                log.log(Level.WARNING, "Failed to open Monitor History view", e1);
            }
            catch (Exception e) {
                Logger log = Logging.getLogger(server.getDisplay());
                log.log(Level.WARNING, "Failed to read monitor history records", e);
            }
        }
    }

    @Override
    public void cancel(XMLRequest reply, MATServer server) {
        MonitorManager mManager = Singletons.getMonitorManager(server.getDisplay());
        mManager.historyDownloadFailed(this.profile);
        this.deleteTempFile(reply);
    }

    @Override
    public boolean abort(XMLRequest reply, MATException e, MATServer server) {
        MonitorManager mManager = Singletons.getMonitorManager(server.getDisplay());
        mManager.historyDownloadFailed(this.profile);
        this.deleteTempFile(reply);
        return false;
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager().unregisterTempFile(reply.getAttachedFile());
        }
    }
}

