/*
 * Decompiled with CFR 0.152.
 */
package com.ca.endevor.dez.rse;

import com.ca.endevor.core.utils.CAException;
import com.ca.endevor.element.CreateElement;
import com.ca.endevor.element.actionopts.AddActionOptions;
import com.ca.endevor.ui.UIPlugin;
import com.ca.endevor.ui.actions.AbstractActionDelegate;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AddToEndevorFromRSEAction
extends AbstractActionDelegate {
    private static final Logger LOGGER = Logger.getLogger(AddToEndevorFromRSEAction.class);
    protected IStructuredSelection m_selection;

    public final void run(IAction action) {
        IWorkbench workbench;
        IWorkbenchWindow activeWindow;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"run(IAction) - start");
        }
        if ((activeWindow = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("run(IAction action=" + action + ") - end"));
            }
            return;
        }
        Iterator selections = this.m_selection.iterator();
        while (selections.hasNext()) {
            AddActionOptions addOptions = new AddActionOptions();
            addOptions.setAddStyle(1);
            Object file = selections.next();
            if (file instanceof IRemoteFile) {
                IRemoteFile ussFile = (IRemoteFile)file;
                addOptions.setFromUSSPath(ussFile.getParentPath());
                addOptions.setFromUSSFile(ussFile.getName());
            }
            if (file instanceof MVSFileResource) {
                MVSFileResource zosFile = (MVSFileResource)file;
                MVSFileResource zosParent = zosFile.getParentRemoteFile();
                if (zosFile.isFile()) {
                    String memberName = zosFile.getNameWithExt();
                    String memberExt = zosFile.getFileExtension();
                    if (memberExt != null && !memberExt.isEmpty()) {
                        int index = memberName.lastIndexOf(memberExt);
                        memberName = memberName.substring(0, index - 1);
                    }
                    addOptions.setFromDSN(zosParent.getName());
                    addOptions.setFromMember(memberName);
                } else {
                    addOptions.setFromDSN(zosFile.getName());
                }
            }
            ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(activeWindow.getShell());
            try {
                pmDialog.run(true, true, (IRunnableWithProgress)new CreateElement(addOptions, null));
            }
            catch (InvocationTargetException e1) {
                UIPlugin.logError((Throwable)e1);
            }
            catch (InterruptedException e1) {
                UIPlugin.logError((Throwable)e1);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("run(IAction action=" + action + ") - end"));
        }
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"selectionChanged(IAction, ISelection) - start");
        }
        if (selection instanceof IStructuredSelection) {
            this.m_selection = (IStructuredSelection)selection;
            if (action != null) {
                try {
                    action.setEnabled(action.isEnabled() && this.isEnabled());
                }
                catch (CAException e) {
                    LOGGER.error((Object)"selectionChanged(IAction, ISelection)", (Throwable)e);
                    action.setEnabled(false);
                    UIPlugin.log((IStatus)e.getStatus());
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("selectionChanged(IAction action=" + action + ", ISelection selection=" + selection + ") - end"));
        }
    }
}

