/*
 * Decompiled with CFR 0.152.
 */
package com.ca.endevor.dez.copybook;

import com.ca.endevor.core.utils.FileUtils;
import com.ca.endevor.core.utils.IOUtils;
import com.ca.endevor.core.utils.WSUtils;
import com.ca.endevor.element.TempFileManager;
import com.ca.endevor.element.actionopts.RetrieveActionOptions;
import com.ca.endevor.jobs.EndevorPluginJobManager;
import com.ca.endevor.jobs.SubmitSCLJob;
import com.ca.endevor.jobs.elements.RetrieveElementJob;
import com.ca.endevor.model.Component;
import com.ca.endevor.model.Project;
import com.ca.endevor.model.ProjectController;
import com.ca.endevor.model.entities.BaseElement;
import com.ca.endevor.model.entities.Element;
import com.ca.endevor.model.entities.EndevorModelEntity;
import com.ca.endevor.service.EndevorStatus;
import com.ca.endevor.ui.UIPlugin;
import com.ibm.systemz.cobol.editor.core.copy.parser.Ast.CopyStatement;
import com.ibm.systemz.cobol.editor.core.ftt.FttCopybookProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import lpg.runtime.Monitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;

public class EndevorCopybookProvider
extends FttCopybookProvider {
    private InputStream copybookInputStream = null;

    public EndevorCopybookProvider(CopyStatement copyStatement, IProject project, IFile file, Monitor monitor, boolean useCache, int marginR) {
        super(copyStatement, project, file, monitor, useCache, marginR);
    }

    protected final IPath findCopybookPath(IProject srcProj, IFile srcFile, String library, String copybookName) {
        IFile copybookFile = this.retrieveComponent(srcFile, srcProj, copybookName);
        if (copybookFile == null) {
            this.copybookInputStream = null;
            return super.findCopybookPath(srcProj, srcFile, library, copybookName);
        }
        IPath copybookPath = copybookFile.getFullPath();
        try {
            this.copybookInputStream = copybookFile.getContents();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return copybookPath;
    }

    protected final InputStream getCopybookInputStream() {
        return this.copybookInputStream != null ? this.copybookInputStream : super.getCopybookInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile retrieveComponent(IFile file, IProject project, String copybookName) {
        IFile compFile = null;
        Project endevorProject = (Project)ProjectController.getInstance().getProject(project.getName());
        if (endevorProject == null) {
            return null;
        }
        BaseElement baseEle = TempFileManager.getInstance().getElement(1, file);
        if (baseEle == null || !(baseEle instanceof Element)) {
            return null;
        }
        Element ele = (Element)baseEle;
        List compList = ele.getComponents();
        if (compList == null) {
            return null;
        }
        for (Component component : compList) {
            if (component.getComponentType() != 1) continue;
            ResourceAttributes attributes = new ResourceAttributes();
            attributes.setReadOnly(false);
            InputStream inputStream = null;
            try {
                if (component.getElementName() != null && component.getElementName().equalsIgnoreCase(copybookName)) {
                    compFile = TempFileManager.getInstance().findComponent(component);
                    if (compFile != null) {
                        return compFile;
                    }
                    compFile = FileUtils.getResourceFromDir((String)component.getElementName(), (String)(String.valueOf(file.getName()) + ".comp"), (IProject)UIPlugin.getEclipseProject((String)project.getName()));
                    RetrieveActionOptions options = new RetrieveActionOptions();
                    options.setCcid(endevorProject.getCCID());
                    options.setComment(endevorProject.getDescription());
                    options.setNoSignout(true);
                    RetrieveElementJob retrieveJob = new RetrieveElementJob(endevorProject.getConnectionObject(), (EndevorModelEntity)ele, options);
                    EndevorPluginJobManager.getInstance().scheduleBlocking((Job)retrieveJob);
                    EndevorStatus status = (EndevorStatus)retrieveJob.getResult();
                    inputStream = retrieveJob.getStream();
                    if (inputStream == null || status.getSeverity() == 8 || status.getSeverity() == 4) {
                        return null;
                    }
                }
                if (inputStream == null && component.getMember() != null && component.getMember().equalsIgnoreCase(copybookName)) {
                    compFile = TempFileManager.getInstance().findComponent(component);
                    if (compFile != null) {
                        return compFile;
                    }
                    compFile = FileUtils.getResourceFromDir((String)component.getMember(), (String)(String.valueOf(file.getName()) + ".comp"), (IProject)UIPlugin.getEclipseProject((String)project.getName()));
                    String requestSCL = "PRINT MEMBER '" + component.getMember() + "' FROM DSNAME '" + component.getDsn() + "' TO LOCALFILE .";
                    SubmitSCLJob submitJob = new SubmitSCLJob(endevorProject.getConnectionObject(), requestSCL, "E", null, InputStream.class);
                    EndevorPluginJobManager.getInstance().scheduleBlocking((Job)submitJob);
                    inputStream = (InputStream)submitJob.getOutput();
                    if (inputStream == null || submitJob.getResult().getSeverity() == 4) {
                        return null;
                    }
                    String report = IOUtils.readInputStreamToString((InputStream)inputStream);
                    String printedMember = WSUtils.removeHeadersFromReport((String)report);
                    inputStream = new ByteArrayInputStream(printedMember.getBytes());
                }
                if (inputStream == null) continue;
                if (!compFile.exists()) {
                    compFile.create(inputStream, true, null);
                } else {
                    compFile.setResourceAttributes(attributes);
                    compFile.setContents(inputStream, true, false, null);
                }
                attributes.setReadOnly(true);
                compFile.setResourceAttributes(attributes);
                TempFileManager.getInstance().addComponent(compFile, component);
                return compFile;
            }
            catch (CoreException e) {
                UIPlugin.logError((Throwable)e);
                return null;
            }
        }
        return null;
    }
}

