/*
 * Decompiled with CFR 0.152.
 */
package com.ca.endevor.dez.copybook;

import com.ca.endevor.core.utils.FileUtils;
import com.ca.endevor.core.utils.IOUtils;
import com.ca.endevor.core.utils.WSUtils;
import com.ca.endevor.element.ElementDescriptor;
import com.ca.endevor.element.TempFileManager;
import com.ca.endevor.model.Component;
import com.ca.endevor.model.ElementViewElement;
import com.ca.endevor.model.IProject;
import com.ca.endevor.model.Project;
import com.ca.endevor.model.ProjectList;
import com.ca.endevor.service.PrintSCLActions;
import com.ca.endevor.service.ResultsPkg;
import com.ca.endevor.service.RetrieveSCLAction;
import com.ca.endevor.service.stub.EndevorServiceStub;
import com.ca.endevor.ui.UIPlugin;
import com.ibm.systemz.cobol.editor.core.copy.parser.Ast.CopyStatement;
import com.ibm.systemz.cobol.editor.core.ftt.FttCopybookProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import lpg.runtime.Monitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class EndevorCopybookProvider
extends FttCopybookProvider {
    private InputStream copybookInputStream = null;

    public EndevorCopybookProvider(CopyStatement copyStatement, org.eclipse.core.resources.IProject project, IFile file, Monitor monitor, boolean useCache, int marginR) {
        super(copyStatement, project, file, monitor, useCache, marginR);
    }

    protected final IPath findCopybookPath(org.eclipse.core.resources.IProject srcProj, IFile srcFile, String library, String copybookName) {
        IFile copybookFile = this.retrieveComponent(srcFile, srcProj, copybookName);
        if (copybookFile == null) {
            this.copybookInputStream = null;
            return super.findCopybookPath(srcProj, srcFile, library, copybookName);
        }
        IPath copybookPath = copybookFile.getFullPath();
        try {
            this.copybookInputStream = copybookFile.getContents();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return copybookPath;
    }

    protected final InputStream getCopybookInputStream() {
        return this.copybookInputStream != null ? this.copybookInputStream : super.getCopybookInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile retrieveComponent(IFile file, org.eclipse.core.resources.IProject project, String copybookName) {
        IFile compFile = null;
        Project endevorProject = (Project)ProjectList.getInstance().getProject(project.getName());
        if (endevorProject == null) {
            return null;
        }
        ElementViewElement ele = TempFileManager.getInstance().getElement(1, file);
        if (ele == null) {
            return null;
        }
        List compList = ele.getComponents();
        if (compList == null) {
            return null;
        }
        for (Component component : compList) {
            if (component.getComponentType() != Component.INPUT_COMPONENT) continue;
            ResourceAttributes attributes = new ResourceAttributes();
            attributes.setReadOnly(false);
            ResultsPkg pkg = null;
            ByteArrayInputStream inputStream = null;
            try {
                if (component.getElement() != null && component.getElement().equalsIgnoreCase(copybookName)) {
                    EndevorServiceStub.Attachments part;
                    DataHandler dataHandler;
                    compFile = TempFileManager.getInstance().findComponent(component);
                    if (compFile != null) {
                        return compFile;
                    }
                    ElementDescriptor eleDesc = component.getElementDescriptor((IProject)endevorProject);
                    compFile = FileUtils.getResourceFromDir((String)component.getElement(), (String)(String.valueOf(file.getName()) + ".comp"), (org.eclipse.core.resources.IProject)UIPlugin.getEclipseProject((String)project.getName()));
                    RetrieveSCLAction retrieveSCLA = new RetrieveSCLAction();
                    pkg = retrieveSCLA.retrieveElement(endevorProject, eleDesc, null, null);
                    if (pkg == null || pkg.getRetcode() > 8) {
                        return null;
                    }
                    Object[] attachments = (Object[])pkg.getStream();
                    if (attachments == null) {
                        return null;
                    }
                    if (attachments[0] instanceof EndevorServiceStub.Attachments && (dataHandler = (part = (EndevorServiceStub.Attachments)attachments[0]).getDD()) != null) {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        dataHandler.writeTo((OutputStream)buffer);
                        inputStream = new ByteArrayInputStream(buffer.toByteArray());
                    }
                }
                if (inputStream == null && component.getMember() != null && component.getMember().equalsIgnoreCase(copybookName)) {
                    compFile = TempFileManager.getInstance().findComponent(component);
                    if (compFile != null) {
                        return compFile;
                    }
                    compFile = FileUtils.getResourceFromDir((String)component.getMember(), (String)(String.valueOf(file.getName()) + ".comp"), (org.eclipse.core.resources.IProject)UIPlugin.getEclipseProject((String)project.getName()));
                    PrintSCLActions retrieveSCLA = new PrintSCLActions();
                    pkg = retrieveSCLA.printMember(endevorProject, component.getDsn(), component.getMember(), null);
                    if (pkg == null || pkg.getRetcode() > 8) {
                        return null;
                    }
                    Object[] attachments = (Object[])pkg.getStream();
                    if (attachments == null) {
                        return null;
                    }
                    if (attachments[0] instanceof EndevorServiceStub.Attachments) {
                        EndevorServiceStub.Attachments part = (EndevorServiceStub.Attachments)attachments[0];
                        DataHandler dataHandler = part.getDD();
                        String report = IOUtils.readAttachmentToString((DataHandler)dataHandler);
                        String printedMember = WSUtils.removeHeadersFromReport((String)report);
                        inputStream = new ByteArrayInputStream(printedMember.getBytes());
                    }
                }
                if (inputStream == null) continue;
                if (!compFile.exists()) {
                    compFile.create(inputStream, true, null);
                } else {
                    compFile.setResourceAttributes(attributes);
                    compFile.setContents(inputStream, true, false, null);
                }
                attributes.setReadOnly(true);
                compFile.setResourceAttributes(attributes);
                TempFileManager.getInstance().addComponent(compFile, component);
                return compFile;
            }
            catch (IOException ex) {
                UIPlugin.logError((Throwable)ex);
                return null;
            }
            catch (CoreException e) {
                UIPlugin.logError((Throwable)e);
                return null;
            }
        }
        return null;
    }
}

